/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioGridReloadEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.CollectionEditorSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.workbench.events.NotificationEvent;

public class ScenarioGridModel
extends BaseGridData {
    public static final int HEADER_ROW_COUNT = 3;
    protected Simulation simulation;
    protected EventBus eventBus;
    protected AtomicInteger columnCounter = new AtomicInteger(0);
    protected GridColumn<?> selectedColumn = null;
    protected Set<String> dataObjectsInstancesName;
    protected Set<String> simpleJavaTypeInstancesName;
    protected CollectionEditorSingletonDOMElementFactory collectionEditorSingletonDOMElementFactory;
    protected ScenarioCellTextAreaSingletonDOMElementFactory scenarioCellTextAreaSingletonDOMElementFactory;
    protected ScenarioHeaderTextBoxSingletonDOMElementFactory scenarioHeaderTextBoxSingletonDOMElementFactory;

    public ScenarioGridModel() {
    }

    public ScenarioGridModel(boolean isMerged) {
        super(isMerged);
        this.setHeaderRowCount(3);
    }

    public void bindContent(Simulation simulation) {
        this.simulation = simulation;
        this.checkSimulation();
        this.columnCounter.set(simulation.getSimulationDescriptor().getUnmodifiableFactMappings().size());
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public int nextColumnCount() {
        return this.columnCounter.getAndIncrement();
    }

    public Map.Entry<String, String> getValidPlaceholders() {
        String propertyTitle;
        String instanceTitle;
        do {
            int nextColumnCount = this.nextColumnCount();
            instanceTitle = FactMapping.getInstancePlaceHolder((int)nextColumnCount);
            propertyTitle = FactMapping.getPropertyPlaceHolder((int)nextColumnCount);
        } while (!this.isNewInstanceName(instanceTitle) || !this.isNewPropertyName(propertyTitle));
        return new AbstractMap.SimpleEntry<String, String>(instanceTitle, propertyTitle);
    }

    public CollectionEditorSingletonDOMElementFactory getCollectionEditorSingletonDOMElementFactory() {
        return this.collectionEditorSingletonDOMElementFactory;
    }

    public void setCollectionEditorSingletonDOMElementFactory(CollectionEditorSingletonDOMElementFactory collectionEditorSingletonDOMElementFactory) {
        this.collectionEditorSingletonDOMElementFactory = collectionEditorSingletonDOMElementFactory;
    }

    public ScenarioCellTextAreaSingletonDOMElementFactory getScenarioCellTextAreaSingletonDOMElementFactory() {
        return this.scenarioCellTextAreaSingletonDOMElementFactory;
    }

    public void setScenarioCellTextAreaSingletonDOMElementFactory(ScenarioCellTextAreaSingletonDOMElementFactory scenarioCellTextAreaSingletonDOMElementFactory) {
        this.scenarioCellTextAreaSingletonDOMElementFactory = scenarioCellTextAreaSingletonDOMElementFactory;
    }

    public ScenarioHeaderTextBoxSingletonDOMElementFactory getScenarioHeaderTextBoxSingletonDOMElementFactory() {
        return this.scenarioHeaderTextBoxSingletonDOMElementFactory;
    }

    public void setScenarioHeaderTextBoxSingletonDOMElementFactory(ScenarioHeaderTextBoxSingletonDOMElementFactory scenarioHeaderTextBoxSingletonDOMElementFactory) {
        this.scenarioHeaderTextBoxSingletonDOMElementFactory = scenarioHeaderTextBoxSingletonDOMElementFactory;
    }

    public void appendRow(GridRow row) {
        this.checkSimulation();
        super.appendRow(row);
        int rowIndex = this.getRowCount() - 1;
        this.commonAddRow(rowIndex);
    }

    public void insertRowGridOnly(int rowIndex, GridRow row, Scenario scenario) {
        this.checkSimulation();
        super.insertRow(rowIndex, row);
        scenario.getUnmodifiableFactMappingValues().forEach(value -> {
            FactIdentifier factIdentifier = value.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = value.getExpressionIdentifier();
            if (value.getRawValue() != null && !(value.getRawValue() instanceof String)) {
                throw new UnsupportedOperationException("Only string is supported at the moment");
            }
            String stringValue = (String)value.getRawValue();
            int columnIndex = this.simulation.getSimulationDescriptor().getIndexByIdentifier(factIdentifier, expressionIdentifier);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            String placeHolder = ((ScenarioGridColumn)((Object)((Object)this.columns.get(columnIndex)))).getPlaceHolder();
            this.setCell(rowIndex, columnIndex, () -> {
                ScenarioGridCell newCell = new ScenarioGridCell(new ScenarioGridCellValue(stringValue, placeHolder));
                if (ScenarioSimulationSharedUtils.isCollection((String)factMappingByIndex.getClassName())) {
                    newCell.setListMap(ScenarioSimulationSharedUtils.isList((String)factMappingByIndex.getClassName()));
                }
                return newCell;
            });
        });
        this.updateIndexColumn();
    }

    public void insertRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        super.insertRow(rowIndex, row);
        this.commonAddRow(rowIndex);
    }

    public GridData.Range deleteRow(int rowIndex) {
        this.checkSimulation();
        GridData.Range toReturn = super.deleteRow(rowIndex);
        this.simulation.removeScenarioByIndex(rowIndex);
        this.updateIndexColumn();
        return toReturn;
    }

    public void duplicateRow(int rowIndex, GridRow row) {
        this.checkSimulation();
        int newRowIndex = rowIndex + 1;
        Scenario toDuplicate = this.simulation.cloneScenario(rowIndex, newRowIndex);
        this.insertRowGridOnly(newRowIndex, row, toDuplicate);
    }

    public void duplicateColumnValues(int originalColumnIndex, int newColumnIndex) {
        this.checkSimulation();
        ArrayList originalValues = new ArrayList();
        IntStream.range(0, this.getRowCount()).forEach(rowIndex -> originalValues.add(this.getCell(rowIndex, originalColumnIndex).getValue()));
        IntStream.range(0, this.getRowCount()).forEach(rowIndex -> this.setCellValue(rowIndex, newColumnIndex, (GridCellValue)originalValues.get(rowIndex)));
    }

    public void insertColumnGridOnly(int index, GridColumn<?> column) {
        this.checkSimulation();
        super.insertColumn(index, column);
    }

    public void insertColumn(int index, GridColumn<?> column) {
        this.checkSimulation();
        this.commonAddColumn(index, column);
    }

    public void deleteColumn(int columnIndex) {
        this.checkSimulation();
        GridColumn toDelete = (GridColumn)this.getColumns().get(columnIndex);
        this.deleteColumn(toDelete);
        this.simulation.removeFactMappingByIndex(columnIndex);
    }

    public void deleteInstance(int columnIndex) {
        this.checkSimulation();
        GridData.Range instanceRange = this.getInstanceLimits(columnIndex);
        IntStream.iterate(instanceRange.getMaxRowIndex(), i -> i - 1).limit((long)(instanceRange.getMaxRowIndex() - instanceRange.getMinRowIndex()) + 1L).forEach(this::deleteColumn);
    }

    public void updateColumnInstance(int columnIndex, GridColumn<?> column) {
        this.checkSimulation();
        this.replaceColumn(columnIndex, column);
    }

    public void updateColumnProperty(int columnIndex, GridColumn<?> column, List<String> propertyNameElements, String lastLevelClassName, boolean keepData) {
        this.checkSimulation();
        ArrayList originalValues = new ArrayList();
        if (keepData) {
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> originalValues.add(this.getCell(rowIndex, columnIndex).getValue()));
        }
        this.replaceColumn(columnIndex, column);
        FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        List<String> propertyNameElementsClone = ScenarioSimulationUtils.getPropertyNameElementsWithoutAlias(propertyNameElements, factMappingByIndex.getFactIdentifier());
        IntStream.range(0, propertyNameElementsClone.size()).forEach(stepIndex -> factMappingByIndex.addExpressionElement((String)propertyNameElementsClone.get(stepIndex), lastLevelClassName));
        if (keepData) {
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> this.setCellValue(rowIndex, columnIndex, (GridCellValue)originalValues.get(rowIndex)));
        }
    }

    protected void replaceColumn(int columnIndex, GridColumn<?> column) {
        List widthsToRestore = this.getColumns().stream().map(GridColumn::getWidth).collect(Collectors.toList());
        this.deleteColumn(columnIndex);
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(columnIndex, column, ei);
        IntStream.range(0, widthsToRestore.size()).forEach(index -> ((GridColumn)this.getColumns().get(index)).setWidth(((Double)widthsToRestore.get(index)).doubleValue()));
    }

    public GridData.Range setCellGridOnly(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        return super.setCell(rowIndex, columnIndex, cellSupplier);
    }

    public GridData.Range setCell(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        GridData.Range toReturn = super.setCell(rowIndex, columnIndex, cellSupplier);
        try {
            Optional<?> optionalValue = this.getCellValue(this.getCell(rowIndex, columnIndex));
            Object rawValue = optionalValue.orElse(null);
            String cellValue = rawValue instanceof String ? (String)rawValue : null;
            Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            FactIdentifier factIdentifier = factMappingByIndex.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = factMappingByIndex.getExpressionIdentifier();
            scenarioByIndex.addOrUpdateMappingValue(factIdentifier, expressionIdentifier, (Object)cellValue);
        }
        catch (Throwable t) {
            toReturn = super.deleteCell(rowIndex, columnIndex);
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent());
        }
        return toReturn;
    }

    public GridData.Range setCellValue(int rowIndex, int columnIndex, GridCellValue<?> value) {
        return this.setCell(rowIndex, columnIndex, () -> {
            ScenarioGridCell newCell = new ScenarioGridCell((ScenarioGridCellValue)value);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            if (ScenarioSimulationSharedUtils.isCollection((String)factMappingByIndex.getClassName())) {
                newCell.setListMap(ScenarioSimulationSharedUtils.isList((String)factMappingByIndex.getClassName()));
            }
            return newCell;
        });
    }

    public GridData.Range deleteCell(int rowIndex, int columnIndex) {
        FactMapping factMapping = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        this.simulation.getScenarioByIndex(rowIndex).removeFactMappingValueByIdentifiers(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier());
        return super.deleteCell(rowIndex, columnIndex);
    }

    public GridData.Range getInstanceLimits(int columnIndex) {
        int rightPosition;
        int leftPosition;
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)((Object)this.columns.get(columnIndex));
        String originalColumnGroup = selectedColumn.getInformationHeaderMetaData().getColumnGroup();
        ScenarioHeaderMetaData selectedInformationHeaderMetaData = selectedColumn.getInformationHeaderMetaData();
        String originalColumnTitle = selectedInformationHeaderMetaData.getTitle();
        for (leftPosition = columnIndex; leftPosition > 1 && ((ScenarioGridColumn)((Object)this.columns.get(leftPosition - 1))).getInformationHeaderMetaData().getColumnGroup().equals(originalColumnGroup) && ((ScenarioGridColumn)((Object)this.columns.get(leftPosition - 1))).getInformationHeaderMetaData().getTitle().equals(originalColumnTitle); --leftPosition) {
        }
        for (rightPosition = columnIndex; rightPosition < this.columns.size() - 1 && ((ScenarioGridColumn)((Object)this.columns.get(rightPosition + 1))).getInformationHeaderMetaData().getColumnGroup().equals(originalColumnGroup) && ((ScenarioGridColumn)((Object)this.columns.get(rightPosition + 1))).getInformationHeaderMetaData().getTitle().equals(originalColumnTitle); ++rightPosition) {
        }
        return new GridData.Range(leftPosition, rightPosition);
    }

    public List<ScenarioGridColumn> getInstanceScenarioGridColumns(int columnIndex) {
        GridData.Range instanceRange = this.getInstanceLimits(columnIndex);
        return this.columns.subList(instanceRange.getMinRowIndex(), instanceRange.getMaxRowIndex() + 1).stream().map(gridColumn -> (ScenarioGridColumn)((Object)gridColumn)).collect(Collectors.toList());
    }

    public List<ScenarioGridColumn> getInstanceScenarioGridColumns(ScenarioGridColumn selectedColumn) {
        int columnIndex = this.columns.indexOf((Object)selectedColumn);
        return this.getInstanceScenarioGridColumns(columnIndex);
    }

    public int getFirstIndexLeftOfGroup(String groupName) {
        List columns = this.getColumns();
        Optional<Integer> first = columns.stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).findFirst().map(gridColumn -> {
            int indexOfColumn = columns.indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn : 0;
        });
        return first.orElseGet(() -> 0);
    }

    public int getFirstIndexRightOfGroup(String groupName) {
        Optional<Integer> last = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).reduce((first, second) -> second).map(gridColumn -> {
            int indexOfColumn = this.getColumns().indexOf(gridColumn);
            return indexOfColumn > -1 ? indexOfColumn + 1 : this.getColumnCount();
        });
        return last.orElseGet(() -> ((ScenarioGridModel)this).getColumnCount());
    }

    public long getGroupSize(String groupName) {
        return this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getColumnGroup().equals(groupName)).count();
    }

    public int getInstancesCount(String className) {
        return this.simulation.getSimulationDescriptor().getUnmodifiableFactMappings().stream().filter(factMapping -> factMapping.getFactIdentifier().getClassName().equals(className)).collect(Collectors.groupingBy(FactMapping::getFactAlias)).size();
    }

    public void updateHeader(int columnIndex, int headerRowIndex, String headerCellValue) {
        ScenarioHeaderMetaData editedMetadata = (ScenarioHeaderMetaData)((Object)((GridColumn)this.getColumns().get(columnIndex)).getHeaderMetaData().get(headerRowIndex));
        if (Objects.equals(editedMetadata.getTitle(), headerCellValue)) {
            return;
        }
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMappingToEdit = simulationDescriptor.getFactMappingByIndex(columnIndex);
        ScenarioHeaderMetaData.MetadataType metadataType = editedMetadata.getMetadataType();
        IntStream.range(0, this.getColumnCount()).forEach(index -> this.updateFactMapping(simulationDescriptor, factMappingToEdit, index, headerCellValue, metadataType));
        if (editedMetadata.getMetadataType().equals((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE)) {
            this.eventBus.fireEvent((GwtEvent)new ReloadTestToolsEvent(false));
        }
    }

    public void clear() {
        int to = this.getRowCount();
        IntStream.range(0, to).map(i -> to - i - 1).forEach(x$0 -> super.deleteRow(x$0));
        ArrayList copyList = new ArrayList(this.getColumns());
        copyList.forEach(x$0 -> super.deleteColumn(x$0));
        if (this.simulation != null) {
            this.simulation.clear();
        }
    }

    public void clearSelections() {
        super.clearSelections();
        this.selectedColumn = null;
    }

    public boolean forceRefreshWidth() {
        return this.internalRefreshWidth(true, OptionalDouble.empty());
    }

    public void synchronizeFactMappingsWidths() {
        this.getColumns().forEach(column -> this.synchronizeFactMappingWidth((GridColumn<?>)column));
    }

    public void synchronizeFactMappingWidth(GridColumn<?> column) {
        if (!column.isVisible()) {
            return;
        }
        int columnIndex = this.getColumns().indexOf(column);
        FactMapping factMapping = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        factMapping.setColumnWidth(Double.valueOf(column.getWidth()));
    }

    public void loadFactMappingsWidth() {
        for (GridColumn column : this.getColumns()) {
            int columnIndex = this.getColumns().indexOf(column);
            FactMapping factMapping = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            if (factMapping.getColumnWidth() == null) continue;
            column.setWidth(factMapping.getColumnWidth().doubleValue());
        }
    }

    public void selectColumn(int columnIndex) {
        if (columnIndex > this.getColumnCount() - 1 || columnIndex < 0) {
            throw new IllegalArgumentException("Wrong column index: " + columnIndex);
        }
        this.selectedColumn = (GridColumn)this.getColumns().get(columnIndex);
    }

    public void selectRow(int rowIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        int columns = this.getColumnCount();
        IntStream.range(0, columns).forEach(columnIndex -> this.selectCell(rowIndex, columnIndex));
    }

    public GridColumn<?> getSelectedColumn() {
        return this.selectedColumn;
    }

    public Optional<Simulation> getSimulation() {
        return Optional.ofNullable(this.simulation);
    }

    public boolean isSelectedColumnEmpty() {
        return this.selectedColumn == null || this.isColumnEmpty(this.getColumns().indexOf(this.selectedColumn));
    }

    public boolean isColumnEmpty(int columnIndex) {
        return !IntStream.range(0, this.getRowCount()).filter(rowIndex -> this.getCellValue(this.getCell(rowIndex, columnIndex)).isPresent()).findFirst().isPresent();
    }

    public boolean isAlreadyAssignedProperty(List<String> propertyNameElements) {
        boolean toReturn;
        boolean bl = toReturn = this.selectedColumn == null;
        if (!toReturn) {
            try {
                this.checkAlreadyAssignedProperty(this.getColumns().indexOf(this.selectedColumn), propertyNameElements);
            }
            catch (Exception e) {
                toReturn = true;
            }
        }
        return toReturn;
    }

    public void checkAlreadyAssignedProperty(int columnIndex, List<String> propertyNameElements) throws Exception {
        GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactIdentifier factIdentifier = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        ArrayList<String> propertyNameElementsClone = new ArrayList<String>();
        propertyNameElementsClone.add(factIdentifier.getClassNameWithoutPackage());
        propertyNameElementsClone.addAll(propertyNameElements.subList(1, propertyNameElements.size()));
        if (IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).filter(index -> index != columnIndex).mapToObj(arg_0 -> ((SimulationDescriptor)simulationDescriptor).getFactMappingByIndex(arg_0)).anyMatch(factMapping -> {
            List factMappingPropertyNameElements = factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            return Objects.equals(factMappingPropertyNameElements, propertyNameElementsClone);
        })) {
            throw new Exception(String.join((CharSequence)".", propertyNameElements) + " has already been used in the current instance.");
        }
    }

    public boolean isSameSelectedColumnProperty(List<String> propertyNameElements) {
        return this.selectedColumn == null || this.isSameSelectedColumnProperty(this.getColumns().indexOf(this.selectedColumn), propertyNameElements);
    }

    public boolean isSameSelectedColumnProperty(int columnIndex, List<String> propertyNameElements) {
        String propertyName = String.join((CharSequence)".", propertyNameElements);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
        return factMappingByIndex.getExpressionAlias().equals(propertyName);
    }

    public boolean isSameSelectedColumnType(String className) {
        return this.selectedColumn == null || this.isSameSelectedColumnType(this.getColumns().indexOf(this.selectedColumn), className);
    }

    public boolean isSameSelectedColumnType(int columnIndex, String className) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
        return factMappingByIndex.getClassName().equals(className);
    }

    public boolean isSameInstanceType(String className) {
        return this.selectedColumn == null || this.isSameInstanceType(this.getColumns().indexOf(this.selectedColumn), className);
    }

    public void checkSameInstanceHeader(int columnIndex, String headerName) throws Exception {
        if (!this.isSameInstanceType(columnIndex, headerName)) {
            throw new Exception(headerName + " is not the class of the current column.");
        }
    }

    public boolean isSameInstanceType(int columnIndex, String headerName) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactIdentifier factIdentifierByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        return Objects.equals(factIdentifierByIndex.getClassNameWithoutPackage(), headerName);
    }

    public void checkSamePropertyHeader(int columnIndex, List<String> propertyNameElements) throws Exception {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactMapping factMapping = simulationDescriptor.getFactMappingByIndex(columnIndex);
        List columnPropertyName = factMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
        if (!Objects.equals(columnPropertyName, propertyNameElements)) {
            throw new Exception(String.join((CharSequence)".", propertyNameElements) + " is not the same property of the current column.");
        }
    }

    public void resetErrors() {
        IntStream.range(0, this.getRowCount()).forEach(this::resetErrors);
    }

    public void resetErrors(int rowIndex) {
        Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
        scenarioByIndex.resetErrors();
        this.refreshErrors();
    }

    public void resetError(int rowIndex, int columnIndex) {
        Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
        FactMapping factMapping = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        Optional factMappingValue = scenarioByIndex.getFactMappingValue(factMapping);
        factMappingValue.ifPresent(fmv -> fmv.resetStatus());
        this.refreshErrors();
    }

    public void refreshErrors() {
        IntStream.range(0, this.getRowCount()).forEach(this::refreshErrorsRow);
    }

    public void setDataObjectsInstancesName(Set<String> dataObjectsInstancesName) {
        this.dataObjectsInstancesName = dataObjectsInstancesName;
    }

    public void setSimpleJavaTypeInstancesName(Set<String> simpleJavaTypeInstancesName) {
        this.simpleJavaTypeInstancesName = simpleJavaTypeInstancesName;
    }

    public void validateInstanceHeaderUpdate(String instanceHeaderCellValue, int columnIndex, boolean isADataType) throws Exception {
        if (isADataType) {
            this.checkSameInstanceHeader(columnIndex, instanceHeaderCellValue);
            this.checkValidAndUniqueInstanceHeaderTitle(instanceHeaderCellValue, columnIndex);
        } else {
            this.checkValidAndUniqueInstanceHeaderTitle(instanceHeaderCellValue, columnIndex);
        }
    }

    public void validatePropertyHeaderUpdate(String propertyHeaderCellValue, int columnIndex, boolean isPropertyType) throws Exception {
        List<String> propertyNameElements = Collections.unmodifiableList(Arrays.asList(propertyHeaderCellValue.split("\\.")));
        if (isPropertyType) {
            this.checkSamePropertyHeader(columnIndex, propertyNameElements);
            this.checkUniquePropertyHeaderTitle(propertyHeaderCellValue, columnIndex);
        } else {
            this.checkAlreadyAssignedProperty(columnIndex, propertyNameElements);
            this.checkValidAndUniquePropertyHeaderTitle(propertyHeaderCellValue, columnIndex);
        }
    }

    public boolean isSimpleType(String factClassName) {
        return this.simpleJavaTypeInstancesName.contains(factClassName);
    }

    protected void updateFactMapping(SimulationDescriptor simulationDescriptor, FactMapping factMappingReference, int index, String value, ScenarioHeaderMetaData.MetadataType metadataType) {
        boolean toUpdate;
        FactIdentifier factIdentifierReference = factMappingReference.getFactIdentifier();
        FactMapping factMappingToCheck = simulationDescriptor.getFactMappingByIndex(index);
        FactIdentifier factIdentifierToCheck = factMappingToCheck.getFactIdentifier();
        boolean bl = toUpdate = Objects.equals(FactIdentifier.EMPTY, factIdentifierReference) && Objects.equals(factIdentifierToCheck, factIdentifierReference) && Objects.equals(factMappingReference.getFactAlias(), factMappingToCheck.getFactAlias()) || Objects.equals(factIdentifierToCheck, factIdentifierReference);
        if (toUpdate) {
            switch (metadataType) {
                case INSTANCE: {
                    ((ScenarioGridColumn)((Object)this.columns.get(index))).getInformationHeaderMetaData().setTitle(value);
                    factMappingToCheck.setFactAlias(value);
                    break;
                }
                case PROPERTY: {
                    if (!Objects.equals(factMappingToCheck.getFullExpression(), factMappingReference.getFullExpression())) break;
                    ((ScenarioGridColumn)((Object)this.columns.get(index))).getPropertyHeaderMetaData().setTitle(value);
                    factMappingToCheck.setExpressionAlias(value);
                    break;
                }
            }
        }
    }

    protected void commonAddColumn(int index, GridColumn<?> column) {
        String group = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnGroup();
        String columnId = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getColumnId();
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.valueOf((String)group));
        this.commonAddColumn(index, column, ei);
    }

    protected void commonAddColumn(int index, GridColumn<?> column, ExpressionIdentifier ei) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        String instanceTitle = ((ScenarioGridColumn)column).getInformationHeaderMetaData().getTitle();
        String propertyTitle = ((ScenarioGridColumn)column).getPropertyHeaderMetaData().getTitle();
        int columnIndex = index == -1 ? this.getColumnCount() : index;
        try {
            FactMapping createdFactMapping = simulationDescriptor.addFactMapping(columnIndex, instanceTitle, ((ScenarioGridColumn)column).getFactIdentifier(), ei);
            createdFactMapping.setExpressionAlias(propertyTitle);
            if (index == -1) {
                super.appendColumn(column);
            } else {
                super.insertColumn(index, column);
            }
            GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
            IntStream.range(instanceLimits.getMinRowIndex(), instanceLimits.getMaxRowIndex() + 1).filter(currentIndex -> currentIndex != columnIndex).forEach(currentIndex -> simulationDescriptor.getFactMappingByIndex(currentIndex).setFactAlias(createdFactMapping.getFactAlias()));
        }
        catch (Throwable t) {
            this.eventBus.fireEvent((GwtEvent)new ScenarioNotificationEvent("Error during column creation: " + t.getMessage(), NotificationEvent.NotificationType.ERROR));
            this.eventBus.fireEvent((GwtEvent)new ScenarioGridReloadEvent());
            return;
        }
        List scenarios = this.simulation.getUnmodifiableScenarios();
        String placeHolder = ((ScenarioGridColumn)column).getPlaceHolder();
        IntStream.range(0, scenarios.size()).forEach(rowIndex -> this.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell(new ScenarioGridCellValue(null, placeHolder))));
    }

    protected void commonAddRow(int rowIndex) {
        Scenario scenario = this.simulation.addScenario(rowIndex);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        IntStream.range(1, this.getColumnCount()).forEach(columnIndex -> {
            FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
            scenario.addMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier(), null);
            String editableCellPlaceholder = ScenarioSimulationUtils.getPlaceholder(factMappingByIndex.getClassName());
            String placeHolder = ((ScenarioGridColumn)((Object)((Object)this.columns.get(columnIndex)))).isPropertyAssigned() ? editableCellPlaceholder : ScenarioSimulationEditorConstants.INSTANCE.defineValidType();
            this.setCell(rowIndex, columnIndex, () -> {
                ScenarioGridCell newCell = new ScenarioGridCell(new ScenarioGridCellValue(null, placeHolder));
                if (ScenarioSimulationSharedUtils.isCollection((String)factMappingByIndex.getClassName())) {
                    newCell.setListMap(ScenarioSimulationSharedUtils.isList((String)factMappingByIndex.getClassName()));
                }
                return newCell;
            });
        });
        this.updateIndexColumn();
    }

    protected void updateIndexColumn() {
        Optional<GridColumn> indexColumn = this.getColumns().stream().filter(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getTitle().equals(FactIdentifier.INDEX.getName())).findFirst();
        indexColumn.ifPresent(column -> {
            int indexOfColumn = this.getColumns().indexOf(column);
            IntStream.range(0, this.getRowCount()).forEach(rowIndex -> {
                String value = String.valueOf(rowIndex + 1);
                this.setCellValue(rowIndex, indexOfColumn, (GridCellValue<?>)new ScenarioGridCellValue(value));
            });
        });
    }

    protected void checkSimulation() {
        Objects.requireNonNull(this.simulation, "Bind a simulation to the ScenarioGridModel to use it");
    }

    protected void checkValidAndUniqueInstanceHeaderTitle(String instanceHeaderCellValue, int columnIndex) {
        if (instanceHeaderCellValue.contains(".")) {
            throw new IllegalArgumentException(ScenarioSimulationEditorConstants.INSTANCE.instanceTitleWithPeriodsError());
        }
        GridData.Range instanceLimits = this.getInstanceLimits(columnIndex);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactIdentifier factIdentifier = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        if (IntStream.range(0, this.getColumnCount()).filter(index -> index < instanceLimits.getMinRowIndex() || index > instanceLimits.getMaxRowIndex()).filter(index -> !Objects.equals(factIdentifier, simulationDescriptor.getFactMappingByIndex(index).getFactIdentifier())).mapToObj(index -> (ScenarioGridColumn)((Object)((Object)this.getColumns().get(index)))).filter(elem -> elem.getInformationHeaderMetaData() != null).map(ScenarioGridColumn::getInformationHeaderMetaData).anyMatch(elem -> Objects.equals(elem.getTitle(), instanceHeaderCellValue))) {
            throw new IllegalArgumentException(ScenarioSimulationEditorConstants.INSTANCE.instanceTitleAssignedError(instanceHeaderCellValue));
        }
    }

    protected void checkValidAndUniquePropertyHeaderTitle(String propertyHeaderCellValue, int columnIndex) {
        if (propertyHeaderCellValue.contains(".")) {
            throw new IllegalArgumentException(ScenarioSimulationEditorConstants.INSTANCE.propertyTitleWithPeriodsError());
        }
        this.checkUniquePropertyHeaderTitle(propertyHeaderCellValue, columnIndex);
    }

    protected void checkUniquePropertyHeaderTitle(String propertyHeaderCellValue, int columnIndex) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        FactIdentifier factIdentifier = simulationDescriptor.getFactMappingByIndex(columnIndex).getFactIdentifier();
        if (IntStream.range(0, this.getColumnCount()).filter(index -> index != columnIndex).filter(index -> Objects.equals(factIdentifier, simulationDescriptor.getFactMappingByIndex(index).getFactIdentifier())).mapToObj(index -> (ScenarioGridColumn)((Object)((Object)this.getColumns().get(index)))).filter(elem -> elem.getPropertyHeaderMetaData() != null).map(ScenarioGridColumn::getPropertyHeaderMetaData).anyMatch(elem -> Objects.equals(elem.getTitle(), propertyHeaderCellValue))) {
            throw new IllegalArgumentException(ScenarioSimulationEditorConstants.INSTANCE.propertyTitleAssignedError(propertyHeaderCellValue));
        }
    }

    protected boolean isNewInstanceName(String value) {
        return this.getColumns().stream().map(elem -> ((ScenarioGridColumn)((Object)elem)).getInformationHeaderMetaData()).filter(Objects::nonNull).noneMatch(elem -> Objects.equals(elem.getTitle(), value));
    }

    protected boolean isNewPropertyName(String value) {
        return this.getColumns().stream().map(elem -> ((ScenarioGridColumn)((Object)elem)).getPropertyHeaderMetaData()).filter(Objects::nonNull).noneMatch(elem -> Objects.equals(elem.getTitle(), value));
    }

    protected void refreshErrorsRow(int rowIndex) {
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
        IntStream.range(0, this.getColumnCount()).forEach(columnIndex -> {
            ScenarioGridCell cell = (ScenarioGridCell)this.getCell(rowIndex, columnIndex);
            if (cell == null) {
                return;
            }
            FactMapping factMappingByIndex = simulationDescriptor.getFactMappingByIndex(columnIndex);
            Optional factMappingValue = scenarioByIndex.getFactMappingValue(factMappingByIndex.getFactIdentifier(), factMappingByIndex.getExpressionIdentifier());
            if (factMappingValue.isPresent()) {
                cell.setErrorMode(FactMappingValueStatus.SUCCESS != ((FactMappingValue)factMappingValue.get()).getStatus());
            } else {
                cell.setErrorMode(false);
            }
        });
    }

    private Optional<?> getCellValue(GridCell<?> gridCell) {
        if (gridCell == null || gridCell.getValue() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(gridCell.getValue().getValue());
    }
}

