/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import elemental2.dom.DomGlobal;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.AuditLog;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorWrapper;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.events.ImportEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioMenuItemFactory;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationHasBusyIndicatorDefaultErrorCallback;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.CustomBusyPopup;
import org.drools.workbench.screens.scenariosimulation.client.producers.ScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SubDockView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestRunnerReportingPanelWrapper;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridWidget;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.drools.workbench.screens.scenariosimulation.model.SimulationRunResult;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportType;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.enterprise.client.jaxrs.MarshallingWrapper;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.ext.editor.commons.client.file.exports.TextContent;
import org.uberfire.ext.editor.commons.client.file.exports.TextFileExport;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@Dependent
public class ScenarioSimulationEditorPresenter {
    public static final String IDENTIFIER = "ScenarioSimulationEditor";
    private static final AtomicLong SCENARIO_PRESENTER_COUNTER = new AtomicLong();
    protected String packageName = "";
    protected ObservablePath path;
    protected EventBus eventBus;
    protected ScenarioGridWidget scenarioMainGridWidget;
    protected ScenarioGridWidget scenarioBackgroundGridWidget;
    protected PlaceManager placeManager;
    protected DataManagementStrategy dataManagementStrategy;
    protected ScenarioSimulationContext focusedContext;
    protected ScenarioSimulationModel model;
    protected TestRunnerReportingPanelWrapper testRunnerReportingPanel;
    protected SimulationRunResult lastRunResult;
    protected long scenarioPresenterId;
    protected boolean saveEnabled = true;
    protected MenuItem undoMenuItem;
    protected MenuItem redoMenuItem;
    protected MenuItem runScenarioMenuItem;
    protected MenuItem exportToCSVMenuItem;
    protected MenuItem importMenuItem;
    protected MenuItem downloadMenuItem;
    private ScenarioSimulationResourceType type;
    private ScenarioSimulationView view;
    private Command populateTestToolsCommand;
    private TextFileExport textFileExport;
    private ConfirmPopupPresenter confirmPopupPresenter;
    private ScenarioSimulationDocksHandler scenarioSimulationDocksHandler;
    private ScenarioSimulationEditorWrapper scenarioSimulationEditorWrapper;

    public ScenarioSimulationEditorPresenter() {
    }

    @Inject
    public ScenarioSimulationEditorPresenter(ScenarioSimulationProducer scenarioSimulationProducer, ScenarioSimulationResourceType type, PlaceManager placeManager, TestRunnerReportingPanelWrapper testRunnerReportingPanel, ScenarioSimulationDocksHandler scenarioSimulationDocksHandler, TextFileExport textFileExport, ConfirmPopupPresenter confirmPopupPresenter) {
        this.view = scenarioSimulationProducer.getScenarioSimulationView();
        this.testRunnerReportingPanel = testRunnerReportingPanel;
        this.scenarioSimulationDocksHandler = scenarioSimulationDocksHandler;
        this.type = type;
        this.placeManager = placeManager;
        this.eventBus = scenarioSimulationProducer.getEventBus();
        this.textFileExport = textFileExport;
        this.confirmPopupPresenter = confirmPopupPresenter;
        this.view.init();
        this.initMenuItems();
        scenarioSimulationProducer.setScenarioSimulationEditorPresenter(this);
        this.scenarioMainGridWidget = this.view.getScenarioGridWidget();
        this.scenarioMainGridWidget.getScenarioSimulationContext().setScenarioSimulationEditorPresenter(this);
        this.scenarioBackgroundGridWidget = scenarioSimulationProducer.getScenarioBackgroundGridWidget();
        this.scenarioBackgroundGridWidget.getScenarioSimulationContext().setScenarioSimulationEditorPresenter(this);
        this.populateTestToolsCommand = this.createPopulateTestToolsCommand();
        this.scenarioPresenterId = SCENARIO_PRESENTER_COUNTER.getAndIncrement();
    }

    public void init(ScenarioSimulationEditorWrapper scenarioSimulationEditorWrapper, ObservablePath path) {
        this.scenarioSimulationEditorWrapper = scenarioSimulationEditorWrapper;
        this.path = path;
        this.testRunnerReportingPanel.reset();
    }

    private void initMenuItems() {
        this.undoMenuItem = ScenarioMenuItemFactory.getUndoMenuItem(this::onUndo);
        this.redoMenuItem = ScenarioMenuItemFactory.getRedoMenuItem(this::onRedo);
        this.runScenarioMenuItem = ScenarioMenuItemFactory.getRunScenarioMenuItem(this::onRunScenario);
        this.exportToCSVMenuItem = ScenarioMenuItemFactory.getExportToCsvMenuItem(this::onExportToCsv);
        this.importMenuItem = ScenarioMenuItemFactory.getImportMenuItem(this::showImportDialog);
    }

    public void setFocusedContext(ScenarioSimulationContext scenarioSimulationContext) {
        this.focusedContext = scenarioSimulationContext;
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
    }

    public void setSaveEnabled(boolean toSet) {
        this.saveEnabled = toSet;
        this.getSettingsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.Settings")).ifPresent(presenter -> presenter.setSaveEnabled(toSet));
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void onClose() {
        this.scenarioMainGridWidget.unregister();
        this.scenarioBackgroundGridWidget.unregister();
    }

    public void showDocks(PlaceStatus status) {
        this.scenarioSimulationEditorWrapper.wrappedRegisterDock("testRunnerReportingPanel", this.testRunnerReportingPanel.asWidget());
        this.scenarioSimulationDocksHandler.addDocks();
        this.scenarioSimulationDocksHandler.setScesimEditorId(String.valueOf(this.scenarioPresenterId));
        if (!PlaceStatus.OPEN.equals((Object)status)) {
            this.expandToolsDock();
        }
        this.registerTestToolsCallback();
        this.resetDocks();
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
    }

    public void hideDocks() {
        this.scenarioSimulationDocksHandler.removeDocks();
        this.scenarioMainGridWidget.clearSelections();
        this.scenarioBackgroundGridWidget.clearSelections();
        this.unRegisterTestToolsCallback();
        this.clearTestToolsStatus();
    }

    public void onUberfireDocksInteractionEvent(@Observes UberfireDocksInteractionEvent uberfireDocksInteractionEvent) {
        if (this.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEvent) && !"org.drools.scenariosimulation.TestTools".equals(uberfireDocksInteractionEvent.getTargetDock().getIdentifier())) {
            this.populateRightDocks(uberfireDocksInteractionEvent.getTargetDock().getIdentifier());
        }
    }

    public void expandToolsDock() {
        this.scenarioSimulationDocksHandler.expandToolsDock();
    }

    public ScenarioSimulationView getView() {
        return this.view;
    }

    public ScenarioSimulationModel getModel() {
        return this.model;
    }

    public Command getPopulateTestToolsCommand() {
        return this.populateTestToolsCommand;
    }

    public void reloadTestTools(boolean disable) {
        this.populateTestToolsCommand.execute();
        if (disable) {
            this.getTestToolsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools")).ifPresent(TestToolsView.Presenter::onDisableEditorTab);
        }
    }

    public void onRunScenario() {
        List<Integer> indexes = IntStream.range(0, this.focusedContext.getStatus().getSimulation().getUnmodifiableScenarios().size()).boxed().collect(Collectors.toList());
        this.onRunScenario(indexes);
    }

    public void onRunScenario(List<Integer> indexOfScenarioToRun) {
        this.scenarioMainGridWidget.resetErrors();
        this.model.setSimulation(this.scenarioMainGridWidget.getScenarioSimulationContext().getStatus().getSimulation());
        Simulation simulation = this.model.getSimulation();
        List<ScenarioWithIndex> toRun = simulation.getScenarioWithIndex().stream().filter(elem -> indexOfScenarioToRun.contains(elem.getIndex() - 1)).collect(Collectors.toList());
        this.view.showBusyIndicator(ScenarioSimulationEditorConstants.INSTANCE.running());
        this.scenarioSimulationEditorWrapper.onRunScenario(this.getRefreshModelCallback(), new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view), simulation.getSimulationDescriptor(), toRun);
    }

    public void onUndo() {
        this.eventBus.fireEvent((GwtEvent)new UndoEvent());
    }

    public void onRedo() {
        this.eventBus.fireEvent((GwtEvent)new RedoEvent());
    }

    public void setUndoButtonEnabledStatus(boolean enabled) {
        this.undoMenuItem.setEnabled(enabled);
    }

    public void setRedoButtonEnabledStatus(boolean enabled) {
        this.redoMenuItem.setEnabled(enabled);
    }

    public void setItemMenuForMainGridEnabled(boolean enabled) {
        this.runScenarioMenuItem.setEnabled(enabled);
        this.importMenuItem.setEnabled(enabled);
        this.exportToCSVMenuItem.setEnabled(enabled);
        if (this.downloadMenuItem != null) {
            this.downloadMenuItem.setEnabled(enabled);
        }
    }

    public void addDownloadMenuItem(FileMenuBuilder fileMenuBuilder, Supplier<Path> pathSupplier) {
        this.downloadMenuItem = ScenarioMenuItemFactory.getDownloadMenuItem(() -> this.onDownload(pathSupplier));
        fileMenuBuilder.addNewTopLevelMenu(this.downloadMenuItem);
    }

    public DataManagementStrategy getDataManagementStrategy() {
        return this.dataManagementStrategy;
    }

    public void onImport(String fileContents) {
        this.scenarioSimulationEditorWrapper.onImport(fileContents, this.getImportCallBack(), this.getImportErrorCallback(), this.focusedContext.getStatus().getSimulation());
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public ScenarioSimulationContext getFocusedContext() {
        return this.focusedContext;
    }

    protected void resetDocks() {
        this.getSettingsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.Settings")).ifPresent(SubDockView.Presenter::reset);
        this.getCheatSheetPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.CheatSheet")).ifPresent(SubDockView.Presenter::reset);
        this.getTestToolsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools")).ifPresent(SubDockView.Presenter::reset);
        this.getCoverageReportPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.CoverageReport")).ifPresent(SubDockView.Presenter::reset);
        this.testRunnerReportingPanel.reset();
    }

    protected boolean isUberfireDocksInteractionEventToManage(UberfireDocksInteractionEvent uberfireDocksInteractionEvent) {
        return uberfireDocksInteractionEvent.getTargetDock() != null && uberfireDocksInteractionEvent.getTargetDock().getPlaceRequest().getParameter("scesimeditorid", "").equals(String.valueOf(this.scenarioPresenterId));
    }

    protected RemoteCallback<SimulationRunResult> getRefreshModelCallback() {
        return this::refreshModelContent;
    }

    protected void refreshModelContent(SimulationRunResult newData) {
        this.view.hideBusyIndicator();
        if (this.model == null) {
            return;
        }
        Simulation simulation = this.model.getSimulation();
        for (ScenarioWithIndex scenarioWithIndex : newData.getScenarioWithIndex()) {
            int index = scenarioWithIndex.getIndex() - 1;
            simulation.replaceScenario(index, scenarioWithIndex.getScenario());
        }
        this.scenarioMainGridWidget.refreshContent(simulation);
        this.focusedContext.getStatus().setSimulation(simulation);
        this.scenarioSimulationDocksHandler.expandTestResultsDock();
        this.testRunnerReportingPanel.onTestRun(newData.getTestResultMessage());
        this.dataManagementStrategy.setModel(this.model);
        this.lastRunResult = newData;
    }

    protected void registerTestToolsCallback() {
        this.placeManager.registerOnOpenCallback((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools"), this.populateTestToolsCommand);
    }

    protected void unRegisterTestToolsCallback() {
        this.placeManager.getOnOpenCallbacks((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools")).remove(this.populateTestToolsCommand);
    }

    protected ErrorCallback<Object> getImportErrorCallback() {
        return (error, exception) -> {
            this.confirmPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.importErrorTitle(), ScenarioSimulationEditorConstants.INSTANCE.importFailedMessage());
            return false;
        };
    }

    public void makeMenuBar(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addValidate(this.getValidateCommand());
        fileMenuBuilder.addNewTopLevelMenu(this.runScenarioMenuItem);
        fileMenuBuilder.addNewTopLevelMenu(this.undoMenuItem);
        fileMenuBuilder.addNewTopLevelMenu(this.redoMenuItem);
        fileMenuBuilder.addNewTopLevelMenu(this.exportToCSVMenuItem);
        fileMenuBuilder.addNewTopLevelMenu(this.importMenuItem);
        this.undoMenuItem.setEnabled(false);
        this.redoMenuItem.setEnabled(false);
    }

    public Supplier<ScenarioSimulationModel> getContentSupplier() {
        return () -> this.model;
    }

    public void addCommonActions(FileMenuBuilder fileMenuBuilder, MenuItem versionMenuItem, MenuItem alertsButtonMenuItem) {
        fileMenuBuilder.addNewTopLevelMenu(versionMenuItem).addNewTopLevelMenu(alertsButtonMenuItem);
    }

    public void loadContent() {
        CustomBusyPopup.showMessage(CommonConstants.INSTANCE.Loading());
    }

    public boolean isDirty() {
        try {
            this.scenarioMainGridWidget.resetErrors();
            int currentHashcode = MarshallingWrapper.toJSON((Object)this.model).hashCode();
            return this.scenarioSimulationEditorWrapper.getOriginalHash() != currentHashcode;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    protected void onDownload(Supplier<Path> pathSupplier) {
        String downloadURL = this.getFileDownloadURL(pathSupplier);
        this.open(downloadURL);
    }

    protected void open(String downloadURL) {
        DomGlobal.window.open((Object)downloadURL);
    }

    protected void showImportDialog() {
        this.eventBus.fireEvent((GwtEvent)new ImportEvent());
    }

    protected void onExportToCsv() {
        this.scenarioSimulationEditorWrapper.onExportToCsv(this.getExportCallBack(), new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view), this.focusedContext.getStatus().getSimulation());
    }

    protected RemoteCallback<Object> getExportCallBack() {
        return rawResult -> {
            TextContent textContent = TextContent.create((String)((String)rawResult));
            this.textFileExport.export((Object)textContent, this.path.getFileName() + ImportExportType.CSV.getExtension());
        };
    }

    protected RemoteCallback<Simulation> getImportCallBack() {
        return simulation -> {
            this.cleanReadOnlyColumn((Simulation)simulation);
            this.model.setSimulation(simulation);
            this.scenarioMainGridWidget.setContent(this.model.getSimulation());
            this.focusedContext.getStatus().setSimulation(this.model.getSimulation());
            this.scenarioMainGridWidget.onResize();
        };
    }

    protected Command getValidateCommand() {
        return () -> this.scenarioSimulationEditorWrapper.validate(this.focusedContext.getStatus().getSimulation(), this.getValidationCallback());
    }

    protected RemoteCallback<List<FactMappingValidationError>> getValidationCallback() {
        return result -> {
            this.view.hideBusyIndicator();
            if (result != null && !result.isEmpty()) {
                StringBuilder errorMessage = new StringBuilder(ScenarioSimulationEditorConstants.INSTANCE.validationErrorMessage());
                errorMessage.append(":<br/>");
                for (FactMappingValidationError validationError : result) {
                    errorMessage.append("<b>");
                    errorMessage.append(validationError.getErrorId());
                    errorMessage.append("</b> - ");
                    errorMessage.append(validationError.getErrorMessage());
                    errorMessage.append("<br/>");
                }
                this.confirmPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.validationErrorTitle(), errorMessage.toString());
            } else {
                this.eventBus.fireEvent((GwtEvent)new ScenarioNotificationEvent(ScenarioSimulationEditorConstants.INSTANCE.validationSucceed(), NotificationEvent.NotificationType.SUCCESS));
            }
        };
    }

    public ErrorCallback<?> getValidationFailedCallback() {
        return (message, exception) -> {
            CustomBusyPopup.close();
            BusyPopup.close();
            this.eventBus.fireEvent((GwtEvent)new ScenarioNotificationEvent(ScenarioSimulationEditorConstants.INSTANCE.validationFailedNotification(), NotificationEvent.NotificationType.ERROR));
            return false;
        };
    }

    protected void cleanReadOnlyColumn(Simulation simulation) {
        SimulationDescriptor simulationDescriptor = simulation.getSimulationDescriptor();
        for (int i = 0; i < simulation.getUnmodifiableScenarios().size(); ++i) {
            Scenario scenario = simulation.getScenarioByIndex(i);
            for (FactMapping factMapping : simulationDescriptor.getUnmodifiableFactMappings()) {
                if (!this.isColumnReadOnly(factMapping)) continue;
                scenario.getFactMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier()).ifPresent(fmv -> fmv.setRawValue(null));
            }
        }
    }

    private boolean isColumnReadOnly(FactMapping factMapping) {
        return !FactMappingType.OTHER.equals((Object)factMapping.getExpressionIdentifier().getType()) && factMapping.getExpressionElements().isEmpty();
    }

    public void populateRightDocks(String identifier) {
        if (this.dataManagementStrategy != null) {
            PlaceRequest currentRightDockPlaceRequest = this.getCurrentRightDockPlaceRequest(identifier);
            switch (identifier) {
                case "org.drools.scenariosimulation.Settings": {
                    this.getSettingsPresenter(currentRightDockPlaceRequest).ifPresent(presenter -> {
                        this.setSettings((SettingsView.Presenter)presenter);
                        presenter.setCurrentPath(this.path);
                    });
                    break;
                }
                case "org.drools.scenariosimulation.TestTools": {
                    this.getTestToolsPresenter(currentRightDockPlaceRequest).ifPresent(this::setTestTools);
                    break;
                }
                case "org.drools.scenariosimulation.CheatSheet": {
                    this.getCheatSheetPresenter(currentRightDockPlaceRequest).ifPresent(presenter -> {
                        if (!presenter.isCurrentlyShow(this.path)) {
                            this.setCheatSheet((CheatSheetView.Presenter)presenter);
                            presenter.setCurrentPath(this.path);
                        }
                    });
                    break;
                }
                case "org.drools.scenariosimulation.CoverageReport": {
                    this.getCoverageReportPresenter(currentRightDockPlaceRequest).ifPresent(presenter -> {
                        this.setCoverageReport((CoverageReportView.Presenter)presenter);
                        presenter.setCurrentPath(this.path);
                    });
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid identifier");
                }
            }
        }
    }

    public void getModelSuccessCallbackMethod(DataManagementStrategy dataManagementStrategy, ScenarioSimulationModel model) {
        this.dataManagementStrategy = dataManagementStrategy;
        this.model = model;
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
        this.populateRightDocks("org.drools.scenariosimulation.Settings");
        this.scenarioMainGridWidget.setContent(model.getSimulation());
        this.focusedContext.getStatus().setSimulation(model.getSimulation());
        CustomBusyPopup.close();
        this.getValidateCommand().execute();
    }

    public ScenarioSimulationResourceType getType() {
        return this.type;
    }

    protected void setTestTools(TestToolsView.Presenter presenter) {
        this.focusedContext.setTestToolsPresenter(presenter);
        presenter.setEventBus(this.eventBus);
        this.dataManagementStrategy.populateTestTools(presenter, this.focusedContext);
    }

    protected void clearTestToolsStatus() {
        this.getTestToolsPresenter(this.getCurrentRightDockPlaceRequest("org.drools.scenariosimulation.TestTools")).ifPresent(TestToolsView.Presenter::onClearStatus);
    }

    protected void setCheatSheet(CheatSheetView.Presenter presenter) {
        ScenarioSimulationModel.Type modelType = this.dataManagementStrategy instanceof AbstractDMODataManagementStrategy ? ScenarioSimulationModel.Type.RULE : ScenarioSimulationModel.Type.DMN;
        presenter.initCheatSheet(modelType);
    }

    protected void setSettings(SettingsView.Presenter presenter) {
        ScenarioSimulationModel.Type modelType = this.dataManagementStrategy instanceof AbstractDMODataManagementStrategy ? ScenarioSimulationModel.Type.RULE : ScenarioSimulationModel.Type.DMN;
        presenter.setScenarioType(modelType, this.model.getSimulation().getSimulationDescriptor(), this.path.getFileName());
        if (this.saveEnabled) {
            presenter.setSaveCommand(this.getSaveCommand());
            presenter.setSaveEnabled(true);
        } else {
            presenter.setSaveEnabled(false);
        }
    }

    protected void setCoverageReport(CoverageReportView.Presenter presenter) {
        ScenarioSimulationModel.Type modelType = this.dataManagementStrategy instanceof AbstractDMODataManagementStrategy ? ScenarioSimulationModel.Type.RULE : ScenarioSimulationModel.Type.DMN;
        SimulationRunMetadata simulationRunMetadata = this.lastRunResult != null ? this.lastRunResult.getSimulationRunMetadata() : null;
        presenter.populateCoverageReport(modelType, simulationRunMetadata);
        if (simulationRunMetadata != null && simulationRunMetadata.getAuditLog() != null) {
            presenter.setDownloadReportCommand(this.getDownloadReportCommand(simulationRunMetadata.getAuditLog()));
        }
    }

    public String getJsonModel(ScenarioSimulationModel model) {
        return MarshallingWrapper.toJSON((Object)model);
    }

    protected Optional<CheatSheetView.Presenter> getCheatSheetPresenter(PlaceRequest placeRequest) {
        Optional<CheatSheetView> cheatSheetView = this.getCheatSheetView(placeRequest);
        return cheatSheetView.map(SubDockView::getPresenter);
    }

    protected Optional<TestToolsView.Presenter> getTestToolsPresenter(PlaceRequest placeRequest) {
        Optional<TestToolsView> testToolsView = this.getTestToolsView(placeRequest);
        return testToolsView.map(TestToolsView::getPresenter);
    }

    protected Optional<SettingsView.Presenter> getSettingsPresenter(PlaceRequest placeRequest) {
        Optional<SettingsView> settingsView = this.getSettingsView(placeRequest);
        return settingsView.map(SubDockView::getPresenter);
    }

    protected Optional<CoverageReportView.Presenter> getCoverageReportPresenter(PlaceRequest placeRequest) {
        Optional<CoverageReportView> coverageReportViewMap = this.getCoverageReportView(placeRequest);
        return coverageReportViewMap.map(SubDockView::getPresenter);
    }

    protected Command getSaveCommand() {
        return () -> this.scenarioSimulationEditorWrapper.wrappedSave("Save");
    }

    protected Command getDownloadReportCommand(AuditLog auditLog) {
        return () -> this.scenarioSimulationEditorWrapper.onDownloadReportToCsv(this.getExportCallBack(), new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view), auditLog);
    }

    protected PlaceRequest getCurrentRightDockPlaceRequest(String identifier) {
        DefaultPlaceRequest toReturn = new DefaultPlaceRequest(identifier);
        toReturn.addParameter("scesimeditorid", String.valueOf(this.scenarioPresenterId));
        return toReturn;
    }

    protected String getFileDownloadURL(Supplier<Path> pathSupplier) {
        return GWT.getModuleBaseURL() + "defaulteditor/download?path=" + pathSupplier.get().toURI();
    }

    private Optional<TestToolsView> getTestToolsView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity != null) {
            AbstractWorkbenchActivity testToolsActivity = (AbstractWorkbenchActivity)activity;
            return Optional.of((TestToolsView)testToolsActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<CheatSheetView> getCheatSheetView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity != null) {
            AbstractWorkbenchActivity cheatSheetActivity = (AbstractWorkbenchActivity)activity;
            return Optional.of((CheatSheetView)cheatSheetActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<SettingsView> getSettingsView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity != null) {
            AbstractWorkbenchActivity settingsActivity = (AbstractWorkbenchActivity)activity;
            return Optional.of((SettingsView)settingsActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<CoverageReportView> getCoverageReportView(PlaceRequest placeRequest) {
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity != null) {
            AbstractWorkbenchActivity settingsActivity = (AbstractWorkbenchActivity)activity;
            return Optional.of((CoverageReportView)settingsActivity.getWidget());
        }
        return Optional.empty();
    }

    private Command createPopulateTestToolsCommand() {
        return () -> this.populateRightDocks("org.drools.scenariosimulation.TestTools");
    }

    public ScenarioGridWidget getBackgroundGridWidget() {
        return this.scenarioBackgroundGridWidget;
    }
}

