/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Div;
import org.gwtbootstrap3.client.ui.html.Span;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;

public class TitledAttachmentFileWidget
extends Composite {
    protected FlowPanel fields = (FlowPanel)GWT.create(FlowPanel.class);
    protected Div divElement = (Div)GWT.create(Div.class);
    protected FormLabel titleLabel = (FormLabel)GWT.create(FormLabel.class);
    protected Span errorLabel = (Span)GWT.create(Span.class);
    protected ScenarioSimulationDropdown scenarioSimulationDropdown;
    protected Caller<ScenarioSimulationService> scenarioSimulationService;
    protected String selectedPath;

    public TitledAttachmentFileWidget(String title, Caller<ScenarioSimulationService> scenarioSimulationService, ScenarioSimulationDropdown scenarioSimulationDropdown) {
        this.scenarioSimulationService = scenarioSimulationService;
        this.scenarioSimulationDropdown = scenarioSimulationDropdown;
        this.titleLabel.setStyleName("control-label");
        this.titleLabel.setText(title);
        this.divElement.add((Widget)this.titleLabel);
        this.divElement.getElement().appendChild((Node)this.createIconElement());
        this.errorLabel.setStyleName("help-block");
        this.errorLabel.setColor("#c00");
        this.errorLabel.setText(ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset());
        this.fields.add((Widget)this.divElement);
        this.fields.add(this.scenarioSimulationDropdown.asWidget());
        this.fields.add((Widget)this.errorLabel);
        this.initWidget((Widget)this.fields);
        scenarioSimulationDropdown.init();
        scenarioSimulationDropdown.registerOnChangeHandler(() -> {
            Optional value = scenarioSimulationDropdown.getValue();
            this.selectedPath = value.map(KieAssetsDropdownItem::getValue).orElse(null);
            this.validate();
        });
    }

    public void clearStatus() {
        this.updateAssetList();
        this.errorLabel.setText(null);
        this.selectedPath = null;
    }

    public void updateAssetList() {
        this.scenarioSimulationDropdown.loadAssets();
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public boolean validate() {
        boolean toReturn;
        boolean bl = toReturn = this.selectedPath != null && !this.selectedPath.isEmpty();
        if (!toReturn) {
            this.errorLabel.setText(ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset());
        } else {
            this.errorLabel.setText(null);
        }
        return toReturn;
    }

    protected Element createIconElement() {
        Element e = Document.get().createElement("i");
        e.addClassName("fa");
        e.addClassName(IconType.STAR.getCssName());
        Style s = e.getStyle();
        s.setFontSize(6.0, Style.Unit.PX);
        s.setPaddingLeft(2.0, Style.Unit.PX);
        s.setPaddingRight(5.0, Style.Unit.PX);
        s.setColor("#b94a48");
        Element sup = Document.get().createElement("sup");
        sup.appendChild((Node)e);
        return sup;
    }
}

