/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.popover;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.RootPanel;
import java.util.Objects;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.popover.PopoverView;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.PopoverOptions;

public abstract class AbstractPopoverView
implements PopoverView {
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String POSITION = "position";
    public static final String PX = "px";
    public static final String ABSOLUTE = "absolute";
    public static final String TITLE = "title";
    @DataField(value="popover")
    protected Div popoverElement;
    @DataField(value="popover-container")
    protected Div popoverContainerElement;
    @DataField(value="popover-content")
    protected Div popoverContentElement;
    protected JQueryProducer.JQuery<Popover> jQueryPopover;
    protected Popover popover;
    protected ElementWrapperWidget<?> wrappedWidget;

    public AbstractPopoverView() {
    }

    public AbstractPopoverView(Div popoverElement, Div popoverContainerElement, Div popoverContentElement, JQueryProducer.JQuery<Popover> jQueryPopover) {
        this.popoverElement = popoverElement;
        this.popoverContainerElement = popoverContainerElement;
        this.popoverContentElement = popoverContentElement;
        this.jQueryPopover = jQueryPopover;
    }

    @Override
    public void show(Optional<String> editorTitle, int mx, int my, PopoverView.Position position) {
        if (this.isShown()) {
            this.hide();
        }
        this.addWidgetToRootPanel();
        PopoverOptions options = new PopoverOptions();
        options.setContent(element -> this.popoverContentElement);
        options.setAnimation(Boolean.valueOf(false));
        options.setHtml(Boolean.valueOf(true));
        options.setPlacement(position.toString().toLowerCase());
        editorTitle.ifPresent(t -> this.popoverElement.setAttribute(TITLE, t));
        HTMLElement element2 = this.getElement();
        this.popover = (Popover)this.jQueryPopover.wrap((Element)element2);
        this.popover.popover(options);
        this.popoverElement.getStyle().setProperty(TOP, my + PX);
        this.popoverElement.getStyle().setProperty(LEFT, mx + PX);
        this.popoverElement.getStyle().setProperty(POSITION, ABSOLUTE);
        this.scheduleTask();
    }

    @Override
    public boolean isShown() {
        return RootPanel.get().getWidgetIndex(this.wrappedWidget) != -1;
    }

    @Override
    public void hide() {
        if (this.isShown()) {
            if (Objects.nonNull(this.popover)) {
                this.popover.hide();
                this.popover.destroy();
            }
            this.removeWidgetFromRootPanel();
        }
    }

    protected void addWidgetToRootPanel() {
        this.wrappedWidget = ElementWrapperWidget.getWidget((HTMLElement)this.getElement());
        RootPanel.get().add(this.wrappedWidget);
    }

    protected void removeWidgetFromRootPanel() {
        RootPanel.get().remove(this.wrappedWidget);
    }

    protected void scheduleTask() {
        Scheduler.get().scheduleDeferred(() -> this.popover.show());
    }
}

