/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Widget;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class ListGroupItemViewImpl
implements ListGroupItemView {
    public static final String LIST_VIEW_PF_EXPAND_ACTIVE = "list-view-pf-expand-active";
    @DataField(value="listGroupExpansion")
    protected DivElement listGroupExpansion = Document.get().createDivElement();
    @DataField(value="listGroupItem")
    protected DivElement listGroupItem = Document.get().createDivElement();
    @DataField(value="listGroupItemHeader")
    protected DivElement listGroupItemHeader = Document.get().createDivElement();
    @DataField(value="listGroupItemContainer")
    protected DivElement listGroupItemContainer = Document.get().createDivElement();
    @DataField(value="faAngleRight")
    protected SpanElement faAngleRight = Document.get().createSpanElement();
    @DataField(value="fullClassName")
    protected DivElement fullClassName = Document.get().createDivElement();
    @DataField(value="factProperties")
    protected UListElement factProperties = Document.get().createULElement();
    protected ListGroupItemView.Presenter presenter;
    protected String parentPath = "";
    protected String factName;
    protected String factType;
    protected boolean toExpand = false;
    protected boolean instanceAssigned = false;

    public Widget asWidget() {
        return null;
    }

    @Override
    public String getActualClassName() {
        return this.parentPath.isEmpty() ? this.factName : this.parentPath + "." + this.factName;
    }

    @EventHandler(value={"fullClassName"})
    public void onFullClassNameClick(ClickEvent event) {
        if (!this.fullClassName.getClassName().contains("disabled")) {
            this.listGroupItem.addClassName("selected");
            this.presenter.onSelectedElement(this);
        }
    }

    @EventHandler(value={"faAngleRight"})
    public void onFaAngleRightClick(ClickEvent event) {
        this.presenter.onToggleRowExpansion(this, this.isShown());
    }

    public void init(ListGroupItemView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setToExpand(boolean toExpand) {
        this.toExpand = toExpand;
    }

    @Override
    public boolean isToExpand() {
        return this.toExpand;
    }

    @Override
    public void unselect() {
        this.listGroupItem.removeClassName("selected");
    }

    @Override
    public void setFactName(String factName) {
        this.factName = factName;
        this.factType = factName;
        this.fullClassName.setInnerText(factName);
        this.listGroupItem.setAttribute("id", "listGroupItem-" + factName);
    }

    @Override
    public void setFactNameAndType(String factName, String factType) {
        this.factName = factName;
        this.factType = factType;
        String innerHtml = factName + " [" + factType + "]";
        this.fullClassName.setInnerHTML(innerHtml);
        this.fullClassName.setAttribute("factName", factName);
        this.fullClassName.setAttribute("factType", factType);
        this.fullClassName.setAttribute("parentPath", this.parentPath);
        this.listGroupItem.setAttribute("id", "listGroupItem-" + factName);
    }

    @Override
    public void setParentPath(String parentPath) {
        String string = this.parentPath = this.parentPath.isEmpty() ? parentPath : this.parentPath + "." + parentPath;
        if (this.parentPath.isEmpty()) {
            this.fullClassName.removeClassName("disabled");
        } else {
            this.fullClassName.addClassName("disabled");
        }
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public String getFactName() {
        return this.factName;
    }

    @Override
    public String getFactType() {
        return this.factType;
    }

    @Override
    public void addFactField(LIElement fieldElement) {
        this.factProperties.appendChild((Node)fieldElement);
    }

    @Override
    public void addExpandableFactField(DivElement fieldElement) {
        this.listGroupItemContainer.appendChild((Node)fieldElement);
    }

    @Override
    public DivElement getListGroupExpansion() {
        return this.listGroupExpansion;
    }

    @Override
    public DivElement getListGroupItem() {
        return this.listGroupItem;
    }

    @Override
    public void closeRow() {
        this.listGroupItemHeader.removeClassName(LIST_VIEW_PF_EXPAND_ACTIVE);
        this.listGroupItemContainer.addClassName("hidden");
        this.faAngleRight.removeClassName("fa-angle-down");
    }

    @Override
    public void expandRow() {
        this.listGroupItemHeader.addClassName(LIST_VIEW_PF_EXPAND_ACTIVE);
        this.listGroupItemContainer.removeClassName("hidden");
        this.faAngleRight.addClassName("fa-angle-down");
    }

    @Override
    public boolean isShown() {
        return this.listGroupItemHeader.getClassName().contains(LIST_VIEW_PF_EXPAND_ACTIVE);
    }

    @Override
    public void setInstanceAssigned(boolean instanceAssigned) {
        this.instanceAssigned = instanceAssigned;
    }

    @Override
    public boolean isInstanceAssigned() {
        return this.instanceAssigned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListGroupItemViewImpl that = (ListGroupItemViewImpl)o;
        return Objects.equals(this.getParentPath(), that.getParentPath()) && Objects.equals(this.getFactName(), that.getFactName()) && Objects.equals(this.getFactType(), that.getFactType());
    }

    public int hashCode() {
        return Objects.hash(this.getParentPath(), this.getFactName(), this.getFactType());
    }

    public String toString() {
        return "ListGroupItemViewImpl{fullClassName=" + this.fullClassName + ", parentPath='" + this.parentPath + '\'' + ", factName='" + this.factName + '\'' + ", factType='" + this.factType + '\'' + '}';
    }
}

