/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.utils;

import com.ait.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.SimpleClassEntry;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CellContextUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public class ScenarioSimulationUtils {
    protected static AtomicInteger subGroupCounter = new AtomicInteger(0);

    private ScenarioSimulationUtils() {
    }

    public static String getColumnSubGroup(String columnGroup) {
        return columnGroup + "-" + subGroupCounter.getAndIncrement();
    }

    public static String getOriginalColumnGroup(String columnGroup) {
        return columnGroup.contains("-") ? columnGroup.substring(0, columnGroup.indexOf("-")) : columnGroup;
    }

    public static boolean isSimpleJavaType(String className) {
        return DataManagementStrategy.SIMPLE_CLASSES_MAP.values().stream().map(SimpleClassEntry::getCanonicalName).anyMatch(className::equals);
    }

    public static String getPlaceHolder(boolean isInstanceAssigned, boolean isPropertyAssigned, FactMappingValueType valueType, String className) {
        if (!isInstanceAssigned) {
            return ScenarioSimulationEditorConstants.INSTANCE.defineValidType();
        }
        if (isPropertyAssigned) {
            if (Objects.equals(FactMappingValueType.EXPRESSION, valueType)) {
                return ScenarioSimulationEditorConstants.INSTANCE.insertExpression();
            }
            if (Objects.equals("java.time.LocalDate", className)) {
                return ScenarioSimulationEditorConstants.INSTANCE.dateFormatPlaceholder();
            }
            if (Objects.equals("date", className)) {
                return ScenarioSimulationEditorConstants.INSTANCE.dmnDateFormatPlaceholder();
            }
            return ScenarioSimulationEditorConstants.INSTANCE.insertValue();
        }
        return ScenarioSimulationEditorConstants.INSTANCE.defineValidType();
    }

    public static List<String> getPropertyNameElementsWithoutAlias(List<String> propertyNameElements, FactIdentifier factIdentifier) {
        String actualClassName = factIdentifier.getClassName();
        if (actualClassName.contains(".")) {
            actualClassName = actualClassName.substring(actualClassName.lastIndexOf(".") + 1);
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.addAll(propertyNameElements);
        if (toReturn.size() > 1) {
            toReturn.set(0, actualClassName);
        }
        return toReturn;
    }

    public static ScenarioGridColumn getScenarioGridColumn(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = ScenarioSimulationUtils.getHeaderBuilder(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, factoryHeader);
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, factoryCell, placeHolder);
    }

    public static ScenarioGridColumn getScenarioGridColumn(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
        ScenarioSimulationBuilders.ScenarioGridColumnBuilder scenarioGridColumnBuilder = ScenarioSimulationUtils.getScenarioGridColumnBuilder(factoryCell, headerBuilder, placeHolder);
        return scenarioGridColumnBuilder.build();
    }

    public static ScenarioSimulationBuilders.ScenarioGridColumnBuilder getScenarioGridColumnBuilder(ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, ScenarioSimulationBuilders.HeaderBuilder headerBuilder, String placeHolder) {
        ScenarioSimulationBuilders.ScenarioGridColumnBuilder toReturn = ScenarioSimulationBuilders.ScenarioGridColumnBuilder.get(factoryCell, headerBuilder);
        toReturn.setPlaceHolder(placeHolder);
        toReturn.setWidth(ScenarioSimulationUtils.getColumnWidth(headerBuilder.getColumnId()));
        return toReturn;
    }

    public static ScenarioSimulationBuilders.HeaderBuilder getHeaderBuilder(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader) {
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = ScenarioSimulationBuilders.HeaderBuilder.get(factoryHeader);
        headerBuilder.setColumnId(columnId);
        headerBuilder.setColumnTitle(columnGroup);
        headerBuilder.setReadOnly(true);
        if (ScenarioSimulationUtils.isOther(factMappingType)) {
            headerBuilder.setColumnTitle(instanceTitle);
            headerBuilder.setColumnGroup(columnGroup);
            headerBuilder.setInstanceHeader(true);
            return headerBuilder;
        }
        ScenarioSimulationBuilders.HeaderBuilder instanceHeader = headerBuilder.newLevel().setColumnTitle(instanceTitle).setColumnGroup(columnGroup).setReadOnly(false).setInstanceHeader(true).setPropertyHeader(false);
        instanceHeader.newLevel().setColumnTitle(propertyTitle).setColumnGroup(ScenarioSimulationUtils.getColumnSubGroup(columnGroup)).setReadOnly(false).setInstanceHeader(false).setPropertyHeader(true);
        return headerBuilder;
    }

    public static Point2D getMiddleXYCell(GridWidget gridWidget, GridColumn<?> column, boolean isHeader, int uiRowIndex, GridLayer gridLayer) {
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
        double columnXCoordinate = rendererHelper.getColumnOffset(column) + column.getWidth() / 2.0;
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(columnXCoordinate);
        GridBodyCellEditContext context = isHeader ? CellContextUtilities.makeHeaderCellRenderContext((GridWidget)gridWidget, (BaseGridRendererHelper.RenderingInformation)ri, (BaseGridRendererHelper.ColumnInformation)ci, (int)uiRowIndex) : CellContextUtilities.makeCellRenderContext((GridWidget)gridWidget, (BaseGridRendererHelper.RenderingInformation)ri, (BaseGridRendererHelper.ColumnInformation)ci, (int)uiRowIndex);
        int cellXMiddle = (int)(context.getAbsoluteCellX() + context.getCellWidth() / 2.0 + (double)gridLayer.getDomElementContainer().getAbsoluteLeft());
        int cellYMiddle = (int)(context.getAbsoluteCellY() + context.getCellHeight() / 2.0 + (double)gridLayer.getDomElementContainer().getAbsoluteTop());
        return new Point2D((double)cellXMiddle, (double)cellYMiddle);
    }

    protected static double getColumnWidth(String columnId) {
        ExpressionIdentifier.NAME expressionName = ExpressionIdentifier.NAME.Other;
        try {
            expressionName = ExpressionIdentifier.NAME.valueOf((String)columnId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (expressionName) {
            case Index: {
                return 70.0;
            }
            case Description: {
                return 300.0;
            }
        }
        return 114.0;
    }

    private static boolean isOther(FactMappingType factMappingType) {
        return FactMappingType.OTHER.equals((Object)factMappingType);
    }
}

