/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationViolation;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioGridCommand;
import org.kie.workbench.common.command.client.Command;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.kie.workbench.common.command.client.registry.command.CommandRegistryImpl;

@Dependent
public class ScenarioCommandRegistry
extends CommandRegistryImpl<AbstractScenarioGridCommand> {
    protected final Deque<AbstractScenarioGridCommand> undoneCommands = new ArrayDeque<AbstractScenarioGridCommand>();

    public void register(ScenarioSimulationContext context, AbstractScenarioGridCommand command) {
        super.register((Command)command);
        this.undoneCommands.clear();
        this.setUndoRedoButtonStatus(context);
    }

    public CommandResult<ScenarioSimulationViolation> undo(ScenarioSimulationContext scenarioSimulationContext) {
        CommandResult<ScenarioSimulationViolation> toReturn;
        if (!this.getCommandHistory().isEmpty()) {
            Optional<CommandResult<ScenarioSimulationViolation>> optionalPreexecuted = this.commonUndoRedoPreexecution(scenarioSimulationContext, (AbstractScenarioGridCommand)this.peek());
            if (optionalPreexecuted.isPresent()) {
                return optionalPreexecuted.get();
            }
            AbstractScenarioGridCommand toUndo = (AbstractScenarioGridCommand)this.pop();
            toReturn = this.commonUndoRedoOperation(scenarioSimulationContext, toUndo, true);
            if (Objects.equals(CommandResultBuilder.SUCCESS, toReturn)) {
                this.undoneCommands.push(toUndo);
            }
        } else {
            toReturn = new CommandResult<ScenarioSimulationViolation>(CommandResult.Type.WARNING, Collections.singletonList(new ScenarioSimulationViolation("No commands to undo")));
        }
        this.setUndoRedoButtonStatus(scenarioSimulationContext);
        return toReturn;
    }

    public CommandResult<ScenarioSimulationViolation> redo(ScenarioSimulationContext scenarioSimulationContext) {
        CommandResult<ScenarioSimulationViolation> toReturn;
        if (!this.undoneCommands.isEmpty()) {
            Optional<CommandResult<ScenarioSimulationViolation>> optionalPreexecuted = this.commonUndoRedoPreexecution(scenarioSimulationContext, this.undoneCommands.peek());
            if (optionalPreexecuted.isPresent()) {
                return optionalPreexecuted.get();
            }
            AbstractScenarioGridCommand toRedo = this.undoneCommands.pop();
            toReturn = this.commonUndoRedoOperation(scenarioSimulationContext, toRedo, false);
            if (Objects.equals(CommandResultBuilder.SUCCESS, toReturn)) {
                this.register((Command)toRedo);
            }
        } else {
            toReturn = new CommandResult<ScenarioSimulationViolation>(CommandResult.Type.WARNING, Collections.singletonList(new ScenarioSimulationViolation("No commands to redo")));
        }
        this.setUndoRedoButtonStatus(scenarioSimulationContext);
        return toReturn;
    }

    protected Optional<CommandResult<ScenarioSimulationViolation>> commonUndoRedoPreexecution(ScenarioSimulationContext scenarioSimulationContext, AbstractScenarioGridCommand command) {
        return command.commonUndoRedoPreexecution(scenarioSimulationContext);
    }

    protected CommandResult<ScenarioSimulationViolation> commonUndoRedoOperation(ScenarioSimulationContext scenarioSimulationContext, AbstractScenarioGridCommand command, boolean isUndo) {
        CommandResult<ScenarioSimulationViolation> toReturn = isUndo ? command.undo(scenarioSimulationContext) : command.redo(scenarioSimulationContext);
        return toReturn;
    }

    protected void setUndoRedoButtonStatus(ScenarioSimulationContext scenarioSimulationContext) {
        scenarioSimulationContext.scenarioSimulationEditorPresenter.setUndoButtonEnabledStatus(!this.getCommandHistory().isEmpty());
        scenarioSimulationContext.scenarioSimulationEditorPresenter.setRedoButtonEnabledStatus(!this.undoneCommands.isEmpty());
    }
}

