/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.LIElement;
import com.google.web.bindery.event.shared.Event;
import java.util.Objects;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractHeaderMenuPresenter;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DuplicateRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertRowEvent;

public abstract class GridContextMenu
extends AbstractHeaderMenuPresenter {
    protected static final String GRIDCONTEXTMENU_GRID_TITLE = "gridcontextmenu-grid-title";
    protected static final String GRIDCONTEXTMENU_INSERT_ROW_ABOVE = "gridcontextmenu-insert-row-above";
    protected static final String GRIDCONTEXTMENU_INSERT_ROW_BELOW = "gridcontextmenu-insert-row-below";
    protected static final String GRIDCONTEXTMENU_DELETE_ROW = "gridcontextmenu-delete-row";
    protected static final String GRIDCONTEXTMENU_DUPLICATE_ROW = "gridcontextmenu-duplicate-row";
    protected LIElement insertRowAboveLIElement;
    protected LIElement insertRowBelowLIElement;
    protected LIElement duplicateRowLIElement;
    protected LIElement deleteRowLIElement;

    @Override
    public void initMenu() {
        super.initMenu();
        this.removeMenuItem(this.insertRowBelowElement);
        this.insertRowAboveLIElement = this.addExecutableMenuItem(GRIDCONTEXTMENU_INSERT_ROW_ABOVE, this.constants.insertRowAbove(), "insertRowAbove");
        this.insertRowBelowLIElement = this.addExecutableMenuItem(GRIDCONTEXTMENU_INSERT_ROW_BELOW, this.constants.insertRowBelow(), "insertRowBelow");
        this.duplicateRowLIElement = this.addExecutableMenuItem(GRIDCONTEXTMENU_DUPLICATE_ROW, this.constants.duplicateRow(), "duplicateRow");
        this.deleteRowLIElement = this.addExecutableMenuItem(GRIDCONTEXTMENU_DELETE_ROW, this.constants.deleteRow(), "deleteRow");
    }

    public void show(GridWidget gridWidget, int mx, int my, int rowIndex) {
        this.show(gridWidget, mx, my);
        this.mapEvent(this.insertRowAboveLIElement, (Event)new InsertRowEvent(gridWidget, rowIndex));
        this.mapEvent(this.insertRowBelowLIElement, (Event)new InsertRowEvent(gridWidget, rowIndex + 1));
        this.mapEvent(this.duplicateRowLIElement, (Event)new DuplicateRowEvent(gridWidget, rowIndex));
        this.mapEvent(this.deleteRowLIElement, (Event)new DeleteRowEvent(gridWidget, rowIndex));
        if (Objects.equals((Object)GridWidget.BACKGROUND, (Object)gridWidget)) {
            this.updateMenuItemAttributes(this.gridTitleElement, GRIDCONTEXTMENU_GRID_TITLE, this.constants.background(), "background");
        } else if (Objects.equals((Object)GridWidget.SIMULATION, (Object)gridWidget)) {
            this.updateMenuItemAttributes(this.gridTitleElement, GRIDCONTEXTMENU_GRID_TITLE, this.constants.scenario(), "scenario");
        }
    }
}

