/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionEditorUtils;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.KeyValueElementView;

public class KeyValueElementPresenter
extends ElementPresenter<KeyValueElementView>
implements KeyValueElementView.Presenter {
    @Override
    public LIElement getKeyValueContainer(String itemId, Map<String, String> keyPropertiesValues, Map<String, String> valuePropertiesValues) {
        KeyValueElementView keyValueElementView = this.viewsProvider.getKeyValueElementView();
        keyValueElementView.init(this);
        keyValueElementView.setItemId(itemId);
        UListElement keyContainer = keyValueElementView.getKeyContainer();
        List<String> keyValueIds = this.getKeyValueIds(itemId);
        keyPropertiesValues.forEach((propertyName, propertyValue) -> {
            LIElement cfr_ignored_0 = (LIElement)keyContainer.appendChild((Node)this.propertyPresenter.getPropertyFields((String)keyValueIds.get(0), (String)propertyName, (String)propertyValue));
        });
        UListElement valueContainer = keyValueElementView.getValueContainer();
        valuePropertiesValues.forEach((propertyName, propertyValue) -> {
            LIElement cfr_ignored_0 = (LIElement)valueContainer.appendChild((Node)this.propertyPresenter.getPropertyFields((String)keyValueIds.get(1), (String)propertyName, (String)propertyValue));
        });
        this.elementViewList.add(keyValueElementView);
        return keyValueElementView.getItemContainer();
    }

    @Override
    public void onToggleRowExpansion(KeyValueElementView keyValueElementView, boolean isShown) {
        CollectionEditorUtils.toggleRowExpansion(keyValueElementView.getFaAngleRight(), !isShown);
        CollectionEditorUtils.toggleRowExpansion(keyValueElementView.getKeyLabel(), isShown);
        CollectionEditorUtils.toggleRowExpansion(keyValueElementView.getValueLabel(), isShown);
        List<String> keyValueIds = this.getKeyValueIds(keyValueElementView.getItemId());
        keyValueIds.forEach(id -> this.propertyPresenter.onToggleRowExpansion((String)id, isShown));
        this.updateCommonToggleStatus(isShown);
    }

    @Override
    public void onEditItem(KeyValueElementView keyValueElementView) {
        if (!keyValueElementView.isShown()) {
            this.onToggleRowExpansion(keyValueElementView, false);
        }
        List<String> keyValueIds = this.getKeyValueIds(keyValueElementView.getItemId());
        keyValueIds.forEach(id -> this.propertyPresenter.editProperties((String)id));
        keyValueElementView.getSaveChange().getStyle().setDisplay(Style.Display.INLINE);
        this.toggleEditingStatus(true);
        this.collectionEditorPresenter.toggleEditingStatus(true);
    }

    @Override
    public void onStopEditingItem(KeyValueElementView keyValueElementView) {
        List<String> keyValueIds = this.getKeyValueIds(keyValueElementView.getItemId());
        keyValueIds.forEach(id -> this.propertyPresenter.stopEditProperties((String)id));
        keyValueElementView.getSaveChange().getStyle().setDisplay(Style.Display.NONE);
        this.toggleEditingStatus(false);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public void onDeleteItem(KeyValueElementView keyValueElementView) {
        List<String> keyValueIds = this.getKeyValueIds(keyValueElementView.getItemId());
        keyValueIds.forEach(id -> this.propertyPresenter.deleteProperties((String)id));
        keyValueElementView.getItemContainer().removeFromParent();
        this.elementViewList.remove(keyValueElementView);
        this.toggleEditingStatus(false);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public void updateItem(KeyValueElementView keyValueElementView) {
        List<String> keyValueIds = this.getKeyValueIds(keyValueElementView.getItemId());
        keyValueIds.forEach(id -> this.propertyPresenter.updateProperties((String)id));
        keyValueElementView.getSaveChange().getStyle().setDisplay(Style.Display.NONE);
        this.toggleEditingStatus(false);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public Map<Map<String, String>, Map<String, String>> getItemsProperties() {
        return this.elementViewList.stream().collect(Collectors.toMap(keyValueElementView -> {
            String itemId = keyValueElementView.getItemId() + "#key";
            return this.propertyPresenter.getSimpleProperties(itemId);
        }, keyValueElementView -> {
            String itemId = keyValueElementView.getItemId() + "#value";
            return this.propertyPresenter.getSimpleProperties(itemId);
        }));
    }

    private List<String> getKeyValueIds(String itemId) {
        return Arrays.asList(itemId + "#key", itemId + "#value");
    }
}

