/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractSelectedColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;

public class DuplicateInstanceCommand
extends AbstractSelectedColumnCommand {
    public static final String COPY_LABEL = "_copy_";

    public DuplicateInstanceCommand(GridWidget gridWidget) {
        super(gridWidget, FactMappingValueType.NOT_EXPRESSION);
    }

    @Override
    protected void executeIfSelectedColumn(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn) {
        AbstractScesimGridModel selectedScenarioGridModel = context.getAbstractScesimGridModelByGridWidget(this.gridWidget);
        int instancesCount = selectedScenarioGridModel.getInstancesCount(selectedColumn.getFactIdentifier().getClassName());
        String alias = selectedColumn.getInformationHeaderMetaData().getTitle().split(COPY_LABEL)[0] + COPY_LABEL + instancesCount;
        int columnPosition = selectedScenarioGridModel.getInstanceLimits(selectedScenarioGridModel.getColumns().indexOf((Object)selectedColumn)).getMaxRowIndex() + 1;
        AtomicInteger nextColumnPosition = new AtomicInteger(columnPosition);
        selectedScenarioGridModel.getInstanceScenarioGridColumns(selectedColumn).forEach(originalColumn -> {
            ScenarioGridColumn createdColumn = this.insertNewColumn(context, (ScenarioGridColumn)((Object)originalColumn), nextColumnPosition.getAndIncrement(), false);
            if (originalColumn.isInstanceAssigned()) {
                this.setInstanceHeader(context, createdColumn, alias, originalColumn.getFactIdentifier().getClassName());
                if (originalColumn.isPropertyAssigned()) {
                    int originalColumnIndex = selectedScenarioGridModel.getColumns().indexOf(originalColumn);
                    FactMapping originalFactMapping = ((AbstractScesimModel)selectedScenarioGridModel.getAbstractScesimModel().get()).getScesimModelDescriptor().getFactMappingByIndex(originalColumnIndex);
                    this.factMappingValueType = originalFactMapping.getFactMappingValueType();
                    ArrayList<String> propertyNameElements = new ArrayList<String>();
                    propertyNameElements.add(alias);
                    propertyNameElements.addAll(originalFactMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList()));
                    this.setPropertyHeader(context, createdColumn, propertyNameElements, originalFactMapping.getClassName(), originalColumn.getPropertyHeaderMetaData().getTitle());
                    int createdColumnIndex = selectedScenarioGridModel.getColumns().indexOf((Object)createdColumn);
                    selectedScenarioGridModel.duplicateColumnValues(originalColumnIndex, createdColumnIndex);
                }
            }
        });
    }
}

