/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationViolation;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationUndoableCommand;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.kie.workbench.common.command.client.impl.CommandResultImpl;

public class UpdateSettingsDataCommand
extends AbstractScenarioSimulationUndoableCommand<Settings> {
    private final Consumer<Settings> settingsConsumer;

    public UpdateSettingsDataCommand(Consumer<Settings> settingsConsumer) {
        this.settingsConsumer = settingsConsumer;
    }

    @Override
    protected Settings setRestorableStatusPreExecution(ScenarioSimulationContext context) {
        return context.getScenarioSimulationModel().getSettings().cloneSettings();
    }

    @Override
    public Optional<CommandResult<ScenarioSimulationViolation>> commonUndoRedoPreExecution(ScenarioSimulationContext context) {
        context.getScenarioSimulationEditorPresenter().expandSettingsDock();
        return Optional.of(CommandResultBuilder.SUCCESS);
    }

    @Override
    protected CommandResult<ScenarioSimulationViolation> setCurrentContext(ScenarioSimulationContext context) {
        try {
            if (this.restorableStatus == null) {
                throw new IllegalStateException("restorableStatus is null");
            }
            Settings originalSettings = context.getScenarioSimulationModel().getSettings().cloneSettings();
            context.getScenarioSimulationEditorPresenter().getModel().setSettings((Settings)this.restorableStatus);
            this.restorableStatus = originalSettings;
            context.getScenarioSimulationEditorPresenter().reloadSettingsDock();
            return this.commonExecution(context);
        }
        catch (Exception e) {
            return new CommandResultImpl(CommandResult.Type.ERROR, Collections.singleton(new ScenarioSimulationViolation(e.getMessage())));
        }
    }

    @Override
    protected void internalExecute(ScenarioSimulationContext context) {
        this.settingsConsumer.accept(context.getScenarioSimulationModel().getSettings());
        context.getScenarioSimulationEditorPresenter().reloadSettingsDock();
    }
}

