/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionEditorUtils;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementView;

public class ItemElementPresenter
extends ElementPresenter<ItemElementView>
implements ItemElementView.Presenter {
    protected Map<String, List<String>> itemIdExpandablePropertiesMap = new HashMap<String, List<String>>();

    @Override
    public LIElement getItemContainer(String itemId, Map<String, String> simplePropertiesMap, Map<String, Map<String, String>> expandablePropertiesValues) {
        ItemElementView itemElementView = this.viewsProvider.getListEditorElementView();
        itemElementView.init(this);
        itemElementView.setItemId(itemId);
        UListElement innerItemContainer = itemElementView.getInnerItemContainer();
        LIElement saveChange = itemElementView.getSaveChange();
        simplePropertiesMap.forEach((propertyName, propertyValue) -> innerItemContainer.insertBefore((Node)this.propertyPresenter.getPropertyFields(itemId, (String)propertyName, (String)propertyValue), (Node)saveChange));
        this.itemIdExpandablePropertiesMap.put(itemId, new ArrayList());
        expandablePropertiesValues.forEach((nestedPropertyName, nestedPropertiesValues) -> {
            this.itemIdExpandablePropertiesMap.get(itemId).add((String)nestedPropertyName);
            this.addExpandableItemElementView(itemElementView, (Map<String, String>)nestedPropertiesValues, (String)nestedPropertyName);
        });
        this.elementViewList.add(itemElementView);
        return itemElementView.getItemContainer();
    }

    @Override
    public void onToggleRowExpansion(ItemElementView itemElementView, boolean isShown) {
        CollectionEditorUtils.toggleRowExpansion(itemElementView.getFaAngleRight(), !isShown);
        this.propertyPresenter.onToggleRowExpansion(itemElementView.getItemId(), isShown);
        if (this.itemIdExpandablePropertiesMap.containsKey(itemElementView.getItemId())) {
            this.itemIdExpandablePropertiesMap.get(itemElementView.getItemId()).forEach(expandablePropertyName -> this.propertyPresenter.onToggleRowExpansion(this.generateExpandableItemElementID(itemElementView, (String)expandablePropertyName), isShown));
        }
        this.updateCommonToggleStatus(isShown);
    }

    @Override
    public void onEditItem(ItemElementView itemElementView) {
        if (!itemElementView.isShown()) {
            this.onToggleRowExpansion(itemElementView, false);
        }
        this.propertyPresenter.editProperties(itemElementView.getItemId());
        this.itemIdExpandablePropertiesMap.get(itemElementView.getItemId()).forEach(expandablePropertyName -> this.propertyPresenter.editProperties(this.generateExpandableItemElementID(itemElementView, (String)expandablePropertyName)));
        itemElementView.getSaveChange().getStyle().setDisplay(Style.Display.INLINE);
        this.collectionEditorPresenter.toggleEditingStatus(true);
    }

    @Override
    public void onStopEditingItem(ItemElementView itemElementView) {
        this.propertyPresenter.stopEditProperties(itemElementView.getItemId());
        this.itemIdExpandablePropertiesMap.get(itemElementView.getItemId()).forEach(expandablePropertyName -> this.propertyPresenter.stopEditProperties(this.generateExpandableItemElementID(itemElementView, (String)expandablePropertyName)));
        itemElementView.getSaveChange().getStyle().setDisplay(Style.Display.NONE);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public void updateItem(ItemElementView itemElementView) {
        this.propertyPresenter.updateProperties(itemElementView.getItemId());
        this.itemIdExpandablePropertiesMap.get(itemElementView.getItemId()).forEach(expandablePropertyName -> this.propertyPresenter.updateProperties(this.generateExpandableItemElementID(itemElementView, (String)expandablePropertyName)));
        itemElementView.getSaveChange().getStyle().setDisplay(Style.Display.NONE);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public void onDeleteItem(ItemElementView itemElementView) {
        this.propertyPresenter.deleteProperties(itemElementView.getItemId());
        this.itemIdExpandablePropertiesMap.get(itemElementView.getItemId()).forEach(expandablePropertyName -> this.propertyPresenter.deleteProperties(this.generateExpandableItemElementID(itemElementView, (String)expandablePropertyName)));
        itemElementView.getItemContainer().removeFromParent();
        this.elementViewList.remove(itemElementView);
        this.collectionEditorPresenter.toggleEditingStatus(false);
    }

    @Override
    public Map<String, Map<String, String>> getSimpleItemsProperties() {
        return this.elementViewList.stream().collect(Collectors.toMap(ElementView::getItemId, itemElementView -> this.propertyPresenter.getSimpleProperties(itemElementView.getItemId())));
    }

    @Override
    public Map<String, Map<String, Map<String, String>>> getExpandableItemsProperties() {
        HashMap<String, Map<String, Map<String, String>>> toReturn = new HashMap<String, Map<String, Map<String, String>>>();
        this.elementViewList.forEach(itemElementView -> {
            List<String> expandablePropertiesNames = this.itemIdExpandablePropertiesMap.get(itemElementView.getItemId());
            HashMap expandableProperties = new HashMap();
            expandablePropertiesNames.forEach(expandablePropertyName -> {
                Map<String, String> simpleProperties = this.propertyPresenter.getSimpleProperties(this.generateExpandableItemElementID((ItemElementView)itemElementView, (String)expandablePropertyName));
                expandableProperties.put(expandablePropertyName, simpleProperties);
            });
            toReturn.put(itemElementView.getItemId(), expandableProperties);
        });
        return toReturn;
    }

    protected void addExpandableItemElementView(ItemElementView containerItemElementView, Map<String, String> propertiesMap, String expandablePropertyName) {
        ItemElementView itemElementView = this.viewsProvider.getListEditorElementView();
        itemElementView.init(this);
        UListElement innerItemContainer = itemElementView.getInnerItemContainer();
        String expandableItemID = this.generateExpandableItemElementID(containerItemElementView, expandablePropertyName);
        itemElementView.setItemSeparatorText(expandablePropertyName);
        itemElementView.getEditItemButton().removeFromParent();
        itemElementView.getDeleteItemButton().removeFromParent();
        itemElementView.getSaveChange().removeFromParent();
        itemElementView.setItemId(expandableItemID);
        propertiesMap.forEach((propertyName, propertyValue) -> innerItemContainer.appendChild((Node)this.propertyPresenter.getPropertyFields(expandableItemID, (String)propertyName, (String)propertyValue)));
        containerItemElementView.getInnerItemContainer().insertBefore((Node)itemElementView.getItemContainer(), (Node)containerItemElementView.getSaveChange());
    }

    protected String generateExpandableItemElementID(ItemElementView itemElementView, String expandablePropertyName) {
        return itemElementView.getItemId() + "." + expandablePropertyName;
    }
}

