/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.LabelElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TextAreaElement;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FocusWidget;
import java.util.Map;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionEditorUtils;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionView;
import org.drools.workbench.screens.scenariosimulation.client.events.CloseCompositeEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SaveEditorEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.CloseCompositeEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.HasCloseCompositeHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.HasSaveEditorHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.SaveEditorEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ExpressionUtils;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class CollectionViewImpl
extends FocusWidget
implements HasCloseCompositeHandler,
HasSaveEditorHandler,
CollectionView {
    @Inject
    protected CollectionPresenter presenter;
    @DataField(value="collectionEditor")
    protected DivElement collectionEditor = Document.get().createDivElement();
    @DataField(value="collectionEditorModalBody")
    protected DivElement collectionEditorModalBody = Document.get().createDivElement();
    @DataField(value="elementsContainer")
    protected UListElement elementsContainer = Document.get().createULElement();
    @DataField(value="closeCollectionEditorButton")
    protected ButtonElement closeCollectionEditorButton = Document.get().createPushButtonElement();
    @DataField(value="createCollectionRadio")
    protected InputElement createCollectionRadio = Document.get().createRadioInputElement("collectionRadio");
    @DataField(value="defineCollectionRadio")
    protected InputElement defineCollectionRadio = Document.get().createRadioInputElement("collectionRadio");
    @DataField(value="cancelButton")
    protected ButtonElement cancelButton = Document.get().createPushButtonElement();
    @DataField(value="removeButton")
    protected ButtonElement removeButton = Document.get().createPushButtonElement();
    @DataField(value="removeButtonSpanText")
    protected SpanElement removeButtonSpanText = Document.get().createSpanElement();
    @DataField(value="saveButton")
    protected ButtonElement saveButton = Document.get().createPushButtonElement();
    @DataField(value="saveButtonSpanText")
    protected SpanElement saveButtonSpanText = Document.get().createSpanElement();
    @DataField(value="addItemButton")
    protected ButtonElement addItemButton = Document.get().createPushButtonElement();
    @DataField(value="editorTitle")
    protected HeadingElement editorTitle = Document.get().createHElement(4);
    @DataField(value="faAngleRight")
    protected SpanElement faAngleRight = Document.get().createSpanElement();
    @DataField(value="propertyTitle")
    protected SpanElement propertyTitle = Document.get().createSpanElement();
    @DataField(value="defineCollectionContainer")
    protected DivElement defineCollectionContainer = Document.get().createDivElement();
    @DataField(value="createCollectionContainer")
    protected DivElement createCollectionContainer = Document.get().createDivElement();
    @DataField(value="addItemButtonLabel")
    protected SpanElement addItemButtonLabel = Document.get().createSpanElement();
    @DataField(value="createLabel")
    protected LabelElement createLabel = Document.get().createLabelElement();
    @DataField(value="collectionCreationModeLabel")
    protected LabelElement collectionCreationModeLabel = Document.get().createLabelElement();
    @DataField(value="collectionCreationCreateLabel")
    protected SpanElement collectionCreationCreateLabel = Document.get().createSpanElement();
    @DataField(value="collectionCreationCreateSpan")
    protected SpanElement collectionCreationCreateSpan = Document.get().createSpanElement();
    @DataField(value="collectionCreationDefineLabel")
    protected SpanElement collectionCreationDefineLabel = Document.get().createSpanElement();
    @DataField(value="collectionCreationDefineSpan")
    protected SpanElement collectionCreationDefineSpan = Document.get().createSpanElement();
    @DataField(value="expressionElement")
    protected TextAreaElement expressionElement = Document.get().createTextAreaElement();
    protected boolean listWidget;
    protected ScenarioSimulationModel.Type scenarioType;
    protected String value;

    public CollectionViewImpl() {
        this.setElement((Element)this.collectionEditor);
    }

    @Override
    public void initListStructure(String key, Map<String, String> simplePropertiesMap, Map<String, Map<String, String>> expandablePropertiesMap, ScenarioSimulationModel.Type type) {
        this.listWidget = true;
        this.commonInit(type);
        this.createLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelList());
        this.collectionCreationModeLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.collectionListCreation());
        this.collectionCreationCreateLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelList());
        this.collectionCreationCreateSpan.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelListDescription());
        this.collectionCreationDefineLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.defineLabelList());
        this.collectionCreationDefineSpan.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.defineLabelListDescription());
        this.addItemButtonLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.addNewListItem());
        this.presenter.initListStructure(key, simplePropertiesMap, expandablePropertiesMap, this);
    }

    @Override
    public void initMapStructure(String key, Map<String, String> keyPropertyMap, Map<String, String> valuePropertyMap, ScenarioSimulationModel.Type type) {
        this.listWidget = false;
        this.commonInit(type);
        this.createLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelMap());
        this.collectionCreationModeLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.collectionMapCreation());
        this.collectionCreationCreateLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelMap());
        this.collectionCreationCreateSpan.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelMapDescription());
        this.collectionCreationDefineLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.defineLabelMap());
        this.collectionCreationDefineSpan.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.defineLabelMapDescription());
        this.addItemButtonLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.addNewMapItem());
        this.presenter.initMapStructure(key, keyPropertyMap, valuePropertyMap, this);
    }

    protected void commonInit(ScenarioSimulationModel.Type type) {
        this.scenarioType = type;
        this.cancelButton.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.cancelButton());
        this.saveButtonSpanText.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.saveButton());
        this.removeButtonSpanText.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.removeButton());
        this.enableCreateCollectionContainer(true);
        if (ScenarioSimulationModel.Type.RULE.equals((Object)this.scenarioType)) {
            this.initAndRegisterHandlerForExpressionTextArea();
        }
    }

    protected void initAndRegisterHandlerForExpressionTextArea() {
        this.ensureExpressionSyntax();
        DOM.sinkBitlessEvent((Element)this.expressionElement, (String)"input");
        DOM.setEventListener((Element)this.expressionElement, event -> {
            if ("input".contains(event.getType())) {
                this.ensureExpressionSyntax();
            }
        });
    }

    @Override
    public HandlerRegistration addCloseCompositeEventHandler(CloseCompositeEventHandler handler) {
        return this.addDomHandler(handler, CloseCompositeEvent.getType());
    }

    @Override
    public HandlerRegistration addSaveEditorEventHandler(SaveEditorEventHandler handler) {
        return this.addDomHandler(handler, SaveEditorEvent.getType());
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String jsonString) {
        this.presenter.setValue(jsonString);
    }

    @Override
    public boolean isExpressionWidget() {
        return this.defineCollectionRadio.isChecked();
    }

    @Override
    public boolean isListWidget() {
        return this.listWidget;
    }

    @Override
    public UListElement getElementsContainer() {
        return this.elementsContainer;
    }

    @Override
    public HeadingElement getEditorTitle() {
        return this.editorTitle;
    }

    @Override
    public SpanElement getPropertyTitle() {
        return this.propertyTitle;
    }

    @Override
    public String getExpression() {
        return this.expressionElement.getValue();
    }

    @Override
    public void setExpression(String expressionValue) {
        this.enableCreateCollectionContainer(false);
        this.expressionElement.setValue(expressionValue);
    }

    @EventHandler(value={"createCollectionRadio"})
    public void onCreateCollectionClick(ClickEvent clickEvent) {
        this.enableCreateCollectionContainer(true);
    }

    @EventHandler(value={"defineCollectionRadio"})
    public void onDefineCollectionClick(ClickEvent clickEvent) {
        this.enableCreateCollectionContainer(false);
    }

    protected void enableCreateCollectionContainer(boolean toEnable) {
        this.showCreateCollectionContainer(toEnable);
        this.showDefineCollectionContainer(!toEnable);
        this.showAddItemButton(toEnable);
        this.createCollectionRadio.setChecked(toEnable);
        this.defineCollectionRadio.setChecked(!toEnable);
        if (this.listWidget) {
            this.createLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelList());
        } else {
            this.createLabel.setInnerText(ScenarioSimulationEditorConstants.INSTANCE.createLabelMap());
        }
    }

    @EventHandler(value={"closeCollectionEditorButton"})
    public void onCloseCollectionEditorButtonClick(ClickEvent clickEvent) {
        this.close();
    }

    @EventHandler(value={"cancelButton"})
    public void onCancelButtonClick(ClickEvent clickEvent) {
        this.close();
    }

    @EventHandler(value={"removeButton"})
    public void onRemoveButtonClick(ClickEvent clickEvent) {
        this.presenter.remove();
    }

    @EventHandler(value={"saveButton"})
    public void onSaveButtonClick(ClickEvent clickEvent) {
        this.presenter.save();
    }

    @EventHandler(value={"addItemButton"})
    public void onAddItemButton(ClickEvent clickEvent) {
        this.presenter.showEditingBox();
    }

    @EventHandler(value={"faAngleRight"})
    public void onFaAngleRightClick(ClickEvent clickEvent) {
        this.presenter.onToggleRowExpansion(this.isShown());
    }

    @Override
    public void toggleRowExpansion() {
        this.toggleRowExpansion(!this.isShown());
    }

    @Override
    public void updateRowExpansionStatus(boolean isShown) {
        this.toggleRowExpansion(!isShown);
    }

    @Override
    public void updateValue(String value) {
        this.value = value;
        this.fireEvent((GwtEvent)new SaveEditorEvent());
    }

    @Override
    public void close() {
        this.fireEvent((GwtEvent)new CloseCompositeEvent());
    }

    @Override
    public void setFixedHeight(double value, Style.Unit unit) {
        this.collectionEditorModalBody.getStyle().setHeight(value, unit);
    }

    @Override
    public void enableEditingMode(boolean isEditingMode) {
        this.createCollectionRadio.setDisabled(isEditingMode);
        this.defineCollectionRadio.setDisabled(isEditingMode);
        this.showAddItemButton(!isEditingMode);
        this.addItemButton.setDisabled(isEditingMode);
        this.cancelButton.setDisabled(isEditingMode);
        this.removeButton.setDisabled(isEditingMode);
        this.saveButton.setDisabled(isEditingMode);
    }

    protected boolean isShown() {
        return CollectionEditorUtils.isShown(this.faAngleRight);
    }

    protected void toggleRowExpansion(boolean toExpand) {
        CollectionEditorUtils.toggleRowExpansion(this.faAngleRight, toExpand);
    }

    protected void ensureExpressionSyntax() {
        if (ScenarioSimulationModel.Type.RULE.equals((Object)this.scenarioType)) {
            this.expressionElement.setValue(ExpressionUtils.ensureExpressionSyntax(this.expressionElement.getValue()));
        }
    }

    protected void showCreateCollectionContainer(boolean show) {
        if (show) {
            this.createCollectionContainer.getStyle().setDisplay(Style.Display.BLOCK);
        } else {
            this.createCollectionContainer.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    protected void showDefineCollectionContainer(boolean show) {
        if (show) {
            this.defineCollectionContainer.getStyle().setDisplay(Style.Display.BLOCK);
        } else {
            this.defineCollectionContainer.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    protected void showAddItemButton(boolean show) {
        if (show) {
            this.addItemButton.getStyle().setDisplay(Style.Display.BLOCK);
        } else {
            this.addItemButton.getStyle().setDisplay(Style.Display.NONE);
        }
    }
}

