/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationViolation;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationUndoableCommand;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.kie.workbench.common.command.client.impl.CommandResultImpl;

public abstract class AbstractScenarioGridCommand
extends AbstractScenarioSimulationUndoableCommand<ScenarioSimulationContext.Status> {
    protected GridWidget gridWidget;

    protected AbstractScenarioGridCommand(GridWidget gridWidget) {
        this.gridWidget = gridWidget;
    }

    @Override
    protected ScenarioSimulationContext.Status setRestorableStatusPreExecution(ScenarioSimulationContext context) {
        return context.getStatus().cloneStatus();
    }

    @Override
    protected CommandResult<ScenarioSimulationViolation> setCurrentContext(ScenarioSimulationContext context) {
        try {
            Simulation simulationToRestore = ((ScenarioSimulationContext.Status)this.restorableStatus).getSimulation();
            Background backgroundToRestore = ((ScenarioSimulationContext.Status)this.restorableStatus).getBackground();
            if (simulationToRestore == null) {
                throw new IllegalStateException("Simulation is null in restorable status");
            }
            if (backgroundToRestore == null) {
                throw new IllegalStateException("Background is null in restorable status");
            }
            ScenarioSimulationContext.Status originalStatus = context.getStatus().cloneStatus();
            ScenarioSimulationModel.Type type = context.getScenarioSimulationModel().getSettings().getType();
            context.getSimulationGrid().getModel().clearSelections();
            context.getBackgroundGrid().getModel().clearSelections();
            context.getSimulationGrid().setContent((AbstractScesimModel)simulationToRestore, type);
            context.getScenarioSimulationEditorPresenter().getModel().setSimulation(simulationToRestore);
            context.getBackgroundGrid().setContent((AbstractScesimModel)backgroundToRestore, type);
            context.getScenarioSimulationEditorPresenter().getModel().setBackground(backgroundToRestore);
            context.getScenarioSimulationEditorPresenter().reloadTestTools(true);
            context.setStatus((ScenarioSimulationContext.Status)this.restorableStatus);
            this.restorableStatus = originalStatus;
            return this.commonExecution(context);
        }
        catch (Exception e) {
            return new CommandResultImpl(CommandResult.Type.ERROR, Collections.singleton(new ScenarioSimulationViolation(e.getMessage())));
        }
    }

    @Override
    public Optional<CommandResult<ScenarioSimulationViolation>> commonUndoRedoPreExecution(ScenarioSimulationContext context) {
        Optional<GridWidget> selectedGridWidgetOptional = context.getSelectedGridWidget();
        if (selectedGridWidgetOptional.isPresent() && Objects.equals((Object)this.gridWidget, (Object)selectedGridWidgetOptional.get())) {
            return Optional.empty();
        }
        switch (this.gridWidget) {
            case SIMULATION: {
                context.getScenarioSimulationEditorPresenter().selectSimulationTab();
                break;
            }
            case BACKGROUND: {
                context.getScenarioSimulationEditorPresenter().selectBackgroundTab();
                break;
            }
            default: {
                throw new IllegalStateException("Illegal GridWidget " + (Object)((Object)this.gridWidget));
            }
        }
        context.getScenarioGridPanelByGridWidget(this.gridWidget).onResize();
        context.getScenarioGridPanelByGridWidget(this.gridWidget).select();
        return Optional.of(CommandResultBuilder.SUCCESS);
    }

    protected ScenarioGridColumn getScenarioGridColumnLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = ScenarioSimulationUtils.getHeaderBuilder(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, factoryHeader);
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, factoryCell, placeHolder);
    }

    protected Optional<FactIdentifier> getFactIdentifierByColumnTitle(String columnTitle, ScenarioSimulationContext context) {
        return context.getAbstractScesimGridModelByGridWidget(this.gridWidget).getColumns().stream().filter(column -> columnTitle.equals(((ScenarioGridColumn)((Object)column)).getInformationHeaderMetaData().getTitle())).findFirst().map(column -> ((ScenarioGridColumn)((Object)column)).getFactIdentifier());
    }
}

