/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.service.ScenarioTestEditorService;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.backend.file.LinkedFilter;
import org.guvnor.common.services.backend.file.LinkedMetaInfFolderFilter;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class ScenarioLoader {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private ScenarioTestEditorService scenarioTestEditorService;

    public List<Scenario> loadScenarios(org.uberfire.backend.vfs.Path testResourcePath) {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        for (org.uberfire.backend.vfs.Path path : this.loadScenarioPaths(testResourcePath)) {
            scenarios.add((Scenario)this.scenarioTestEditorService.load(path));
        }
        return scenarios;
    }

    private List<org.uberfire.backend.vfs.Path> loadScenarioPaths(org.uberfire.backend.vfs.Path path) {
        ArrayList<org.uberfire.backend.vfs.Path> items = new ArrayList<org.uberfire.backend.vfs.Path>();
        if (!Files.exists((Path)Paths.convert((org.uberfire.backend.vfs.Path)path), (LinkOption[])new LinkOption[0])) {
            return items;
        }
        Path pPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (!Files.isDirectory((Path)pPath, (LinkOption[])new LinkOption[0])) {
            pPath = pPath.getParent();
        }
        LinkedDotFileFilter filter = new LinkedDotFileFilter();
        LinkedMetaInfFolderFilter metaInfFolderFilter = new LinkedMetaInfFolderFilter();
        filter.setNextFilter((LinkedFilter)metaInfFolderFilter);
        FileExtensionFilter fileExtensionFilter = new FileExtensionFilter(".scenario");
        DirectoryStream directoryStream = this.ioService.newDirectoryStream(pPath);
        for (Path p : directoryStream) {
            if (!filter.accept((Object)p) || !fileExtensionFilter.accept(p)) continue;
            if (Files.isRegularFile((Path)p, (LinkOption[])new LinkOption[0])) {
                items.add(Paths.convert((Path)p));
                continue;
            }
            if (!Files.isDirectory((Path)p, (LinkOption[])new LinkOption[0])) continue;
            items.add(Paths.convert((Path)p));
        }
        return items;
    }
}

