/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.Fixture;
import org.drools.workbench.models.testscenarios.shared.FixtureList;
import org.drools.workbench.models.testscenarios.shared.FixturesMap;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;

public class TestScenarioModelVisitor {
    private final PackageDataModelOracleBaselinePayload dmo;
    private final Scenario scenario;
    private HashSet<String> fqcNames = new HashSet();

    public TestScenarioModelVisitor(PackageDataModelOracleBaselinePayload dmo, Scenario scenario) {
        this.dmo = dmo;
        this.scenario = scenario;
    }

    public HashSet<String> visit() {
        this.visit(this.scenario.getFixtures());
        return this.fqcNames;
    }

    private void visit(List<Fixture> fixtures) {
        for (Fixture fixture : fixtures) {
            this.visit(fixture);
        }
    }

    private void visit(Fixture fixture) {
        if (fixture instanceof FixtureList) {
            for (Fixture child : (FixtureList)fixture) {
                this.visit(child);
            }
        } else if (fixture instanceof FixturesMap) {
            for (Fixture child : ((FixturesMap)fixture).values()) {
                this.visit(child);
            }
        } else if (fixture instanceof FactData) {
            this.convertToFullyQualifiedClassName(((FactData)fixture).getType());
        }
    }

    private void convertToFullyQualifiedClassName(String factType) {
        if (factType.contains(".")) {
            this.fqcNames.add(factType);
            return;
        }
        String fullyQualifiedClassName = null;
        for (Import imp : this.scenario.getImports().getImports()) {
            if (!imp.getType().endsWith(factType)) continue;
            fullyQualifiedClassName = imp.getType();
            break;
        }
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.scenario.getPackageName() + "." + factType;
        }
        this.fqcNames.add(fullyQualifiedClassName);
    }
}

