/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server.indexing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.testscenarios.shared.FactData;
import org.drools.workbench.models.testscenarios.shared.Field;
import org.drools.workbench.models.testscenarios.shared.Fixture;
import org.drools.workbench.models.testscenarios.shared.FixtureList;
import org.drools.workbench.models.testscenarios.shared.FixturesMap;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.models.testscenarios.shared.VerifyFact;
import org.drools.workbench.models.testscenarios.shared.VerifyField;
import org.drools.workbench.models.testscenarios.shared.VerifyRuleFired;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.Rule;
import org.kie.workbench.common.services.refactoring.model.index.Type;
import org.kie.workbench.common.services.refactoring.model.index.TypeField;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueFieldIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueRuleIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueTypeIndexTerm;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.validation.PortablePreconditions;

public class TestScenarioIndexVisitor {
    private final ProjectDataModelOracle dmo;
    private final DefaultIndexBuilder builder;
    private final Scenario model;
    private final Map<String, String> factDataToFullyQualifiedClassNameMap = new HashMap<String, String>();

    public TestScenarioIndexVisitor(ProjectDataModelOracle dmo, DefaultIndexBuilder builder, Scenario model) {
        this.dmo = (ProjectDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.model = (Scenario)PortablePreconditions.checkNotNull((String)"model", (Object)model);
    }

    public Set<Pair<String, String>> visit() {
        this.visit(this.model);
        return this.builder.build();
    }

    private void visit(Scenario scenario) {
        this.visit(scenario.getGlobals());
        this.visit(scenario.getFixtures());
    }

    private void visit(List<? extends Fixture> fixtures) {
        for (Fixture fixture : fixtures) {
            this.visit(fixture);
        }
    }

    private void visit(Fixture fixture) {
        if (fixture instanceof FixtureList) {
            for (Fixture child : (FixtureList)fixture) {
                this.visit(child);
            }
        } else if (fixture instanceof FixturesMap) {
            for (Fixture child : ((FixturesMap)fixture).values()) {
                this.visit(child);
            }
        } else if (fixture instanceof FactData) {
            FactData factData = (FactData)fixture;
            String typeName = factData.getType();
            String fullyQualifiedClassName = this.getFullyQualifiedClassName(typeName);
            this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(fullyQualifiedClassName)));
            this.factDataToFullyQualifiedClassNameMap.put(factData.getName(), fullyQualifiedClassName);
            for (Field field : factData.getFieldData()) {
                String fieldName = field.getName();
                String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
                this.builder.addGenerator((IndexElementsGenerator)new TypeField(new ValueFieldIndexTerm(fieldName), new ValueTypeIndexTerm(fieldFullyQualifiedClassName), new ValueTypeIndexTerm(fullyQualifiedClassName)));
            }
        } else if (fixture instanceof VerifyFact) {
            VerifyFact verifyFact = (VerifyFact)fixture;
            String typeName = verifyFact.getName();
            String fullyQualifiedClassName = null;
            fullyQualifiedClassName = !verifyFact.anonymous ? this.factDataToFullyQualifiedClassNameMap.get(verifyFact.getName()) : this.getFullyQualifiedClassName(typeName);
            if (fullyQualifiedClassName != null) {
                this.builder.addGenerator((IndexElementsGenerator)new Type(new ValueTypeIndexTerm(fullyQualifiedClassName)));
            }
            for (VerifyField field : verifyFact.getFieldValues()) {
                String fieldName = field.getFieldName();
                String fieldFullyQualifiedClassName = this.getFieldFullyQualifiedClassName(fullyQualifiedClassName, fieldName);
                this.builder.addGenerator((IndexElementsGenerator)new TypeField(new ValueFieldIndexTerm(fieldName), new ValueTypeIndexTerm(fieldFullyQualifiedClassName), new ValueTypeIndexTerm(fullyQualifiedClassName)));
            }
        } else if (fixture instanceof VerifyRuleFired) {
            VerifyRuleFired verifyRuleFired = (VerifyRuleFired)fixture;
            this.builder.addGenerator((IndexElementsGenerator)new Rule(new ValueRuleIndexTerm(verifyRuleFired.getRuleName())));
        }
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (Import i : this.model.getImports().getImports()) {
            if (!i.getType().endsWith(typeName)) continue;
            return i.getType();
        }
        String packageName = this.model.getPackageName();
        return packageName != null && !packageName.isEmpty() ? packageName + "." + typeName : typeName;
    }

    private String getFieldFullyQualifiedClassName(String fullyQualifiedClassName, String fieldName) {
        ModelField[] mfs;
        for (ModelField mf : mfs = (ModelField[])this.dmo.getProjectModelFields().get(fullyQualifiedClassName)) {
            if (!mf.getName().equals(fieldName)) continue;
            return mf.getClassName();
        }
        return "Object";
    }
}

