/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.HashSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.datamodel.oracle.PackageDataModelOracle;
import org.drools.workbench.models.testscenarios.backend.util.ScenarioXMLPersistence;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioRunnerService;
import org.drools.workbench.screens.testscenario.backend.server.TestScenarioModelVisitor;
import org.drools.workbench.screens.testscenario.model.TestScenarioModelContent;
import org.drools.workbench.screens.testscenario.model.TestScenarioResult;
import org.drools.workbench.screens.testscenario.service.ScenarioTestEditorService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class ScenarioTestEditorServiceImpl
extends KieService<TestScenarioModelContent>
implements ScenarioTestEditorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private ScenarioRunnerService scenarioRunner;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;
    private SafeSessionInfo safeSessionInfo;

    public ScenarioTestEditorServiceImpl() {
    }

    @Inject
    public ScenarioTestEditorServiceImpl(SessionInfo sessionInfo) {
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, Scenario content, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, ScenarioXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Scenario load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            Scenario scenario = ScenarioXMLPersistence.getInstance().unmarshal(content);
            scenario.setName(path.getFileName());
            return scenario;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, Scenario content, Metadata metadata, String comment) {
        try {
            Metadata currentMetadata = this.metadataService.getMetadata(resource);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), ScenarioXMLPersistence.getInstance().marshal(content), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.fireMetadataSocialEvents(resource, currentMetadata, metadata);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public TestScenarioModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (TestScenarioModelContent)super.loadContent(path);
    }

    protected TestScenarioModelContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        Scenario scenario = this.load(path);
        String packageName = this.projectService.resolvePackage(path).getPackageName();
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
        PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
        TestScenarioModelVisitor visitor = new TestScenarioModelVisitor(dataModel, scenario);
        HashSet<String> consumedFQCNs = visitor.visit();
        consumedFQCNs.addAll(oracle.getPackageGlobals().values());
        DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, consumedFQCNs);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new TestScenarioModelContent(scenario, overview, packageName, dataModel);
    }

    public TestScenarioResult runScenario(org.uberfire.backend.vfs.Path path, Scenario scenario) {
        try {
            return this.scenarioRunner.run(scenario, (KieProject)this.projectService.resolveProject(path));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

