/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.cache.util.maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.drools.workbench.services.verifier.api.client.cache.util.HasUUID;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.InspectorFactory;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;

public class UpdatableInspectorList<InspectorType extends HasUUID, InspectedType extends HasUUID>
extends InspectorList<InspectorType> {
    private InspectorFactory<InspectorType, InspectedType> inspectorFactory;
    private HashMap<UUIDKey, InspectorType> map = new HashMap();

    public UpdatableInspectorList(InspectorFactory<InspectorType, InspectedType> inspectorFactory, AnalyzerConfiguration configuration) {
        super(configuration);
        this.inspectorFactory = inspectorFactory;
    }

    public void update(Collection<InspectedType> updates) {
        ArrayList<UUIDKey> originalItems = new ArrayList<UUIDKey>(this.map.keySet());
        for (HasUUID updatable : updates) {
            HasUUID inspector = (HasUUID)this.map.get(updatable.getUuidKey());
            if (inspector != null) {
                originalItems.remove(updatable.getUuidKey());
                continue;
            }
            HasUUID newInspector = (HasUUID)this.inspectorFactory.make(updatable);
            this.add(newInspector);
            this.map.put(updatable.getUuidKey(), newInspector);
        }
        for (UUIDKey originalItem : originalItems) {
            this.remove(this.map.remove(originalItem));
        }
    }
}

