/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.checks.base.SingleCheck;
import org.drools.workbench.services.verifier.api.client.checks.util.Conflict;
import org.drools.workbench.services.verifier.api.client.checks.util.HumanReadable;
import org.drools.workbench.services.verifier.api.client.reporting.Explanation;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.resources.i18n.AnalysisConstants;

public class DetectMultipleValuesForOneActionCheck
extends SingleCheck {
    private Conflict conflict = Conflict.EMPTY;

    public DetectMultipleValuesForOneActionCheck(RuleInspector ruleInspector) {
        super(ruleInspector);
    }

    @Override
    public void check() {
        this.conflict = Conflict.EMPTY;
        for (PatternInspector patternInspector : this.ruleInspector.getPatternsInspector()) {
            Conflict result = patternInspector.getActionsInspector().hasConflicts();
            if (!result.foundIssue()) continue;
            this.hasIssues = true;
            this.conflict = result;
            return;
        }
        this.hasIssues = false;
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, AnalysisConstants.INSTANCE.MultipleValuesForOneAction(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                return new Explanation().startNote().addParagraph(AnalysisConstants.INSTANCE.MultipleValuesNote1P1(HumanReadable.toHumanReadableString(DetectMultipleValuesForOneActionCheck.this.conflict.getConflictedItem()), HumanReadable.toHumanReadableString(DetectMultipleValuesForOneActionCheck.this.conflict.getConflictingItem()))).end().addParagraph(AnalysisConstants.INSTANCE.MultipleValuesP1()).toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }
}

