/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks.base;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.CancellableRepeatingCommand;
import org.drools.workbench.services.verifier.api.client.ParameterizedCommand;
import org.drools.workbench.services.verifier.api.client.Status;
import org.drools.workbench.services.verifier.api.client.UpdateHandler;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.checks.base.Check;
import org.drools.workbench.services.verifier.api.client.checks.base.ChecksRepeatingCommand;

public class CheckRunner
implements UpdateHandler {
    protected final Set<Check> rechecks = new HashSet<Check>();
    private CancellableRepeatingCommand activeAnalysis;

    public void run(ParameterizedCommand<Status> onStatus, Command onCompletion) {
        this.cancelExistingAnalysis();
        if (this.rechecks.isEmpty() && onCompletion != null) {
            onCompletion.execute();
            return;
        }
        this.doRun(new ChecksRepeatingCommand(this.rechecks, onStatus, onCompletion));
        this.rechecks.clear();
    }

    protected void doRun(CancellableRepeatingCommand command) {
        this.activeAnalysis = command;
        Scheduler.get().scheduleIncremental((Scheduler.RepeatingCommand)this.activeAnalysis);
    }

    @Override
    public void addChecks(Set<Check> checks) {
        this.cancelExistingAnalysis();
        this.rechecks.addAll(checks);
    }

    public boolean isEmpty() {
        return this.rechecks.isEmpty();
    }

    public void remove(RuleInspector removedRuleInspector) {
        this.cancelExistingAnalysis();
        Set<Check> checks = removedRuleInspector.clearChecks();
        this.rechecks.removeAll(checks);
    }

    public void cancelExistingAnalysis() {
        if (this.activeAnalysis != null) {
            this.activeAnalysis.cancel();
            this.activeAnalysis = null;
        }
    }
}

