/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.cache.util.HasIndex;
import org.drools.workbench.services.verifier.api.client.checks.base.CheckManager;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Index;
import org.drools.workbench.services.verifier.api.client.index.Rule;

public abstract class RuleInspectorCache {
    private final Map<Rule, RuleInspector> ruleInspectors = new HashMap<Rule, RuleInspector>();
    private CheckManager checkManager;
    protected final Index index;
    private AnalyzerConfiguration configuration;

    public RuleInspectorCache(Index index, AnalyzerConfiguration configuration) {
        this.index = index;
        this.checkManager = new CheckManager(configuration);
        this.configuration = configuration;
    }

    public void reset() {
        this.ruleInspectors.clear();
        for (Rule rule : this.index.rules.where(Rule.uuid().any()).select().all()) {
            this.add(new RuleInspector(rule, this.checkManager, this, this.configuration));
        }
    }

    public Collection<RuleInspector> all() {
        return this.ruleInspectors.values();
    }

    public Collection<RuleInspector> all(Filter filter) {
        ArrayList<RuleInspector> result = new ArrayList<RuleInspector>();
        for (RuleInspector ruleInspector : this.all()) {
            if (!filter.accept(ruleInspector)) continue;
            result.add(ruleInspector);
        }
        return result;
    }

    private void add(RuleInspector ruleInspector) {
        this.ruleInspectors.put(ruleInspector.getRule(), ruleInspector);
    }

    public RuleInspector removeRow(int rowNumber) {
        Rule rule = this.getRule(rowNumber);
        RuleInspector remove = this.ruleInspectors.remove(rule);
        this.index.rules.remove(rule);
        return remove;
    }

    protected Rule getRule(int rowNumber) {
        return (Rule)this.index.rules.where(HasIndex.index().is(Integer.valueOf(rowNumber))).select().first();
    }

    public RuleInspector addRow(int index) {
        Rule rule = this.makeRule(index);
        this.index.rules.add(rule);
        RuleInspector ruleInspector = new RuleInspector(rule, this.checkManager, this, this.configuration);
        this.add(ruleInspector);
        return ruleInspector;
    }

    protected abstract Rule makeRule(int var1);

    public RuleInspector getRuleInspector(int row) {
        return this.ruleInspectors.get(this.getRule(row));
    }

    public Collection<RuleInspector> allRuleInspectors() {
        return this.ruleInspectors.values();
    }

    public AnalyzerConfiguration getConfiguration() {
        return this.configuration;
    }

    public static interface Filter {
        public boolean accept(RuleInspector var1);
    }
}

