/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.cache.inspectors;

import org.drools.workbench.services.verifier.api.client.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.action.ActionsInspectorMultiMap;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.services.verifier.api.client.checks.util.HumanReadable;

public class RuleInspectorDumper {
    private StringBuilder dump = new StringBuilder();
    private RuleInspector ruleInspector;

    public RuleInspectorDumper(RuleInspector ruleInspector) {
        this.ruleInspector = ruleInspector;
    }

    public String dump() {
        this.dump.append("Rule: ");
        this.dump.append(this.ruleInspector.getRowIndex());
        this.dump.append("\n");
        this.dump.append("\n");
        this.dumpPatterns();
        this.dumpConditions();
        this.dumpActions();
        return this.dump.toString();
    }

    private void dumpPatterns() {
        this.dump.append("Patterns{\n");
        for (PatternInspector patternInspector : this.ruleInspector.getPatternsInspector()) {
            this.dump.append("Pattern{\n");
            this.dump.append(patternInspector.getPattern().getName());
            this.dump.append("\n");
            this.dump.append("Conditions{\n");
            this.dumpCondition(patternInspector.getConditionsInspector());
            this.dump.append("}\n");
            this.dump.append("Actions{\n");
            this.dumpAction(patternInspector.getActionsInspector());
            this.dump.append("}\n");
        }
        this.dump.append("}\n");
    }

    private void dumpConditions() {
        this.dump.append("Conditions{\n");
        for (ConditionsInspectorMultiMap conditionsInspectorMultiMap : this.ruleInspector.getConditionsInspectors()) {
            this.dumpCondition(conditionsInspectorMultiMap);
        }
        this.dump.append("}\n");
    }

    private void dumpActions() {
        this.dump.append("Actions{\n");
        for (ActionsInspectorMultiMap actionsInspectorMultiMap : this.ruleInspector.getActionsInspectors()) {
            this.dumpAction(actionsInspectorMultiMap);
        }
        this.dump.append("}\n");
    }

    private void dumpAction(ActionsInspectorMultiMap actionsInspectorMultiMap) {
        for (Object object : actionsInspectorMultiMap.allValues()) {
            this.dump.append("Action{\n");
            if (object instanceof HumanReadable) {
                this.dump.append(((HumanReadable)object).toHumanReadableString());
            } else {
                this.dump.append(object.toString());
            }
            this.dump.append("}\n");
        }
    }

    private void dumpCondition(ConditionsInspectorMultiMap conditionsInspectorMultiMap) {
        for (ConditionInspector conditionInspector : conditionsInspectorMultiMap.allValues()) {
            this.dump.append("Condition{\n");
            this.dump.append(conditionInspector.toHumanReadableString());
            this.dump.append("}\n");
        }
    }
}

