/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.cache.util.maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.MultiMap;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.MultiMapChangeHandler;

class ChangeHandledMultiMap<V extends Comparable, T, ListType extends List<T>>
implements MultiMap<V, T, ListType> {
    private final MultiMap<V, T, ListType> map;
    private List<MultiMapChangeHandler<V, T>> changeHandlers = new ArrayList<MultiMapChangeHandler<V, T>>();
    private MultiMapChangeHandler.ChangeSet<V, T> changeSet = new MultiMapChangeHandler.ChangeSet();
    private int counter = 0;

    public ChangeHandledMultiMap(MultiMap<V, T, ListType> map) {
        this.map = map;
    }

    @Override
    public boolean put(V value, T t) {
        this.addToCounter();
        boolean put = this.map.put(value, t);
        this.addToChangeSet(value, t);
        this.fire();
        return put;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<V> keySet() {
        return this.map.keySet();
    }

    @Override
    public ListType get(V key) {
        return this.map.get(key);
    }

    @Override
    public boolean addAllValues(V value, Collection<T> ts) {
        this.addToCounter();
        boolean b = this.map.addAllValues(value, ts);
        for (T t : ts) {
            this.addToChangeSet(value, t);
        }
        this.fire();
        return b;
    }

    @Override
    public Collection<T> remove(V value) {
        this.addToCounter();
        for (Object t : this.get(value)) {
            this.addRemovedToChangeSet(value, t);
        }
        Collection<T> remove = this.map.remove(value);
        this.fire();
        return remove;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void addChangeListener(MultiMapChangeHandler<V, T> changeHandler) {
        this.changeHandlers.add(changeHandler);
    }

    @Override
    public Collection<T> allValues() {
        return this.map.allValues();
    }

    void addToCounter() {
        ++this.counter;
    }

    protected void fire() {
        if (this.counter == 1) {
            for (MultiMapChangeHandler<V, T> changeHandler : this.changeHandlers) {
                changeHandler.onChange(this.changeSet);
            }
            this.changeSet = new MultiMapChangeHandler.ChangeSet();
        }
        --this.counter;
    }

    private void addToChangeSet(V value, T t) {
        if (!this.changeHandlers.isEmpty()) {
            this.changeSet.added.put(value, t);
        }
    }

    private void addRemovedToChangeSet(V value, T t) {
        if (!this.changeHandlers.isEmpty()) {
            this.changeSet.removed.put(value, t);
        }
    }

    @Override
    public void move(Set<V> oldKeys, Set<V> newKeys, T t) {
        this.addToCounter();
        for (Comparable oldKey : oldKeys) {
            this.removeValue((V)oldKey, t);
        }
        for (Comparable newKey : newKeys) {
            this.put((V)newKey, t);
        }
        this.fire();
    }

    @Override
    public boolean containsKey(V key) {
        return this.map.containsKey(key);
    }

    @Override
    public V firstKey() {
        return this.map.firstKey();
    }

    @Override
    public V lastKey() {
        return this.map.lastKey();
    }

    @Override
    public MultiMap<V, T, ListType> subMap(V fromKey, boolean fromInclusive, V toKey, boolean toInclusive) {
        return this.map.subMap(fromKey, fromInclusive, toKey, toInclusive);
    }

    @Override
    public void removeValue(V value, T t) {
        this.addToCounter();
        this.map.removeValue(value, t);
        this.addRemovedToChangeSet(value, t);
        this.fire();
    }

    @Override
    public void clear() {
        this.addToCounter();
        for (Comparable value : this.map.keySet()) {
            for (Object t : this.map.get(value)) {
                this.addRemovedToChangeSet(value, t);
            }
        }
        this.map.clear();
        this.fire();
    }

    @Override
    public void putAllValues(V value, Collection<T> ts) {
        this.addToCounter();
        for (T t : ts) {
            this.addToChangeSet(value, t);
        }
        this.map.putAllValues(value, ts);
        this.fire();
    }
}

