/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.services.verifier.api.client.checks.base.SingleCheck;
import org.drools.workbench.services.verifier.api.client.checks.util.Conflict;
import org.drools.workbench.services.verifier.api.client.checks.util.HumanReadable;
import org.drools.workbench.services.verifier.api.client.index.Field;
import org.drools.workbench.services.verifier.api.client.reporting.Explanation;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.resources.i18n.AnalysisConstants;

public class DetectImpossibleMatchCheck
extends SingleCheck {
    private Conflict conflict = Conflict.EMPTY;

    public DetectImpossibleMatchCheck(RuleInspector ruleInspector) {
        super(ruleInspector);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        this.conflict = Conflict.EMPTY;
        for (PatternInspector patternInspector : this.ruleInspector.getPatternsInspector()) {
            ConditionsInspectorMultiMap conditionsInspector = patternInspector.getConditionsInspector();
            Conflict conflict = conditionsInspector.hasConflicts();
            if (!conflict.foundIssue()) continue;
            this.hasIssues = true;
            this.conflict = conflict;
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.ERROR, AnalysisConstants.INSTANCE.ImpossibleMatch(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                String fieldName = "";
                String fieldFactType = "";
                if (((Conflict)DetectImpossibleMatchCheck.this.conflict.getOrigin()).getConflictedItem() instanceof ComparableConditionInspector) {
                    Field field = ((ComparableConditionInspector)((Conflict)DetectImpossibleMatchCheck.this.conflict.getOrigin()).getConflictedItem()).getField();
                    fieldName = field.getName();
                    fieldFactType = field.getFactType();
                }
                return new Explanation().startNote().addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchNote1P1(DetectImpossibleMatchCheck.this.ruleInspector.getRowIndex() + 1, fieldName, fieldFactType)).addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchNote1P2(HumanReadable.toHumanReadableString(((Conflict)DetectImpossibleMatchCheck.this.conflict.getOrigin()).getConflictedItem()), HumanReadable.toHumanReadableString(((Conflict)DetectImpossibleMatchCheck.this.conflict.getOrigin()).getConflictingItem()))).end().addParagraph(AnalysisConstants.INSTANCE.ImpossibleMatchP1(fieldName)).toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }
}

