/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import java.util.Iterator;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.action.ActionInspector;
import org.drools.workbench.services.verifier.api.client.cache.util.RedundancyResult;
import org.drools.workbench.services.verifier.api.client.checks.base.SingleCheck;
import org.drools.workbench.services.verifier.api.client.index.ObjectField;
import org.drools.workbench.services.verifier.api.client.reporting.Explanation;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.resources.i18n.AnalysisConstants;

public class DetectRedundantActionCheck
extends SingleCheck {
    private PatternInspector patternInspector;
    private RedundancyResult<ObjectField, ActionInspector> result;

    public DetectRedundantActionCheck(RuleInspector ruleInspector) {
        super(ruleInspector);
    }

    @Override
    public void check() {
        Iterator iterator = this.ruleInspector.getPatternsInspector().iterator();
        while (iterator.hasNext()) {
            PatternInspector patternInspector;
            this.patternInspector = patternInspector = (PatternInspector)iterator.next();
            this.result = patternInspector.getActionsInspector().hasRedundancy();
            if (!this.result.isTrue()) continue;
            this.hasIssues = true;
            return;
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.WARNING, this.getMessage(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                return new Explanation().addParagraph(AnalysisConstants.INSTANCE.RedundantActionsP1()).startNote().addParagraph(AnalysisConstants.INSTANCE.RedundantActionsNote1P1(((ActionInspector)DetectRedundantActionCheck.this.result.get(0)).toHumanReadableString(), ((ActionInspector)DetectRedundantActionCheck.this.result.get(1)).toHumanReadableString())).end().toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }

    private String getMessage() {
        if (this.patternInspector.getPattern().getBoundName() != null) {
            return AnalysisConstants.INSTANCE.ValueForFactFieldIsSetTwice(this.patternInspector.getPattern().getBoundName(), this.result.getParent().getName());
        }
        return AnalysisConstants.INSTANCE.ValueForAnActionIsSetTwice();
    }
}

