/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.PatternInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.services.verifier.api.client.cache.util.RedundancyResult;
import org.drools.workbench.services.verifier.api.client.checks.base.SingleCheck;
import org.drools.workbench.services.verifier.api.client.index.ObjectField;
import org.drools.workbench.services.verifier.api.client.reporting.Explanation;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.resources.i18n.AnalysisConstants;

public class DetectRedundantConditionsCheck
extends SingleCheck {
    private RedundancyResult<ObjectField, ConditionInspector> result;

    public DetectRedundantConditionsCheck(RuleInspector ruleInspector) {
        super(ruleInspector);
    }

    @Override
    public void check() {
        this.hasIssues = false;
        for (PatternInspector patternInspector : this.ruleInspector.getPatternsInspector()) {
            this.result = patternInspector.getConditionsInspector().hasRedundancy();
            if (!this.result.isTrue()) continue;
            this.hasIssues = true;
            return;
        }
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.NOTE, AnalysisConstants.INSTANCE.RedundantConditionsTitle(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                return new Explanation().startNote().addParagraph(AnalysisConstants.INSTANCE.RedundantConditionsNote1P1(((ObjectField)DetectRedundantConditionsCheck.this.result.getParent()).getFactType(), ((ObjectField)DetectRedundantConditionsCheck.this.result.getParent()).getName())).addParagraph(AnalysisConstants.INSTANCE.RedundantConditionsNote1P2(((ConditionInspector)DetectRedundantConditionsCheck.this.result.get(0)).toHumanReadableString(), ((ConditionInspector)DetectRedundantConditionsCheck.this.result.get(1)).toHumanReadableString())).end().addParagraph(AnalysisConstants.INSTANCE.RedundantConditionsP1()).toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }
}

