/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks;

import com.google.gwt.safehtml.shared.SafeHtml;
import org.drools.workbench.services.verifier.api.client.cache.RuleInspectorCache;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.BooleanConditionInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ConditionInspector;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.ConditionsInspectorMultiMap;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.LeafInspectorList;
import org.drools.workbench.services.verifier.api.client.checks.base.CheckManager;
import org.drools.workbench.services.verifier.api.client.checks.base.OneToManyCheck;
import org.drools.workbench.services.verifier.api.client.checks.util.SubsumptionResolver;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.DataType;
import org.drools.workbench.services.verifier.api.client.index.FieldCondition;
import org.drools.workbench.services.verifier.api.client.index.ObjectField;
import org.drools.workbench.services.verifier.api.client.index.Rule;
import org.drools.workbench.services.verifier.api.client.reporting.Explanation;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;
import org.drools.workbench.services.verifier.api.client.resources.i18n.AnalysisConstants;

public class RangeCheck
extends OneToManyCheck {
    private InspectorList<RuleInspector> otherRows;

    public RangeCheck(final RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, new RuleInspectorCache.Filter(){

            @Override
            public boolean accept(RuleInspector other) {
                return !ruleInspector.getRule().getUuidKey().equals(other.getRule().getUuidKey());
            }
        }, configuration);
    }

    @Override
    public void check() {
        this.otherRows = this.getOtherRows();
        if (this.otherRows.size() == 0) {
            this.hasIssues = false;
        } else {
            RuleInspectorClone evilClone = this.makeClone();
            this.hasIssues = evilClone.containsInvertedItems && !this.isSubsumedByOtherRows(evilClone);
        }
    }

    private boolean isSubsumedByOtherRows(RuleInspectorClone evilClone) {
        if (this.otherRows.isEmpty()) {
            return true;
        }
        return !SubsumptionResolver.isSubsumedByAnObjectInThisList(this.otherRows, evilClone).foundIssue();
    }

    private FieldCondition invert(FieldCondition condition, AnalyzerConfiguration configuration) {
        return new FieldCondition<Comparable>(condition.getField(), condition.getColumn(), this.invert(condition.getOperator()), condition.getValues(), configuration);
    }

    private String invert(String operator) {
        switch (operator) {
            case "==": {
                return "!=";
            }
            case "!=": {
                return "==";
            }
            case ">": {
                return "<=";
            }
            case "<": {
                return ">=";
            }
            case ">=": {
                return "<";
            }
            case "<=": {
                return ">";
            }
        }
        return operator;
    }

    private RuleInspectorClone makeClone() {
        return new RuleInspectorClone(this.ruleInspector.getRule(), this.ruleInspector.getCache());
    }

    @Override
    public Issue getIssue() {
        Issue issue = new Issue(Severity.NOTE, AnalysisConstants.INSTANCE.MissingRangeTitle(), new ExplanationProvider(){

            @Override
            public SafeHtml toHTML() {
                return new Explanation().addParagraph(AnalysisConstants.INSTANCE.MissingRangeP1(RangeCheck.this.ruleInspector.getRowIndex() + 1)).toHTML();
            }
        }, this.ruleInspector);
        return issue;
    }

    private class RuleInspectorClone
    extends RuleInspector {
        private final InspectorList<ConditionsInspectorMultiMap> conditionsInspectors;
        boolean containsInvertedItems;

        public RuleInspectorClone(Rule rule, RuleInspectorCache cache) {
            super(rule, new CheckManager(cache.getConfiguration()), cache, cache.getConfiguration());
            this.containsInvertedItems = false;
            this.conditionsInspectors = new InspectorList(cache.getConfiguration());
            this.makeConditionsInspectors();
        }

        @Override
        public InspectorList<ConditionsInspectorMultiMap> getConditionsInspectors() {
            return this.conditionsInspectors;
        }

        private void makeConditionsInspectors() {
            this.conditionsInspectors.clear();
            for (ConditionsInspectorMultiMap original : super.getConditionsInspectors()) {
                ConditionsInspectorMultiMap clone = new ConditionsInspectorMultiMap(this.getCache().getConfiguration());
                for (ObjectField field : original.keySet()) {
                    LeafInspectorList originalConditionInspectors = original.get(field);
                    if (originalConditionInspectors.isEmpty()) {
                        clone.putAllValues(field, originalConditionInspectors);
                        continue;
                    }
                    for (ConditionInspector originalInspector : originalConditionInspectors) {
                        clone.put(field, this.resolveInspector(originalInspector));
                    }
                }
                this.conditionsInspectors.add(clone);
            }
        }

        private ConditionInspector resolveInspector(ConditionInspector originalInspector) {
            if (originalInspector.getCondition() instanceof FieldCondition) {
                FieldCondition fieldCondition = (FieldCondition)originalInspector.getCondition();
                if (fieldCondition.getField().getFieldType().equals("Integer")) {
                    this.containsInvertedItems = true;
                    return new NumericIntegerConditionInspector((FieldCondition<Integer>)RangeCheck.this.invert(fieldCondition, this.getCache().getConfiguration()), this.getCache().getConfiguration());
                }
                if (DataType.isNumeric(fieldCondition.getField().getFieldType())) {
                    this.containsInvertedItems = true;
                    return new ComparableConditionInspector(RangeCheck.this.invert(fieldCondition, this.getCache().getConfiguration()), this.getCache().getConfiguration());
                }
                if (fieldCondition.getField().getFieldType().equals("Boolean")) {
                    this.containsInvertedItems = true;
                    return new BooleanConditionInspector((FieldCondition<Boolean>)RangeCheck.this.invert(fieldCondition, this.getCache().getConfiguration()), this.getCache().getConfiguration());
                }
            }
            return originalInspector;
        }

        @Override
        public boolean subsumes(Object other) {
            return other instanceof RuleInspector && this.getBrlConditionsInspectors().subsumes(((RuleInspector)other).getBrlConditionsInspectors()) && this.getConditionsInspectors().subsumes(((RuleInspector)other).getConditionsInspectors());
        }
    }
}

