/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks.base;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.MultiSet;
import org.drools.workbench.services.verifier.api.client.checks.DetectDeficientRowsCheck;
import org.drools.workbench.services.verifier.api.client.checks.DetectImpossibleMatchCheck;
import org.drools.workbench.services.verifier.api.client.checks.DetectMissingActionCheck;
import org.drools.workbench.services.verifier.api.client.checks.DetectMissingConditionCheck;
import org.drools.workbench.services.verifier.api.client.checks.DetectMultipleValuesForOneActionCheck;
import org.drools.workbench.services.verifier.api.client.checks.DetectRedundantActionCheck;
import org.drools.workbench.services.verifier.api.client.checks.DetectRedundantConditionsCheck;
import org.drools.workbench.services.verifier.api.client.checks.RangeCheck;
import org.drools.workbench.services.verifier.api.client.checks.base.Check;
import org.drools.workbench.services.verifier.api.client.checks.base.OneToManyCheck;
import org.drools.workbench.services.verifier.api.client.checks.base.PairCheck;
import org.drools.workbench.services.verifier.api.client.checks.base.PairChecks;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;

public class CheckManager {
    private final PairChecks pairChecks = new PairChecks();
    private final MultiSet<RuleInspector, Check> ruleInspectorChecks = new MultiSet();
    private final MultiSet<RuleInspector, OneToManyCheck> oneToManyChecks = new MultiSet();
    private AnalyzerConfiguration configuration;

    public CheckManager(AnalyzerConfiguration configuration) {
        this.configuration = configuration;
    }

    public Set<Check> makeSingleRowChecks(RuleInspector ruleInspector) {
        HashSet<Check> checks = this.makeSingleChecks(ruleInspector);
        for (Check check : checks) {
            if (!(check instanceof OneToManyCheck)) continue;
            this.oneToManyChecks.put(ruleInspector, (OneToManyCheck)check);
        }
        this.ruleInspectorChecks.addAllValues(ruleInspector, checks);
        return checks;
    }

    protected HashSet<Check> makeSingleChecks(RuleInspector ruleInspector) {
        HashSet<Check> checkList = new HashSet<Check>();
        checkList.add(new DetectImpossibleMatchCheck(ruleInspector));
        checkList.add(new DetectMultipleValuesForOneActionCheck(ruleInspector));
        checkList.add(new DetectMissingActionCheck(ruleInspector));
        checkList.add(new DetectMissingConditionCheck(ruleInspector));
        checkList.add(new DetectDeficientRowsCheck(ruleInspector, this.configuration));
        checkList.add(new RangeCheck(ruleInspector, this.configuration));
        checkList.add(new DetectRedundantActionCheck(ruleInspector));
        checkList.add(new DetectRedundantConditionsCheck(ruleInspector));
        return checkList;
    }

    public HashSet<Check> makePairRowChecks(RuleInspector ruleInspector, Collection<RuleInspector> all) {
        HashSet<Check> checks = new HashSet<Check>();
        for (RuleInspector other : all) {
            if (ruleInspector.equals(other)) continue;
            checks.add(this.makePairRowCheck(ruleInspector, other));
        }
        return checks;
    }

    private Check makePairRowCheck(RuleInspector ruleInspector, RuleInspector other) {
        PairCheck pairCheck = new PairCheck(ruleInspector, other);
        this.pairChecks.add(pairCheck);
        return pairCheck;
    }

    public Set<Check> getChecks(RuleInspector ruleInspector) {
        HashSet<Check> result = new HashSet<Check>();
        Collection<Check> ruleInspectorChecks = this.getRuleInspectorChecks(ruleInspector);
        result.addAll(ruleInspectorChecks);
        Collection<PairCheck> referencingChecks = this.getReferencingChecks(ruleInspector);
        result.addAll(referencingChecks);
        List<OneToManyCheck> c = this.oneToManyChecks.allValues();
        result.addAll(c);
        return result;
    }

    private Collection<PairCheck> getReferencingChecks(RuleInspector ruleInspector) {
        Collection<PairCheck> checks = this.pairChecks.get(ruleInspector);
        if (checks == null) {
            return Collections.EMPTY_LIST;
        }
        return checks;
    }

    private Collection<Check> getRuleInspectorChecks(RuleInspector ruleInspector) {
        Collection<Check> checks = this.ruleInspectorChecks.get(ruleInspector);
        if (checks == null) {
            return Collections.EMPTY_LIST;
        }
        return checks;
    }

    public Set<Check> remove(RuleInspector ruleInspector) {
        HashSet<Check> result = new HashSet<Check>();
        result.addAll(this.removeRuleInspectorChecks(ruleInspector));
        result.addAll(this.pairChecks.remove(ruleInspector));
        result.addAll(this.removeOneToMany(ruleInspector));
        return result;
    }

    private Collection<Check> removeRuleInspectorChecks(RuleInspector ruleInspector) {
        Collection<Check> remove = this.ruleInspectorChecks.remove(ruleInspector);
        if (remove == null) {
            return Collections.EMPTY_LIST;
        }
        return remove;
    }

    private Collection<OneToManyCheck> removeOneToMany(RuleInspector ruleInspector) {
        Collection<OneToManyCheck> remove = this.oneToManyChecks.remove(ruleInspector);
        if (remove == null) {
            return Collections.EMPTY_LIST;
        }
        return remove;
    }

    public void makeChecks(RuleInspector ruleInspector) {
        this.makeSingleRowChecks(ruleInspector);
        Set<RuleInspector> knownRuleInspectors = this.ruleInspectorChecks.keys();
        this.makePairRowChecks(ruleInspector, knownRuleInspectors);
        for (RuleInspector other : knownRuleInspectors) {
            if (other.equals(ruleInspector)) continue;
            PairCheck pairCheck = new PairCheck(other, ruleInspector);
            this.pairChecks.add(pairCheck);
        }
    }
}

