/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.checks.util;

import org.drools.workbench.services.verifier.api.client.cache.util.HasUUID;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.checks.util.ConflictResolver;
import org.drools.workbench.services.verifier.api.client.checks.util.Relation;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.uberfire.commons.validation.PortablePreconditions;

public class Conflict
extends Relation<Conflict> {
    public static Conflict EMPTY = new Conflict();
    private final HasUUID conflictedItem;
    private final HasUUID conflictingItem;

    public Conflict(HasUUID conflictedItem, HasUUID conflictingItem) {
        super(null);
        this.conflictedItem = (HasUUID)PortablePreconditions.checkNotNull((String)"conflictedItem", (Object)conflictedItem);
        this.conflictingItem = (HasUUID)PortablePreconditions.checkNotNull((String)"conflictingItem", (Object)conflictingItem);
    }

    public Conflict(InspectorList conflictedItem, InspectorList conflictingItem, Conflict origin) {
        super((Relation)PortablePreconditions.checkNotNull((String)"origin", (Object)origin));
        this.conflictedItem = (HasUUID)PortablePreconditions.checkNotNull((String)"conflictedItem", (Object)conflictedItem);
        this.conflictingItem = (HasUUID)PortablePreconditions.checkNotNull((String)"conflictingItem", (Object)conflictingItem);
    }

    private Conflict() {
        super(null);
        this.conflictedItem = null;
        this.conflictingItem = null;
    }

    @Override
    public boolean foundIssue() {
        return this.conflictingItem != null;
    }

    public HasUUID getConflictedItem() {
        return this.conflictedItem;
    }

    public HasUUID getConflictingItem() {
        return this.conflictingItem;
    }

    @Override
    public UUIDKey otherUUID() {
        return this.conflictingItem.getUuidKey();
    }

    @Override
    public boolean doesRelationStillExist() {
        if (this.origin != null && this.stillContainsConflictedItem(((Conflict)this.getOrigin()).getConflictedItem()) && this.stillContainsConflictingItem(((Conflict)this.getOrigin()).getConflictingItem())) {
            return ConflictResolver.isConflicting(((Conflict)this.getOrigin()).getConflictedItem(), ((Conflict)this.getOrigin()).getConflictingItem()).foundIssue();
        }
        return false;
    }

    private boolean stillContainsConflictedItem(HasUUID item) {
        if (this.conflictedItem instanceof InspectorList) {
            return ((InspectorList)this.conflictedItem).contains(item);
        }
        if (this.parent != null) {
            return ((Conflict)this.parent).stillContainsConflictedItem(item);
        }
        return false;
    }

    private boolean stillContainsConflictingItem(HasUUID item) {
        if (this.conflictingItem instanceof InspectorList) {
            return ((InspectorList)this.conflictingItem).contains(item);
        }
        if (this.parent != null) {
            return ((Conflict)this.parent).stillContainsConflictingItem(item);
        }
        return false;
    }
}

