/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.index;

import java.util.Iterator;
import org.drools.workbench.services.verifier.api.client.cache.util.HasKeys;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.KeyDefinition;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Column;
import org.drools.workbench.services.verifier.api.client.index.ConditionSuperType;
import org.drools.workbench.services.verifier.api.client.index.Matchers;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.index.keys.UpdatableKey;
import org.drools.workbench.services.verifier.api.client.index.keys.Value;
import org.drools.workbench.services.verifier.api.client.index.keys.Values;
import org.drools.workbench.services.verifier.api.client.index.matchers.ComparableMatchers;
import org.drools.workbench.services.verifier.api.client.index.matchers.UUIDMatchers;
import org.uberfire.commons.validation.PortablePreconditions;

public abstract class Condition<T extends Comparable>
implements HasKeys {
    private static final KeyDefinition SUPER_TYPE = KeyDefinition.newKeyDefinition().withId("superType").updatable().build();
    private static final KeyDefinition COLUMN_UUID = KeyDefinition.newKeyDefinition().withId("columnUUID").build();
    private static final KeyDefinition VALUE = KeyDefinition.newKeyDefinition().withId("value").updatable().build();
    protected final UUIDKey uuidKey;
    protected final Column column;
    private final ConditionSuperType superType;
    private final Values<Comparable> values = new Values();
    private UpdatableKey<Condition<T>> valueKey;

    public Condition(Column column, ConditionSuperType superType, Values<T> values, AnalyzerConfiguration configuration) {
        this.column = (Column)PortablePreconditions.checkNotNull((String)"column", (Object)column);
        this.superType = (ConditionSuperType)((Object)PortablePreconditions.checkNotNull((String)"superType", (Object)((Object)superType)));
        this.uuidKey = configuration.getUUID(this);
        this.valueKey = new UpdatableKey(VALUE, (Values)PortablePreconditions.checkNotNull((String)"values", values));
        this.resetValues();
    }

    public static ComparableMatchers value() {
        return new ComparableMatchers(VALUE);
    }

    public static Matchers columnUUID() {
        return new Matchers(COLUMN_UUID);
    }

    public static Matchers superType() {
        return new Matchers(SUPER_TYPE);
    }

    public static Matchers uuid() {
        return new UUIDMatchers();
    }

    public static KeyDefinition[] keyDefinitions() {
        return new KeyDefinition[]{UUIDKey.UNIQUE_UUID, VALUE, SUPER_TYPE, COLUMN_UUID};
    }

    private void resetValues() {
        this.values.clear();
        for (Object e : this.valueKey.getValues()) {
            this.values.add(((Value)e).getComparable());
        }
    }

    public Column getColumn() {
        return this.column;
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    public T getFirstValue() {
        Iterator iterator = this.valueKey.getValues().iterator();
        if (iterator.hasNext()) {
            return (T)((Value)iterator.next()).getComparable();
        }
        return null;
    }

    public Values<Comparable> getValues() {
        return this.values;
    }

    public void setValue(Values<T> values) {
        if (!this.valueKey.getValues().isThereChanges(values)) {
            return;
        }
        UpdatableKey<Condition<Condition>> oldKey = this.valueKey;
        UpdatableKey newKey = new UpdatableKey(VALUE, values);
        this.valueKey = newKey;
        oldKey.update(newKey, this);
        this.resetValues();
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey, this.valueKey, new Key(SUPER_TYPE, (Comparable)((Object)this.superType)), new Key(COLUMN_UUID, this.column.getUuidKey())};
    }
}

