/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.index;

import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.KeyTreeMap;
import org.drools.workbench.services.verifier.api.client.cache.util.maps.MultiMap;
import org.drools.workbench.services.verifier.api.client.index.ObjectFields;
import org.drools.workbench.services.verifier.api.client.index.ObjectType;
import org.drools.workbench.services.verifier.api.client.index.Where;
import org.drools.workbench.services.verifier.api.client.index.matchers.Matcher;
import org.drools.workbench.services.verifier.api.client.index.select.Listen;
import org.drools.workbench.services.verifier.api.client.index.select.Select;

public class ObjectTypes {
    public final KeyTreeMap<ObjectType> typesMap = new KeyTreeMap(ObjectType.keyDefinitions());

    public ObjectTypes(Collection<ObjectType> typesMap) {
        for (ObjectType objectType : typesMap) {
            this.add(objectType);
        }
    }

    public ObjectTypes(ObjectType[] typesMap) {
        this(Arrays.asList(typesMap));
    }

    public ObjectTypes() {
    }

    public void merge(ObjectTypes patterns) {
        this.typesMap.merge(patterns.typesMap);
    }

    public Where<ObjectTypesSelect, ObjectTypesListen> where(final Matcher matcher) {
        return new Where<ObjectTypesSelect, ObjectTypesListen>(){

            @Override
            public ObjectTypesSelect select() {
                return new ObjectTypesSelect(matcher);
            }

            @Override
            public ObjectTypesListen listen() {
                return new ObjectTypesListen(matcher);
            }
        };
    }

    public void add(ObjectType ... objectTypes) {
        for (ObjectType objectType : objectTypes) {
            this.typesMap.put(objectType);
        }
    }

    public class ObjectTypesListen
    extends Listen<ObjectType> {
        public ObjectTypesListen(Matcher matcher) {
            super(ObjectTypes.this.typesMap.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class ObjectTypesSelect
    extends Select<ObjectType> {
        public ObjectTypesSelect(Matcher matcher) {
            super(ObjectTypes.this.typesMap.get(matcher.getKeyDefinition()), matcher);
        }

        public ObjectFields fields() {
            ObjectFields fields = new ObjectFields();
            MultiMap subMap = this.asMap();
            if (subMap != null) {
                Collection objectTypes = subMap.allValues();
                for (ObjectType objectType : objectTypes) {
                    fields.merge(objectType.getFields());
                }
            }
            return fields;
        }
    }
}

