/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.reporting;

import com.google.gwt.safehtml.shared.SafeHtml;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.cache.inspectors.RuleInspector;
import org.drools.workbench.services.verifier.api.client.reporting.ExplanationProvider;
import org.drools.workbench.services.verifier.api.client.reporting.Severity;

public class Issue {
    public static final Issue EMPTY = new Issue();
    private final Severity severity;
    private final HashSet<RuleInspector> ruleInspectors = new HashSet();
    private final String title;
    private final ExplanationProvider explanationProvider;

    public Issue(Severity severity, String title, ExplanationProvider explanationProvider, RuleInspector ... ruleInspectors) {
        this.severity = severity;
        this.title = title;
        this.explanationProvider = explanationProvider;
        this.ruleInspectors.addAll(Arrays.asList(ruleInspectors));
    }

    private Issue() {
        this.severity = null;
        this.explanationProvider = null;
        this.title = null;
    }

    public boolean hasIssue() {
        return this.title != null;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Set<Integer> getRowNumbers() {
        HashSet<Integer> rowNumbers = new HashSet<Integer>();
        for (RuleInspector ruleInspector : this.ruleInspectors) {
            rowNumbers.add(ruleInspector.getRowIndex() + 1);
        }
        return rowNumbers;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return this.title;
    }

    public SafeHtml getExplanationHTML() {
        return this.explanationProvider.toHTML();
    }
}

