/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.index.select;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.services.verifier.api.client.index.keys.Value;
import org.drools.workbench.services.verifier.api.client.index.matchers.Matcher;
import org.drools.workbench.services.verifier.api.client.index.select.AllListener;
import org.drools.workbench.services.verifier.api.client.index.select.ChangeHelper;
import org.drools.workbench.services.verifier.api.client.index.select.FirstListener;
import org.drools.workbench.services.verifier.api.client.index.select.LastListener;
import org.drools.workbench.services.verifier.api.client.index.select.Select;
import org.drools.workbench.services.verifier.api.client.maps.MultiMap;
import org.drools.workbench.services.verifier.api.client.maps.MultiMapChangeHandler;
import org.uberfire.commons.validation.PortablePreconditions;

public class Listen<T>
extends Select<T> {
    private final ArrayList<AllListener<T>> allListeners = new ArrayList();
    private final ArrayList<FirstListener<T>> firstListeners = new ArrayList();
    private final ArrayList<LastListener<T>> lastListeners = new ArrayList();
    private Select.Entry<T> first;
    private Select.Entry<T> last;
    private MultiMap<Value, T, List<T>> all;

    public Listen(MultiMap<Value, T, List<T>> map, final Matcher matcher) {
        super(map, matcher);
        PortablePreconditions.checkNotNull((String)"map", map);
        map.addChangeListener(new MultiMapChangeHandler<Value, T>(){

            @Override
            public void onChange(MultiMapChangeHandler.ChangeSet<Value, T> changeSet) {
                if (Listen.this.hasNoListeners()) {
                    return;
                }
                ChangeHelper changeHelper = new ChangeHelper(changeSet, matcher);
                if (!Listen.this.firstListeners.isEmpty() && (Listen.this.first == null || changeHelper.firstChanged(Listen.this.first))) {
                    Listen.this.first = Listen.this.firstEntry();
                    Listen.this.notifyFirstListeners();
                }
                if (!Listen.this.lastListeners.isEmpty() && (Listen.this.last == null || changeHelper.lastChanged(Listen.this.last))) {
                    Listen.this.last = Listen.this.lastEntry();
                    Listen.this.notifyLastListeners();
                }
                if (!Listen.this.allListeners.isEmpty()) {
                    Listen.this.all = Listen.this.asMap();
                    Listen.this.notifyAllListeners();
                }
            }
        });
    }

    private void notifyAllListeners() {
        for (AllListener<T> allListener : this.allListeners) {
            allListener.onAllChanged(this.all.allValues());
        }
    }

    private void notifyFirstListeners() {
        for (FirstListener<T> firstListener : this.firstListeners) {
            firstListener.onFirstChanged(this.first.getValue());
        }
    }

    private void notifyLastListeners() {
        for (LastListener<T> lastListener : this.lastListeners) {
            lastListener.onLastChanged(this.last.getValue());
        }
    }

    private boolean hasNoListeners() {
        return this.allListeners.isEmpty() && this.firstListeners.isEmpty() && this.lastListeners.isEmpty();
    }

    public void first(FirstListener<T> firstListener) {
        if (this.first == null) {
            this.first = this.firstEntry();
        }
        this.firstListeners.add(firstListener);
    }

    public void last(LastListener<T> lastListener) {
        if (this.last == null) {
            this.last = this.lastEntry();
        }
        this.lastListeners.add(lastListener);
    }

    public void all(AllListener<T> allListener) {
        if (this.all == null) {
            this.all = this.asMap();
        }
        this.allListeners.add(allListener);
    }
}

