/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.index;

import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Actions;
import org.drools.workbench.services.verifier.api.client.index.Conditions;
import org.drools.workbench.services.verifier.api.client.index.Matchers;
import org.drools.workbench.services.verifier.api.client.index.Patterns;
import org.drools.workbench.services.verifier.api.client.index.keys.IndexKey;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.index.keys.UpdatableKey;
import org.drools.workbench.services.verifier.api.client.index.matchers.ComparableMatchers;
import org.drools.workbench.services.verifier.api.client.index.matchers.UUIDMatchers;
import org.drools.workbench.services.verifier.api.client.maps.KeyDefinition;
import org.drools.workbench.services.verifier.api.client.maps.util.HasIndex;
import org.drools.workbench.services.verifier.api.client.maps.util.HasKeys;

public class Rule
implements Comparable<Rule>,
HasKeys,
HasIndex {
    private final Patterns patterns = new Patterns();
    private final Actions actions = new Actions();
    private final Conditions conditions = new Conditions();
    private final UUIDKey uuidKey;
    private UpdatableKey<Rule> indexKey;

    public Rule(Integer rowNumber, AnalyzerConfiguration configuration) {
        this.indexKey = new UpdatableKey(IndexKey.INDEX_ID, rowNumber);
        this.uuidKey = configuration.getUUID(this);
    }

    public static Matchers uuid() {
        return new UUIDMatchers();
    }

    public static ComparableMatchers index() {
        return new ComparableMatchers(IndexKey.INDEX_ID);
    }

    public static KeyDefinition[] keyDefinitions() {
        return new KeyDefinition[]{UUIDKey.UNIQUE_UUID, IndexKey.INDEX_ID};
    }

    public Integer getRowNumber() {
        return this.getIndex();
    }

    public Patterns getPatterns() {
        return this.patterns;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public Actions getActions() {
        return this.actions;
    }

    @Override
    public int compareTo(Rule rule) {
        return 0;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey, this.indexKey};
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public int getIndex() {
        return (Integer)this.indexKey.getSingleValueComparator();
    }

    @Override
    public void setIndex(int index) {
        if (this.indexKey.getSingleValue().equals(index)) {
            return;
        }
        UpdatableKey<Rule> oldKey = this.indexKey;
        UpdatableKey newKey = new UpdatableKey(IndexKey.INDEX_ID, Integer.valueOf(index));
        this.indexKey = newKey;
        oldKey.update(newKey, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return this.uuidKey.equals(rule.uuidKey);
    }

    public int hashCode() {
        return this.uuidKey.hashCode();
    }
}

