/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.maps;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.workbench.services.verifier.api.client.Callback;
import org.drools.workbench.services.verifier.api.client.index.keys.IndexKey;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.index.matchers.FromMatcher;
import org.drools.workbench.services.verifier.api.client.index.select.Select;
import org.drools.workbench.services.verifier.api.client.maps.KeyDefinition;
import org.drools.workbench.services.verifier.api.client.maps.KeyTreeMap;
import org.drools.workbench.services.verifier.api.client.maps.MultiMap;
import org.drools.workbench.services.verifier.api.client.maps.util.HasIndex;
import org.drools.workbench.services.verifier.api.client.maps.util.HasKeys;

public class IndexedKeyTreeMap<T extends HasIndex & HasKeys>
extends KeyTreeMap<T> {
    public IndexedKeyTreeMap(KeyDefinition ... keyIDs) {
        super(keyIDs);
    }

    public void put(T object, int index) {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (Key additionalKey : ((HasKeys)object).keys()) {
            keys.add(additionalKey);
        }
        this.doForAll(index, new Callback<T>(){

            @Override
            public void callback(T t) {
                t.setIndex(t.getIndex() + 1);
            }
        });
        object.setIndex(index);
        super.put((HasKeys)object);
    }

    private void doForAll(int index, Callback<T> callback) {
        MultiMap map = this.get(IndexKey.INDEX_ID);
        Collection all = new Select(map, new FromMatcher(IndexKey.INDEX_ID, Integer.valueOf(index), true)).all();
        for (HasIndex t : all) {
            callback.callback(t);
        }
    }

    @Override
    protected T remove(UUIDKey uuidKey) {
        HasIndex remove = (HasIndex)super.remove(uuidKey);
        this.doForAll(remove.getIndex(), new Callback<T>(){

            @Override
            public void callback(T t) {
                t.setIndex(t.getIndex() - 1);
            }
        });
        return (T)remove;
    }

    @Override
    public void put(T object) {
        this.put(object, this.resolveMapByKeyId(IndexKey.INDEX_ID).size());
    }
}

