/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.maps;

import java.util.List;
import java.util.TreeMap;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.index.keys.UpdatableKey;
import org.drools.workbench.services.verifier.api.client.index.keys.Value;
import org.drools.workbench.services.verifier.api.client.maps.KeyChangeListener;
import org.drools.workbench.services.verifier.api.client.maps.KeyDefinition;
import org.drools.workbench.services.verifier.api.client.maps.MultiMap;
import org.drools.workbench.services.verifier.api.client.maps.MultiMapFactory;
import org.drools.workbench.services.verifier.api.client.maps.UUIDKeySet;
import org.drools.workbench.services.verifier.api.client.maps.util.HasKeys;
import org.kie.soup.commons.validation.PortablePreconditions;

public class KeyTreeMap<T extends HasKeys> {
    private final TreeMap<KeyDefinition, MultiMap<Value, T, List<T>>> tree = new TreeMap();
    protected final UUIDKeySet keys = new UUIDKeySet(this);
    protected KeyChangeListener<T> keyChangeListener = new KeyChangeListener<T>(){

        @Override
        public void update(Key oldKey, Key newKey, T t) {
            KeyTreeMap.this.move(oldKey, newKey, t);
        }
    };

    public KeyTreeMap(KeyDefinition ... keyIDs) {
        PortablePreconditions.checkCondition((String)"Should not be empty", (keyIDs.length != 0 ? 1 : 0) != 0);
        for (KeyDefinition keyID : keyIDs) {
            this.resolveMapByKeyId(keyID);
        }
    }

    public void put(T object) {
        PortablePreconditions.checkNotNull((String)"Object can not be null", object);
        UUIDKey uuidKey = UUIDKey.getUUIDKey(object.keys());
        if (this.keys.contains(uuidKey)) {
            throw new IllegalArgumentException("UUID already already in use. You are trying to add the same object twice.");
        }
        this.keys.add(uuidKey);
        for (Key additionalKey : object.keys()) {
            this.put(additionalKey, object);
        }
    }

    private void move(Key oldKey, Key newKey, T t) {
        if (newKey instanceof UpdatableKey) {
            ((UpdatableKey)newKey).addKeyChangeListener(this.keyChangeListener);
        }
        if (!newKey.getKeyDefinition().isUpdatable()) {
            throw new IllegalArgumentException("Key can not be updated");
        }
        this.tree.get(newKey.getKeyDefinition()).move(oldKey.getValues(), newKey.getValues(), t);
    }

    protected void put(Key key, T object) {
        if (key instanceof UpdatableKey) {
            ((UpdatableKey)key).addKeyChangeListener(this.keyChangeListener);
        }
        MultiMap<Value, T, List<T>> subMap = this.resolveMapByKeyId(key.getKeyDefinition());
        for (Value value : key.getValues()) {
            subMap.put(value, object);
        }
    }

    private void putAll(KeyDefinition id, MultiMap<Value, T, List<T>> multiMap) {
        MultiMap<Value, T, List<T>> subMap = this.resolveMapByKeyId(id);
        for (Value value : multiMap.keySet()) {
            subMap.addAllValues(value, multiMap.get(value));
        }
    }

    protected MultiMap<Value, T, List<T>> resolveMapByKeyId(KeyDefinition id) {
        if (this.tree.containsKey(id)) {
            return this.tree.get(id);
        }
        MultiMap<Value, T, List<T>> map = this.getMap(id);
        this.tree.put(id, map);
        return map;
    }

    private MultiMap<Value, T, List<T>> getMap(KeyDefinition id) {
        return MultiMapFactory.make(id.isUpdatable());
    }

    public MultiMap<Value, T, List<T>> get(KeyDefinition keyDefinition) {
        return this.tree.get(keyDefinition);
    }

    public void merge(KeyTreeMap<T> keyTreeMap) {
        this.keys.addAll(keyTreeMap.keys);
        for (KeyDefinition otherId : keyTreeMap.tree.keySet()) {
            this.putAll(otherId, keyTreeMap.tree.get(otherId));
        }
    }

    protected T remove(UUIDKey uuidKey) {
        T item = this.getItemByUUID(uuidKey);
        if (item == null) {
            return null;
        }
        Key[] removedKeys = uuidKey.getKeys();
        this.keys.remove(uuidKey);
        if (removedKeys == null) {
            return item;
        }
        for (Key removedKey : removedKeys) {
            if (!this.removeKeyForItem(removedKey, item) || !(removedKey instanceof UpdatableKey)) continue;
            ((UpdatableKey)removedKey).removeListener(this.keyChangeListener);
        }
        return item;
    }

    private boolean removeKeyForItem(Key key, T item) {
        MultiMap<Value, T, List<T>> valueTMultiMap = this.tree.get(key.getKeyDefinition());
        for (Value value : key.getValues()) {
            valueTMultiMap.get(value).remove(item);
        }
        for (Value value : key.getValues()) {
            if (!valueTMultiMap.get(value).isEmpty()) continue;
            valueTMultiMap.remove(value);
        }
        return true;
    }

    private T getItemByUUID(UUIDKey uuidKey) {
        if (this.tree.isEmpty()) {
            return null;
        }
        MultiMap<Value, T, List<T>> valueTMultiMap = this.get(uuidKey.getKeyDefinition());
        if (valueTMultiMap == null || valueTMultiMap.isEmpty()) {
            return null;
        }
        List<T> list = valueTMultiMap.get(uuidKey.getSingleValue());
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (T)((HasKeys)list.iterator().next());
    }
}

