/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client;

import java.util.List;
import java.util.Optional;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.CellUpdateManagerBase;
import org.drools.workbench.services.verifier.plugin.client.Coordinate;
import org.drools.workbench.services.verifier.plugin.client.UpdateException;
import org.drools.workbench.services.verifier.plugin.client.builders.ActionBuilder;
import org.drools.workbench.services.verifier.plugin.client.builders.TypeResolver;
import org.drools.workbench.services.verifier.plugin.client.builders.Utils;
import org.drools.workbench.services.verifier.plugin.client.builders.ValueResolveException;
import org.drools.workbench.services.verifier.plugin.client.builders.ValuesResolver;

public class RegularCellUpdateManager
extends CellUpdateManagerBase {
    private final AnalyzerConfiguration configuration;

    public RegularCellUpdateManager(Index index, AnalyzerConfiguration configuration, GuidedDecisionTable52 model, Coordinate coordinate) throws UpdateException {
        super(index, model, coordinate);
        this.configuration = configuration;
    }

    @Override
    protected boolean updateAction(Action action) {
        Values oldValues = action.getValues();
        Values values = this.getValue((DTCellValue52)((List)this.model.getData().get(this.coordinate.getRow())).get(this.coordinate.getCol()));
        if (values.isThereChanges(oldValues)) {
            action.setValue(values);
            return true;
        }
        return false;
    }

    @Override
    protected boolean updateCondition(Condition condition) {
        Values oldValues = condition.getValues();
        Values values = null;
        DTCellValue52 cell = (DTCellValue52)((List)this.model.getData().get(this.coordinate.getRow())).get(this.coordinate.getCol());
        BaseColumn baseColumn = (BaseColumn)this.model.getExpandedColumns().get(this.coordinate.getCol());
        if (baseColumn instanceof ConditionCol52 && condition instanceof FieldCondition) {
            DTCellValue52 realCellValue = Utils.getRealCellValue((DTColumnConfig52)((ConditionCol52)baseColumn), cell);
            Optional<String> operatorFromCell = Utils.findOperatorFromCell(realCellValue);
            if (operatorFromCell.isPresent()) {
                ((FieldCondition)condition).setOperator(operatorFromCell.get());
            }
            values = this.useResolver(this.configuration, (FieldCondition)condition, realCellValue, (ConditionCol52)baseColumn);
        } else {
            values = this.getValue(cell);
        }
        if (values == null && oldValues == null) {
            return false;
        }
        if (values == null || oldValues == null) {
            condition.setValue(values);
            return true;
        }
        if (values.isThereChanges(oldValues)) {
            condition.setValue(values);
            return true;
        }
        return false;
    }

    private Values useResolver(AnalyzerConfiguration configuration, final FieldCondition condition, DTCellValue52 realCellValue, ConditionCol52 baseColumn) {
        try {
            return new ValuesResolver(configuration, new TypeResolver(){

                @Override
                public String getType(Optional<String> operatorFromCell) throws ValueResolveException {
                    return condition.getField().getFieldType();
                }
            }, baseColumn, realCellValue).getValues();
        }
        catch (ValueResolveException e) {
            return this.getValue(realCellValue);
        }
    }

    private Values getValue(DTCellValue52 cell) {
        Comparable value = ActionBuilder.getValue(cell);
        if (value == null) {
            return new Values();
        }
        if (value instanceof String && ((String)((Object)value)).isEmpty()) {
            return new Values();
        }
        Values values = new Values();
        values.add((Object)value);
        return values;
    }
}

