/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.BRLAction;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Columns;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldAction;
import org.drools.verifier.core.index.model.RetractAction;
import org.drools.verifier.core.index.model.Rule;
import org.drools.verifier.core.index.model.WorkItemAction;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.BuilderFactory;
import org.drools.workbench.services.verifier.plugin.client.builders.Utils;
import org.kie.soup.commons.validation.PortablePreconditions;

public class ActionBuilder {
    private BuilderFactory builderFactory;
    private final Index index;
    private List<DTCellValue52> row;
    private ActionCol52 actionCol;
    private Rule rule;
    private AnalyzerConfiguration configuration;
    private int columnIndex;

    public ActionBuilder(BuilderFactory builderFactory, Index index, AnalyzerConfiguration configuration) {
        this.builderFactory = (BuilderFactory)PortablePreconditions.checkNotNull((String)"builderFactory", (Object)builderFactory);
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    public static Comparable getValue(DTCellValue52 dtCellValue52) {
        switch (dtCellValue52.getDataType()) {
            case NUMERIC_BIGDECIMAL: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new BigDecimal(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_BIGINTEGER: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new BigInteger(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_BYTE: {
                return new Byte(dtCellValue52.getStringValue());
            }
            case NUMERIC_DOUBLE: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Double(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_FLOAT: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Float(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_INTEGER: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Integer(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_LONG: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Long(dtCellValue52.getNumericValue().toString());
            }
            case NUMERIC_SHORT: {
                if (dtCellValue52.getNumericValue() == null) {
                    return null;
                }
                return new Short(dtCellValue52.getNumericValue().toString());
            }
            case DATE: {
                return dtCellValue52.getDateValue();
            }
            case BOOLEAN: {
                return dtCellValue52.getBooleanValue();
            }
        }
        String stringValue = dtCellValue52.getStringValue();
        if (stringValue == null) {
            return null;
        }
        if (stringValue.isEmpty()) {
            return null;
        }
        return stringValue;
    }

    public Action build() throws BuildException {
        if (this.actionCol instanceof BRLActionVariableColumn) {
            return this.addBRLAction();
        }
        if (this.actionCol instanceof ActionRetractFactCol52) {
            return this.addRetractAction();
        }
        if (this.actionCol instanceof ActionInsertFactCol52) {
            return this.addInsertFactAction((ActionInsertFactCol52)this.actionCol);
        }
        if (this.actionCol instanceof ActionWorkItemCol52) {
            return this.addWorkItem();
        }
        return this.addAction(this.actionCol, this.row.get(this.columnIndex));
    }

    private Action addInsertFactAction(ActionInsertFactCol52 actionCol) throws BuildException {
        this.builderFactory.getPatternResolver().with(this.rule).with(this.columnIndex).resolve();
        return this.addAction((ActionCol52)actionCol, this.row.get(this.columnIndex));
    }

    private Action addWorkItem() {
        return new WorkItemAction(this.getColumn(), this.getValues(this.row.get(this.columnIndex)), this.configuration);
    }

    private Action addRetractAction() {
        return new RetractAction(this.getColumn(), this.getValues(this.row.get(this.columnIndex)), this.configuration);
    }

    private Action addBRLAction() {
        return new BRLAction(this.getColumn(), this.getValues(this.row.get(this.columnIndex)), this.configuration);
    }

    private Action addAction(ActionCol52 actionCol, DTCellValue52 visibleCellValue) throws BuildException {
        Field field = this.resolveField(actionCol);
        Action action = this.buildAction(field, visibleCellValue);
        field.getActions().add(action);
        return action;
    }

    private Field resolveField(ActionCol52 actionCol) throws BuildException {
        return this.builderFactory.getFieldResolver().with(this.rule).with((BaseColumn)actionCol).with(this.columnIndex).resolve();
    }

    private Action buildAction(Field field, DTCellValue52 visibleCellValue) {
        return new FieldAction(field, this.getColumn(), visibleCellValue.getDataType(), this.getValues(visibleCellValue), this.configuration);
    }

    private Values getValues(DTCellValue52 visibleCellValue) {
        Comparable value = ActionBuilder.getValue(Utils.getRealCellValue((DTColumnConfig52)this.actionCol, visibleCellValue));
        if (value == null) {
            return new Values();
        }
        return new Values(new Comparable[]{value});
    }

    private Column getColumn() {
        return (Column)((Columns.ColumnSelect)this.index.getColumns().where((Matcher)Column.index().is((Comparable)Integer.valueOf(this.columnIndex))).select()).first();
    }

    public ActionBuilder with(Rule rule) {
        this.rule = rule;
        return this;
    }

    public ActionBuilder with(List<DTCellValue52> row) {
        this.row = row;
        return this;
    }

    public ActionBuilder with(ActionCol52 actionCol) {
        this.actionCol = actionCol;
        return this;
    }

    public ActionBuilder with(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }
}

