/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import java.util.List;
import java.util.Optional;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.model.Rule;
import org.drools.verifier.core.index.model.RuleAttribute;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.services.verifier.plugin.client.builders.AttributeBuilder;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.BuilderFactory;
import org.drools.workbench.services.verifier.plugin.client.builders.Utils;
import org.kie.soup.commons.validation.PortablePreconditions;

public class RuleBuilder {
    private final BuilderFactory builderFactory;
    private final GuidedDecisionTable52 model;
    private final AnalyzerConfiguration configuration;
    private List<DTCellValue52> row;
    private Rule rule;

    public RuleBuilder(BuilderFactory builderFactory, GuidedDecisionTable52 model, AnalyzerConfiguration configuration) {
        this.builderFactory = (BuilderFactory)PortablePreconditions.checkNotNull((String)"builderFactory", (Object)builderFactory);
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    public Rule build() throws BuildException {
        this.resolveColumns();
        return this.rule;
    }

    private void resolveColumns() throws BuildException {
        int columnIndex = 0;
        List expandedColumns = this.model.getExpandedColumns();
        for (BaseColumn baseColumn : expandedColumns) {
            try {
                if (baseColumn instanceof AttributeCol52) {
                    DTCellValue52 realCellValue;
                    String attribute = ((AttributeCol52)baseColumn).getAttribute();
                    Optional<RuleAttribute> ruleAttribute = AttributeBuilder.build(columnIndex, this.configuration, attribute, realCellValue = Utils.getRealCellValue((DTColumnConfig52)((AttributeCol52)baseColumn), this.row.get(columnIndex)));
                    if (ruleAttribute.isPresent()) {
                        this.rule.addRuleAttribute(ruleAttribute.get());
                    }
                } else if (baseColumn instanceof ConditionCol52) {
                    Condition condition = this.builderFactory.getConditionBuilder().with((ConditionCol52)baseColumn).with(this.rule).with(this.row).with(columnIndex).build();
                    this.rule.getConditions().add(condition);
                } else if (baseColumn instanceof ActionCol52) {
                    Action action = this.builderFactory.getActionBuilder().with(this.rule).with((ActionCol52)baseColumn).with(this.row).with(columnIndex).build();
                    this.rule.getActions().add(action);
                }
                ++columnIndex;
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException("Could not resolve column: Index: " + columnIndex + " header: " + baseColumn.getHeader() + " error message: " + e.getMessage());
            }
        }
    }

    public RuleBuilder with(int rowIndex) {
        this.row = (List)this.model.getData().get(rowIndex);
        this.rule = new Rule(Integer.valueOf(rowIndex), this.configuration);
        return this;
    }
}

