/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import java.util.HashMap;
import java.util.Optional;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.services.verifier.plugin.client.api.HeaderMetaData;
import org.drools.workbench.services.verifier.plugin.client.api.ModelMetaData;
import org.kie.soup.commons.validation.PortablePreconditions;

public class ModelMetaDataEnhancer {
    private final GuidedDecisionTable52 model;

    public ModelMetaDataEnhancer(GuidedDecisionTable52 model) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
    }

    public HeaderMetaData getHeaderMetaData() {
        int columnIndex = 0;
        HashMap<Integer, ModelMetaData> map = new HashMap<Integer, ModelMetaData>();
        for (BaseColumn baseColumn : this.model.getExpandedColumns()) {
            if (baseColumn instanceof ConditionCol52) {
                map.put(columnIndex, new ModelMetaData(this.model.getPattern((ConditionCol52)baseColumn), PatternType.LHS));
            } else if (baseColumn instanceof ActionInsertFactCol52) {
                ActionInsertFactCol52 aif = (ActionInsertFactCol52)baseColumn;
                map.put(columnIndex, new ModelMetaData(aif.getFactType(), aif.getBoundName(), PatternType.RHS));
            } else if (baseColumn instanceof ActionSetFieldCol52) {
                ActionSetFieldCol52 asf = (ActionSetFieldCol52)baseColumn;
                map.put(columnIndex, new ModelMetaData(this.getFactType(asf), asf.getBoundName(), PatternType.RHS));
            }
            ++columnIndex;
        }
        return new HeaderMetaData(map);
    }

    private String getFactType(ActionSetFieldCol52 asf) {
        String binding = asf.getBoundName();
        Optional<Pattern52> pattern = Optional.ofNullable(this.model.getConditionPattern(binding));
        if (pattern.isPresent()) {
            return pattern.get().getFactType();
        }
        return this.model.getActionCols().stream().filter(c -> c instanceof ActionInsertFactCol52).map(c -> (ActionInsertFactCol52)c).filter(c -> c.getBoundName().equals(binding)).findFirst().map(ActionInsertFactCol52::getFactType).get();
    }

    public static enum PatternType {
        LHS,
        RHS;

    }
}

