/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.backend;

import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.adaptors.ActionInsertFactCol52ActionInsertFactAdaptor;
import org.drools.workbench.models.guided.dtable.shared.model.adaptors.ActionInsertFactCol52ActionInsertLogicalFactAdaptor;
import org.drools.workbench.models.guided.dtable.shared.model.adaptors.Pattern52FactPatternAdaptor;
import org.junit.Assert;
import org.junit.Test;

public class BRLRuleModelTest {
    @Test
    public void testOnlyDecisionTableColumns() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)3L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
    }

    @Test
    public void testDecisionTableColumnsWithLHS() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)5L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$brl1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$sfc1"));
    }

    @Test
    public void testDecisionTableColumnsWithLHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getLHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getLHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$p1"));
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$brl1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$p1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$p1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$brl1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$brl1"));
        FactPattern r1 = model.getLHSBoundFact("$p1");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof Pattern52FactPatternAdaptor));
        Pattern52FactPatternAdaptor raif1 = (Pattern52FactPatternAdaptor)r1;
        Assert.assertEquals((Object)"Driver", (Object)raif1.getFactType());
        FactPattern r2 = model.getLHSBoundFact("$brl1");
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((Object)"Driver", (Object)r2.getFactType());
    }

    @Test
    public void testDecisionTableColumnsWithLHSBoundFields() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        SingleFieldConstraint fcr1 = model.getLHSBoundField("$sfc1");
        Assert.assertNotNull((Object)fcr1);
        Assert.assertTrue((boolean)(fcr1 instanceof SingleFieldConstraint));
        SingleFieldConstraint fcr1sfc = fcr1;
        Assert.assertEquals((Object)"name", (Object)fcr1sfc.getFieldName());
        Assert.assertEquals((Object)"String", (Object)fcr1sfc.getFieldType());
    }

    @Test
    public void testDecisionTableColumnsWithRHS() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif = new ActionInsertFact("Person");
        aif.setBoundName("$aif");
        aif.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif.getFieldValues()[0].setNature(1);
        brlAction.getDefinition().add(aif);
        dt.getActionCols().add(brlAction);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)4L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$aif"));
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof ActionInsertFactCol52ActionInsertFactAdaptor));
        ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif1.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif1.getFieldValues()[0].getNature());
        ActionInsertFact r2 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFact));
        ActionInsertFact raif2 = r2;
        Assert.assertEquals((Object)"Person", (Object)raif2.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif2.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif2.getFieldValues()[0].getNature());
    }

    @Test
    public void testDecisionTableColumnsWithRHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        ActionInsertFactCol52 ins2 = new ActionInsertFactCol52();
        ins2.setInsertLogical(true);
        ins2.setBoundName("$ins2");
        ins2.setFactField("rating2");
        ins2.setFactType("Person2");
        ins2.setType("String");
        dt.getActionCols().add(ins2);
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif = new ActionInsertFact("Person");
        aif.setBoundName("$aif");
        aif.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif.getFieldValues()[0].setNature(1);
        brlAction.getDefinition().add(aif);
        dt.getActionCols().add(brlAction);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)3L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins2"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof ActionInsertFactCol52ActionInsertFactAdaptor));
        ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif1.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif1.getFieldValues()[0].getNature());
        ActionInsertFact r2 = model.getRHSBoundFact("$ins2");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFactCol52ActionInsertLogicalFactAdaptor));
        ActionInsertFactCol52ActionInsertLogicalFactAdaptor raif2 = (ActionInsertFactCol52ActionInsertLogicalFactAdaptor)r2;
        Assert.assertEquals((Object)"Person2", (Object)raif2.getFactType());
        Assert.assertEquals((Object)"rating2", (Object)raif2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif2.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif2.getFieldValues()[0].getNature());
        ActionInsertFact r3 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r3);
        Assert.assertTrue((boolean)(r3 instanceof ActionInsertFact));
        ActionInsertFact raif3 = r3;
        Assert.assertEquals((Object)"Person", (Object)raif3.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif3.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif3.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif3.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif3.getFieldValues()[0].getNature());
    }

    @Test
    public void testRuleModelLHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLRuleModel model = new BRLRuleModel(dt);
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        model.addLhsItem((IPattern)fp);
        Assert.assertNotNull((Object)model.getLHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getLHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$p1"));
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$brl1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$p1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$p1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$brl1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$brl1"));
        FactPattern r1 = model.getLHSBoundFact("$p1");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof Pattern52FactPatternAdaptor));
        Pattern52FactPatternAdaptor raif1 = (Pattern52FactPatternAdaptor)r1;
        Assert.assertEquals((Object)"Driver", (Object)raif1.getFactType());
        FactPattern r2 = model.getLHSBoundFact("$brl1");
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((Object)"Driver", (Object)r2.getFactType());
    }

    @Test
    public void testRuleModelLHSBoundFacts_NoDuplicates() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp1 = new FactPattern("Driver");
        fp1.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp1.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp1);
        dt.getConditions().add(brlCondition);
        BRLRuleModel model = new BRLRuleModel(dt);
        FactPattern fp2 = new FactPattern("Driver");
        fp2.setBoundName("$brl1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldBinding("$sfc1");
        sfc2.setOperator("==");
        sfc2.setFactType("Driver");
        sfc2.setFieldName("name");
        sfc2.setFieldType("String");
        fp2.addConstraint((FieldConstraint)sfc2);
        model.addLhsItem((IPattern)fp2);
        Assert.assertNotNull((Object)model.getLHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getLHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$p1"));
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$brl1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$p1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$p1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$brl1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$brl1"));
        FactPattern r1 = model.getLHSBoundFact("$p1");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof Pattern52FactPatternAdaptor));
        Pattern52FactPatternAdaptor raif1 = (Pattern52FactPatternAdaptor)r1;
        Assert.assertEquals((Object)"Driver", (Object)raif1.getFactType());
        FactPattern r2 = model.getLHSBoundFact("$brl1");
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((Object)"Driver", (Object)r2.getFactType());
    }

    @Test
    public void testRuleModelRHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        ActionInsertFact aif = new ActionInsertFact("Person");
        aif.setBoundName("$aif");
        aif.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif.getFieldValues()[0].setNature(1);
        model.addRhsItem((IAction)aif);
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof ActionInsertFactCol52ActionInsertFactAdaptor));
        ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif1.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif1.getFieldValues()[0].getNature());
        ActionInsertFact r2 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFact));
        ActionInsertFact raif2 = r2;
        Assert.assertEquals((Object)"Person", (Object)raif2.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif2.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif2.getFieldValues()[0].getNature());
    }

    @Test
    public void testRuleModelRHSBoundFacts_NoDuplicates() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif1 = new ActionInsertFact("Person");
        aif1.setBoundName("$aif");
        aif1.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif1.getFieldValues()[0].setNature(1);
        brlAction.getDefinition().add(aif1);
        dt.getActionCols().add(brlAction);
        BRLRuleModel model = new BRLRuleModel(dt);
        ActionInsertFact aif2 = new ActionInsertFact("Person");
        aif2.setBoundName("$aif");
        aif2.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif2.getFieldValues()[0].setNature(1);
        model.addRhsItem((IAction)aif2);
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof ActionInsertFactCol52ActionInsertFactAdaptor));
        ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif1.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif1.getFieldValues()[0].getNature());
        ActionInsertFact r2 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFact));
        ActionInsertFact raif2 = r2;
        Assert.assertEquals((Object)"Person", (Object)raif2.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif2.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif2.getFieldValues()[0].getNature());
    }
}

