/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.backend;

import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionUpdateField;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTDRLPersistence;
import org.drools.workbench.models.guided.dtable.backend.util.DataUtilities;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.adaptors.ActionInsertFactCol52ActionInsertFactAdaptor;
import org.drools.workbench.models.guided.dtable.shared.model.adaptors.ActionInsertFactCol52ActionInsertLogicalFactAdaptor;
import org.drools.workbench.models.guided.dtable.shared.model.adaptors.ConditionCol52FieldConstraintAdaptor;
import org.drools.workbench.models.guided.dtable.shared.model.adaptors.Pattern52FactPatternAdaptor;
import org.junit.Assert;
import org.junit.Test;

public class BRLRuleModelTest {
    @Test
    public void testOnlyDecisionTableColumns() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)3L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
    }

    @Test
    public void testDecisionTableColumnsWithLHS() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)5L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$brl1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$sfc1"));
    }

    @Test
    public void testDecisionTableColumnsWithLHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getLHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getLHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$p1"));
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$brl1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$p1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$p1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$brl1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$brl1"));
        FactPattern r1 = model.getLHSBoundFact("$p1");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof Pattern52FactPatternAdaptor));
        Pattern52FactPatternAdaptor raif1 = (Pattern52FactPatternAdaptor)r1;
        Assert.assertEquals((Object)"Driver", (Object)raif1.getFactType());
        FactPattern r2 = model.getLHSBoundFact("$brl1");
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((Object)"Driver", (Object)r2.getFactType());
    }

    @Test
    public void testDecisionTableColumnsWithLHSBoundFields() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp);
        dt.getConditions().add(brlCondition);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        SingleFieldConstraint fcr1 = model.getLHSBoundField("$sfc1");
        Assert.assertNotNull((Object)fcr1);
        Assert.assertTrue((boolean)(fcr1 instanceof SingleFieldConstraint));
        SingleFieldConstraint fcr1sfc = fcr1;
        Assert.assertEquals((Object)"name", (Object)fcr1sfc.getFieldName());
        Assert.assertEquals((Object)"String", (Object)fcr1sfc.getFieldType());
    }

    @Test
    public void testDecisionTableColumnsWithLHSBoundFieldsInConditionCol52() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setFieldType("String");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLRuleModel model = new BRLRuleModel(dt);
        SingleFieldConstraint fcr1 = model.getLHSBoundField("$c1");
        Assert.assertNotNull((Object)fcr1);
        Assert.assertTrue((boolean)(fcr1 instanceof ConditionCol52FieldConstraintAdaptor));
        ConditionCol52FieldConstraintAdaptor fcr1sfc = (ConditionCol52FieldConstraintAdaptor)fcr1;
        Assert.assertEquals((Object)"Driver", (Object)fcr1sfc.getFactType());
        Assert.assertEquals((Object)"name", (Object)fcr1sfc.getFieldName());
        Assert.assertEquals((Object)"String", (Object)fcr1sfc.getFieldType());
    }

    @Test
    public void testDecisionTableColumnsWithRHS() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif = new ActionInsertFact("Person");
        aif.setBoundName("$aif");
        aif.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif.getFieldValues()[0].setNature(1);
        brlAction.getDefinition().add(aif);
        dt.getActionCols().add(brlAction);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getAllVariables());
        Assert.assertEquals((long)4L, (long)model.getAllVariables().size());
        Assert.assertTrue((boolean)model.getAllVariables().contains("$p1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$c1"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$ins"));
        Assert.assertTrue((boolean)model.getAllVariables().contains("$aif"));
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof ActionInsertFactCol52ActionInsertFactAdaptor));
        ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif1.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif1.getFieldValues()[0].getNature());
        ActionInsertFact r2 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFact));
        ActionInsertFact raif2 = r2;
        Assert.assertEquals((Object)"Person", (Object)raif2.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif2.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif2.getFieldValues()[0].getNature());
    }

    @Test
    public void testDecisionTableColumnsWithRHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        ActionInsertFactCol52 ins2 = new ActionInsertFactCol52();
        ins2.setInsertLogical(true);
        ins2.setBoundName("$ins2");
        ins2.setFactField("rating2");
        ins2.setFactType("Person2");
        ins2.setType("String");
        dt.getActionCols().add(ins2);
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif = new ActionInsertFact("Person");
        aif.setBoundName("$aif");
        aif.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif.getFieldValues()[0].setNature(1);
        brlAction.getDefinition().add(aif);
        dt.getActionCols().add(brlAction);
        BRLRuleModel model = new BRLRuleModel(dt);
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)3L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins2"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof ActionInsertFactCol52ActionInsertFactAdaptor));
        ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif1.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif1.getFieldValues()[0].getNature());
        ActionInsertFact r2 = model.getRHSBoundFact("$ins2");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFactCol52ActionInsertLogicalFactAdaptor));
        ActionInsertFactCol52ActionInsertLogicalFactAdaptor raif2 = (ActionInsertFactCol52ActionInsertLogicalFactAdaptor)r2;
        Assert.assertEquals((Object)"Person2", (Object)raif2.getFactType());
        Assert.assertEquals((Object)"rating2", (Object)raif2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif2.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif2.getFieldValues()[0].getNature());
        ActionInsertFact r3 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r3);
        Assert.assertTrue((boolean)(r3 instanceof ActionInsertFact));
        ActionInsertFact raif3 = r3;
        Assert.assertEquals((Object)"Person", (Object)raif3.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif3.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif3.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif3.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif3.getFieldValues()[0].getNature());
    }

    @Test
    public void testRuleModelLHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLRuleModel model = new BRLRuleModel(dt);
        FactPattern fp = new FactPattern("Driver");
        fp.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp.addConstraint((FieldConstraint)sfc1);
        model.addLhsItem((IPattern)fp);
        Assert.assertNotNull((Object)model.getLHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getLHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$p1"));
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$brl1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$p1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$p1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$brl1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$brl1"));
        FactPattern r1 = model.getLHSBoundFact("$p1");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof Pattern52FactPatternAdaptor));
        Pattern52FactPatternAdaptor raif1 = (Pattern52FactPatternAdaptor)r1;
        Assert.assertEquals((Object)"Driver", (Object)raif1.getFactType());
        FactPattern r2 = model.getLHSBoundFact("$brl1");
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((Object)"Driver", (Object)r2.getFactType());
    }

    @Test
    public void testRuleModelLHSBoundFacts_NoDuplicates() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Driver");
        p1.setBoundName("$p1");
        ConditionCol52 c1 = new ConditionCol52();
        c1.setFactField("name");
        c1.setConstraintValueType(1);
        c1.setBinding("$c1");
        p1.getChildColumns().add(c1);
        dt.getConditions().add(p1);
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp1 = new FactPattern("Driver");
        fp1.setBoundName("$brl1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setFieldBinding("$sfc1");
        sfc1.setOperator("==");
        sfc1.setFactType("Driver");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        fp1.addConstraint((FieldConstraint)sfc1);
        brlCondition.getDefinition().add(fp1);
        dt.getConditions().add(brlCondition);
        BRLRuleModel model = new BRLRuleModel(dt);
        FactPattern fp2 = new FactPattern("Driver");
        fp2.setBoundName("$brl1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setFieldBinding("$sfc1");
        sfc2.setOperator("==");
        sfc2.setFactType("Driver");
        sfc2.setFieldName("name");
        sfc2.setFieldType("String");
        fp2.addConstraint((FieldConstraint)sfc2);
        model.addLhsItem((IPattern)fp2);
        Assert.assertNotNull((Object)model.getLHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getLHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$p1"));
        Assert.assertTrue((boolean)model.getLHSBoundFacts().contains("$brl1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$p1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$p1"));
        Assert.assertNotNull((Object)model.getLHSBindingType("$brl1"));
        Assert.assertEquals((Object)"Driver", (Object)model.getLHSBindingType("$brl1"));
        FactPattern r1 = model.getLHSBoundFact("$p1");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof Pattern52FactPatternAdaptor));
        Pattern52FactPatternAdaptor raif1 = (Pattern52FactPatternAdaptor)r1;
        Assert.assertEquals((Object)"Driver", (Object)raif1.getFactType());
        FactPattern r2 = model.getLHSBoundFact("$brl1");
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((Object)"Driver", (Object)r2.getFactType());
    }

    @Test
    public void testRuleModelRHSBoundFacts() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLRuleModel model = new BRLRuleModel(dt);
        ActionInsertFact aif = new ActionInsertFact("Person");
        aif.setBoundName("$aif");
        aif.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif.getFieldValues()[0].setNature(1);
        model.addRhsItem((IAction)aif);
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof ActionInsertFactCol52ActionInsertFactAdaptor));
        ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif1.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif1.getFieldValues()[0].getNature());
        ActionInsertFact r2 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFact));
        ActionInsertFact raif2 = r2;
        Assert.assertEquals((Object)"Person", (Object)raif2.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif2.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif2.getFieldValues()[0].getNature());
    }

    @Test
    public void testRuleModelRHSBoundFacts_NoDuplicates() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("$ins");
        ins.setFactField("rating");
        ins.setFactType("Person");
        ins.setType("String");
        dt.getActionCols().add(ins);
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionInsertFact aif1 = new ActionInsertFact("Person");
        aif1.setBoundName("$aif");
        aif1.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif1.getFieldValues()[0].setNature(1);
        brlAction.getDefinition().add(aif1);
        dt.getActionCols().add(brlAction);
        BRLRuleModel model = new BRLRuleModel(dt);
        ActionInsertFact aif2 = new ActionInsertFact("Person");
        aif2.setBoundName("$aif");
        aif2.addFieldValue(new ActionFieldValue("rating", null, "String"));
        aif2.getFieldValues()[0].setNature(1);
        model.addRhsItem((IAction)aif2);
        Assert.assertNotNull((Object)model.getRHSBoundFacts());
        Assert.assertEquals((long)2L, (long)model.getRHSBoundFacts().size());
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$ins"));
        Assert.assertTrue((boolean)model.getRHSBoundFacts().contains("$aif"));
        ActionInsertFact r1 = model.getRHSBoundFact("$ins");
        Assert.assertNotNull((Object)r1);
        Assert.assertTrue((boolean)(r1 instanceof ActionInsertFactCol52ActionInsertFactAdaptor));
        ActionInsertFactCol52ActionInsertFactAdaptor raif1 = (ActionInsertFactCol52ActionInsertFactAdaptor)r1;
        Assert.assertEquals((Object)"Person", (Object)raif1.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif1.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif1.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif1.getFieldValues()[0].getNature());
        ActionInsertFact r2 = model.getRHSBoundFact("$aif");
        Assert.assertNotNull((Object)r2);
        Assert.assertTrue((boolean)(r2 instanceof ActionInsertFact));
        ActionInsertFact raif2 = r2;
        Assert.assertEquals((Object)"Person", (Object)raif2.getFactType());
        Assert.assertEquals((Object)"rating", (Object)raif2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"String", (Object)raif2.getFieldValues()[0].getType());
        Assert.assertNull((Object)raif2.getFieldValues()[0].getValue());
        Assert.assertEquals((long)1L, (long)raif2.getFieldValues()[0].getNature());
    }

    @Test
    public void testUpdateModifyMultipleFields() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        BRLActionColumn brlAction1 = new BRLActionColumn();
        ActionUpdateField auf1 = new ActionUpdateField("x");
        auf1.addFieldValue(new ActionFieldValue("age", "$age", "Integer"));
        auf1.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf1);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$age", "Integer", "Context", "age"));
        dt.getActionCols().add(brlAction1);
        BRLActionColumn brlAction2 = new BRLActionColumn();
        ActionUpdateField auf2 = new ActionUpdateField("x");
        auf2.addFieldValue(new ActionFieldValue("name", "$name", "String"));
        auf2.getFieldValues()[0].setNature(7);
        brlAction2.getDefinition().add(auf2);
        brlAction2.getChildColumns().add(new BRLActionVariableColumn("$name", "String", "Context", "name"));
        dt.getActionCols().add(brlAction2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "x", "55", "Fred"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected1 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ), \n    setName( \"Fred\" )\n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ), \n    setName( \"Fred\" )\n}\nend\n", drl);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "x", "", "Fred"}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected2 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setName( \"Fred\" )\n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setName( \"Fred\" )\n}\nend\n", drl);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "x", "55", ""}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected3 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ) \n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ) \n}\nend\n", drl);
    }

    @Test
    public void testUpdateModifyMultipleFieldsWithMultipleSkipped1() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        BRLActionColumn brlAction1 = new BRLActionColumn();
        ActionUpdateField auf1 = new ActionUpdateField("x");
        auf1.addFieldValue(new ActionFieldValue("f1", "$f1", "String"));
        auf1.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf1);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f1", "String", "Context", "f1"));
        ActionUpdateField auf2 = new ActionUpdateField("x");
        auf2.addFieldValue(new ActionFieldValue("f2", "$f2", "String"));
        auf2.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf2);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f2", "String", "Context", "f2"));
        ActionUpdateField auf3 = new ActionUpdateField("x");
        auf3.addFieldValue(new ActionFieldValue("f3", "$f3", "String"));
        auf3.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf3);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f3", "String", "Context", "f3"));
        dt.getActionCols().add(brlAction1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "x", "v1", "v2", "v3"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setF1( \"v1\" ), \n    setF2( \"v2\" ),\n    setF3( \"v3\" )\n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setF1( \"v1\" ), \n    setF2( \"v2\" ),\n    setF3( \"v3\" )\n}\nend\n", drl);
    }

    @Test
    public void testUpdateModifyMultipleFieldsWithMultipleSkipped2() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        BRLActionColumn brlAction1 = new BRLActionColumn();
        ActionUpdateField auf1 = new ActionUpdateField("x");
        auf1.addFieldValue(new ActionFieldValue("f1", "$f1", "String"));
        auf1.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf1);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f1", "String", "Context", "f1"));
        ActionUpdateField auf2 = new ActionUpdateField("x");
        auf2.addFieldValue(new ActionFieldValue("f2", "$f2", "String"));
        auf2.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf2);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f2", "String", "Context", "f2"));
        ActionUpdateField auf3 = new ActionUpdateField("x");
        auf3.addFieldValue(new ActionFieldValue("f3", "$f3", "String"));
        auf3.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf3);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f3", "String", "Context", "f3"));
        dt.getActionCols().add(brlAction1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "x", null, "v2", "v3"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setF2( \"v2\" ),\n    setF3( \"v3\" )\n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setF2( \"v2\" ),\n    setF3( \"v3\" )\n}\nend\n", drl);
    }

    @Test
    public void testUpdateModifyMultipleFieldsWithMultipleSkipped3() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        BRLActionColumn brlAction1 = new BRLActionColumn();
        ActionUpdateField auf1 = new ActionUpdateField("x");
        auf1.addFieldValue(new ActionFieldValue("f1", "$f1", "String"));
        auf1.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf1);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f1", "String", "Context", "f1"));
        ActionUpdateField auf2 = new ActionUpdateField("x");
        auf2.addFieldValue(new ActionFieldValue("f2", "$f2", "String"));
        auf2.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf2);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f2", "String", "Context", "f2"));
        ActionUpdateField auf3 = new ActionUpdateField("x");
        auf3.addFieldValue(new ActionFieldValue("f3", "$f3", "String"));
        auf3.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf3);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f3", "String", "Context", "f3"));
        dt.getActionCols().add(brlAction1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "x", null, null, "v3"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setF3( \"v3\" )\n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setF3( \"v3\" )\n}\nend\n", drl);
    }

    @Test
    public void testUpdateModifyMultipleFieldsWithMultipleSkipped4() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        BRLActionColumn brlAction1 = new BRLActionColumn();
        ActionUpdateField auf1 = new ActionUpdateField("x");
        auf1.addFieldValue(new ActionFieldValue("f1", "$f1", "String"));
        auf1.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf1);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f1", "String", "Context", "f1"));
        ActionUpdateField auf2 = new ActionUpdateField("x");
        auf2.addFieldValue(new ActionFieldValue("f2", "$f2", "String"));
        auf2.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf2);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f2", "String", "Context", "f2"));
        ActionUpdateField auf3 = new ActionUpdateField("x");
        auf3.addFieldValue(new ActionFieldValue("f3", "$f3", "String"));
        auf3.getFieldValues()[0].setNature(7);
        brlAction1.getDefinition().add(auf3);
        brlAction1.getChildColumns().add(new BRLActionVariableColumn("$f3", "String", "Context", "f3"));
        dt.getActionCols().add(brlAction1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "x", "v1", null, "v3"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setF1( \"v1\" ),\n    setF3( \"v3\" )\n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setF1( \"v1\" ),\n    setF3( \"v3\" )\n}\nend\n", drl);
    }

    @Test
    public void testLHSNonEmptyStringValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Smurf");
        fp.setBoundName("p1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setOperator("==");
        sfc1.setFactType("Smurf");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setOperator("==");
        sfc2.setFactType("Smurf");
        sfc2.setFieldName("age");
        sfc2.setFieldType("Integer");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        fp.addConstraint((FieldConstraint)sfc2);
        brlCondition.getDefinition().add(fp);
        brlCondition.getChildColumns().add(new BRLConditionVariableColumn("$f1", "String", "Smurf", "name"));
        brlCondition.getChildColumns().add(new BRLConditionVariableColumn("$f2", "Integer", "Smurf", "age"));
        dt.getConditions().add(brlCondition);
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", "Pupa", null}}));
        String drl1 = p.marshal(dt);
        String expected1 = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"Pupa\" )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"Pupa\" )\n  then\nend", drl1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{2L, "desc-row2", null, 35L}}));
        String drl2 = p.marshal(dt);
        String expected2 = "//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend", drl2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{3L, "desc-row3", "Pupa", 35L}}));
        String drl3 = p.marshal(dt);
        String expected3 = "//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"Pupa\", age == 35 )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"Pupa\", age == 35 )\n  then\nend", drl3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{4L, "desc-row4", null, null}}));
        String drl4 = p.marshal(dt);
        String expected4 = "//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend", drl4);
    }

    @Test
    public void testLHSDelimitedNonEmptyStringValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FactPattern fp = new FactPattern("Smurf");
        fp.setBoundName("p1");
        SingleFieldConstraint sfc1 = new SingleFieldConstraint();
        sfc1.setOperator("==");
        sfc1.setFactType("Smurf");
        sfc1.setFieldName("name");
        sfc1.setFieldType("String");
        sfc1.setConstraintValueType(7);
        sfc1.setValue("$f1");
        SingleFieldConstraint sfc2 = new SingleFieldConstraint();
        sfc2.setOperator("==");
        sfc2.setFactType("Smurf");
        sfc2.setFieldName("age");
        sfc2.setFieldType("Integer");
        sfc2.setConstraintValueType(7);
        sfc2.setValue("$f2");
        fp.addConstraint((FieldConstraint)sfc1);
        fp.addConstraint((FieldConstraint)sfc2);
        brlCondition.getDefinition().add(fp);
        brlCondition.getChildColumns().add(new BRLConditionVariableColumn("$f1", "String", "Smurf", "name"));
        brlCondition.getChildColumns().add(new BRLConditionVariableColumn("$f2", "Integer", "Smurf", "age"));
        dt.getConditions().add(brlCondition);
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", null, null}}));
        String drl1 = p.marshal(dt);
        String expected1 = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend", drl1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{2L, "desc-row2", "\"   \"", 35L}}));
        String drl2 = p.marshal(dt);
        String expected2 = "//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"   \", age == 35 )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"   \", age == 35 )\n  then\nend", drl2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{3L, "desc-row3", "\"\"", null}}));
        String drl3 = p.marshal(dt);
        String expected3 = "//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\" )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\" )\n  then\nend", drl3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{4L, "desc-row4", "\"\"", 35L}}));
        String drl4 = p.marshal(dt);
        String expected4 = "//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\", age == 35 )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\", age == 35 )\n  then\nend", drl4);
    }

    @Test
    public void testLHSNonEmptyStringValuesFreeFormLine() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        FreeFormLine ffl = new FreeFormLine();
        ffl.setText("p1 : Smurf( name ==\"@{$f1}\", age == @{$f2} )");
        brlCondition.getDefinition().add(ffl);
        brlCondition.getChildColumns().add(new BRLConditionVariableColumn("$f1", "String", "Smurf", "name"));
        brlCondition.getChildColumns().add(new BRLConditionVariableColumn("$f2", "Integer", "Smurf", "age"));
        dt.getConditions().add(brlCondition);
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", "Pupa", null}}));
        String drl1 = p.marshal(dt);
        String expected1 = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend", drl1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{2L, "desc-row2", null, 35L}}));
        String drl2 = p.marshal(dt);
        String expected2 = "//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend", drl2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{3L, "desc-row3", "Pupa", 35L}}));
        String drl3 = p.marshal(dt);
        String expected3 = "//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"Pupa\", age == 35 )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"Pupa\", age == 35 )\n  then\nend", drl3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{4L, "desc-row4", null, null}}));
        String drl4 = p.marshal(dt);
        String expected4 = "//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend", drl4);
    }

    @Test
    public void testRHSNonEmptyStringValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionUpdateField auf1 = new ActionUpdateField("p1");
        auf1.addFieldValue(new ActionFieldValue("name", "$name", "String"));
        auf1.getFieldValues()[0].setNature(7);
        ActionUpdateField auf2 = new ActionUpdateField("p1");
        auf2.addFieldValue(new ActionFieldValue("age", "$age", "Integer"));
        auf2.getFieldValues()[0].setNature(7);
        brlAction.getDefinition().add(auf1);
        brlAction.getDefinition().add(auf2);
        brlAction.getChildColumns().add(new BRLActionVariableColumn("$name", "String", "Smurf", "name"));
        brlAction.getChildColumns().add(new BRLActionVariableColumn("$age", "Integer", "Smurf", "age"));
        dt.getActionCols().add(brlAction);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", null, null}}));
        String drl1 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected1 = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend", drl1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{2L, "desc-row2", "   ", 35L}}));
        String drl2 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected2 = "//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setAge( 35 )\n    }\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setAge( 35 )\n    }\nend", drl2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{3L, "desc-row3", "", null}}));
        String drl3 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected3 = "//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend", drl3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{4L, "desc-row4", "", 35L}}));
        String drl4 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected4 = "//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setAge( 35 )\n    }\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setAge( 35 )\n    }\nend", drl4);
    }

    @Test
    public void testRHSDelimitedNonEmptyStringValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        BRLActionColumn brlAction = new BRLActionColumn();
        ActionUpdateField auf1 = new ActionUpdateField("p1");
        auf1.addFieldValue(new ActionFieldValue("name", "$name", "String"));
        auf1.getFieldValues()[0].setNature(7);
        ActionUpdateField auf2 = new ActionUpdateField("p1");
        auf2.addFieldValue(new ActionFieldValue("age", "$age", "Integer"));
        auf2.getFieldValues()[0].setNature(7);
        brlAction.getDefinition().add(auf1);
        brlAction.getDefinition().add(auf2);
        brlAction.getChildColumns().add(new BRLActionVariableColumn("$name", "String", "Smurf", "name"));
        brlAction.getChildColumns().add(new BRLActionVariableColumn("$age", "Integer", "Smurf", "age"));
        dt.getActionCols().add(brlAction);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", null, null}}));
        String drl1 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected1 = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend", drl1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{2L, "desc-row2", "\"   \"", 35L}}));
        String drl2 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected2 = "//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setName( \"   \" ),\n      setAge( 35 )\n    }\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setName( \"   \" ),\n      setAge( 35 )\n    }\nend", drl2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{3L, "desc-row3", "\"\"", null}}));
        String drl3 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected3 = "//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setName( \"\" )\n    }\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setName( \"\" )\n    }\nend", drl3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{4L, "desc-row4", "\"\"", 35L}}));
        String drl4 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected4 = "//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setName( \"\" ),\n      setAge( 35 )\n    }\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    modify( p1 ) {\n      setName( \"\" ),\n      setAge( 35 )\n    }\nend", drl4);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }
}

