/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.backend;

import java.util.ArrayList;
import java.util.List;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.rule.ActionExecuteWorkItem;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionRetractFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.ActionWorkItemFieldValue;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.FreeFormLine;
import org.drools.workbench.models.datamodel.rule.RuleAttribute;
import org.drools.workbench.models.datamodel.rule.RuleMetadata;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.models.datamodel.workitems.PortableBooleanParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableFloatParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableIntegerParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableStringParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTDRLPersistence;
import org.drools.workbench.models.guided.dtable.backend.util.DataUtilities;
import org.drools.workbench.models.guided.dtable.backend.util.GuidedDTTemplateDataProvider;
import org.drools.workbench.models.guided.dtable.backend.util.TemplateDataProvider;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.junit.Assert;
import org.junit.Test;

public class GuidedDTDRLPersistenceTest {
    @Test
    public void testInWithSimpleSingleLiteralValue() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableName("in_operator");
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Person");
        ConditionCol52 con = new ConditionCol52();
        con.setConstraintValueType(1);
        con.setFieldType("String");
        con.setFactField("field1");
        con.setHeader("Person field1");
        con.setOperator("in");
        p1.getChildColumns().add(con);
        dt.getConditions().add(p1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc1", "ak1,mk1"}, {"2", "desc2", "(ak2,mk2)"}, {"3", "desc3", "( ak3, mk3 )"}, {"4", "desc4", "( \"ak4\", \"mk4\" )"}, {"5", "desc5", "( \"ak5 \", \" mk5\" )"}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        String expected = "//from row number: 1\n//desc1\nrule \"Row 1 in_operator\"\ndialect \"mvel\"\nwhen\n  Person( field1 in ( \"ak1\", \"mk1\" ) )\nthen\nend\n//from row number: 2\n//desc2\nrule \"Row 2 in_operator\"\ndialect \"mvel\"\nwhen\n  Person( field1 in ( \"ak2\", \"mk2\" ) )\nthen\nend\n//from row number: 3\n//desc3\nrule \"Row 3 in_operator\"\ndialect \"mvel\"\nwhen\n  Person( field1 in ( \"ak3\", \"mk3\" ) )\nthen\nend\n//from row number: 4\n//desc4\nrule \"Row 4 in_operator\"\ndialect \"mvel\"\nwhen\n  Person( field1 in ( \"ak4\", \"mk4\" ) )\nthen\nend\n//from row number: 5\n//desc5\nrule \"Row 5 in_operator\"\ndialect \"mvel\"\nwhen\n  Person( field1 in ( \"ak5 \", \" mk5\" ) )\nthen\nend";
        this.assertEqualsIgnoreWhitespace(expected, drl);
    }

    @Test
    public void test2Rules() throws Exception {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableName("michael");
        AttributeCol52 attr = new AttributeCol52();
        attr.setAttribute("salience");
        attr.setDefaultValue(new DTCellValue52("66"));
        dt.getAttributeCols().add(attr);
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("f1");
        p1.setFactType("Driver");
        ConditionCol52 con = new ConditionCol52();
        con.setConstraintValueType(1);
        con.setFactField("age");
        con.setHeader("Driver f1 age");
        con.setOperator("==");
        p1.getChildColumns().add(con);
        ConditionCol52 con2 = new ConditionCol52();
        con2.setConstraintValueType(1);
        con2.setFactField("name");
        con2.setHeader("Driver f1 name");
        con2.setOperator("==");
        p1.getChildColumns().add(con2);
        ConditionCol52 con3 = new ConditionCol52();
        con3.setConstraintValueType(3);
        con3.setFactField("rating");
        con3.setHeader("Driver rating");
        con3.setOperator("==");
        p1.getChildColumns().add(con3);
        dt.getConditions().add(p1);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("f2");
        p2.setFactType("Driver");
        ConditionCol52 con4 = new ConditionCol52();
        con4.setConstraintValueType(5);
        con4.setHeader("Driver 2 pimp");
        con4.setFactField("(not needed)");
        p2.getChildColumns().add(con4);
        dt.getConditions().add(p2);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("ins");
        ins.setFactType("Cheese");
        ins.setFactField("price");
        ins.setType("Integer");
        dt.getActionCols().add(ins);
        ActionRetractFactCol52 ret = new ActionRetractFactCol52();
        dt.getActionCols().add(ret);
        ActionSetFieldCol52 set = new ActionSetFieldCol52();
        set.setBoundName("f1");
        set.setFactField("goo1");
        set.setType("String");
        dt.getActionCols().add(set);
        ActionSetFieldCol52 set2 = new ActionSetFieldCol52();
        set2.setBoundName("f1");
        set2.setFactField("goo2");
        set2.setDefaultValue(new DTCellValue52("whee"));
        set2.setType("String");
        dt.getActionCols().add(set2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "42", "33", "michael", "age * 0.2", "age > 7", "6.60", "true", "gooVal1", "f2"}, {"2", "desc", "66", "39", "bob", "age * 0.3", "age > 7", "6.60", "", "gooVal1", "whee"}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("from row number") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rating == ( age * 0.2 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("f2 : Driver( eval( age > 7 ))") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rating == ( age * 0.3 )") > drl.indexOf("rating == ( age * 0.2 )") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("f1.setGoo2( \"whee\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("salience 66") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAttribs() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new Object[]{"1", "desc", "a", null};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        ArrayList<AttributeCol52> attributeCols = new ArrayList<AttributeCol52>();
        RuleModel rm = new RuleModel();
        RuleAttribute[] orig = rm.attributes;
        p.doAttribs(allColumns, attributeCols, DataUtilities.makeDataRowList((Object[])row), rm);
        Assert.assertSame((Object)orig, (Object)rm.attributes);
        AttributeCol52 col1 = new AttributeCol52();
        col1.setAttribute("salience");
        AttributeCol52 col2 = new AttributeCol52();
        col2.setAttribute("agenda-group");
        attributeCols.add(col1);
        attributeCols.add(col2);
        allColumns.addAll(attributeCols);
        p.doAttribs(allColumns, attributeCols, DataUtilities.makeDataRowList((Object[])row), rm);
        Assert.assertEquals((long)1L, (long)rm.attributes.length);
        Assert.assertEquals((Object)"salience", (Object)rm.attributes[0].getAttributeName());
        Assert.assertEquals((Object)"a", (Object)rm.attributes[0].getValue());
        row = new Object[]{"1", "desc", 1L, "b"};
        p.doAttribs(allColumns, attributeCols, DataUtilities.makeDataRowList((Object[])row), rm);
        Assert.assertEquals((long)2L, (long)rm.attributes.length);
        Assert.assertEquals((Object)"salience", (Object)rm.attributes[0].getAttributeName());
        Assert.assertEquals((Object)"1", (Object)rm.attributes[0].getValue());
        Assert.assertEquals((Object)"agenda-group", (Object)rm.attributes[1].getAttributeName());
        Assert.assertEquals((Object)"b", (Object)rm.attributes[1].getValue());
    }

    @Test
    public void testCellCSV() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Assert.assertEquals((Object)"(\"Michael\", \"Mark\", \"Peter\")", (Object)p.makeInList("Michael, Mark, Peter"));
        Assert.assertEquals((Object)"(\"Michael\")", (Object)p.makeInList("Michael"));
        Assert.assertEquals((Object)"(\"Michael\")", (Object)p.makeInList("\"Michael\""));
        Assert.assertEquals((Object)"(\"Michael\", \"Ma rk\", \"Peter\")", (Object)p.makeInList("Michael, \"Ma rk\", Peter"));
        Assert.assertEquals((Object)"(WEE WAAH)", (Object)p.makeInList("(WEE WAAH)"));
    }

    @Test
    public void testConditionAndActionCellValue() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Assert.assertFalse((boolean)p.validCell(null, DataType.DataTypes.NUMERIC));
        Assert.assertFalse((boolean)p.validCell("", DataType.DataTypes.NUMERIC));
        Assert.assertFalse((boolean)p.validCell("  ", DataType.DataTypes.NUMERIC));
        Assert.assertFalse((boolean)p.validCell(null, DataType.DataTypes.STRING));
        Assert.assertFalse((boolean)p.validCell("", DataType.DataTypes.STRING));
        Assert.assertFalse((boolean)p.validCell("  ", DataType.DataTypes.STRING));
    }

    @Test
    public void testAttributeCellValue() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Assert.assertFalse((boolean)p.validateAttributeCell(null));
        Assert.assertFalse((boolean)p.validateAttributeCell(""));
        Assert.assertFalse((boolean)p.validateAttributeCell("  "));
    }

    @Test
    public void testMetadataCellValue() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Assert.assertFalse((boolean)p.validateMetadataCell(null));
        Assert.assertFalse((boolean)p.validateMetadataCell(""));
        Assert.assertFalse((boolean)p.validateMetadataCell("  "));
    }

    @Test
    public void testInOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableName("michael");
        AttributeCol52 attr = new AttributeCol52();
        attr.setAttribute("salience");
        attr.setDefaultValue(new DTCellValue52("66"));
        dt.getAttributeCols().add(attr);
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("f1");
        p1.setFactType("Driver");
        ConditionCol52 con = new ConditionCol52();
        con.setConstraintValueType(1);
        con.setFactField("age");
        con.setHeader("Driver f1 age");
        con.setOperator("==");
        p1.getChildColumns().add(con);
        ConditionCol52 con2 = new ConditionCol52();
        con2.setConstraintValueType(1);
        con2.setFactField("name");
        con2.setHeader("Driver f1 name");
        con2.setOperator("in");
        p1.getChildColumns().add(con2);
        ConditionCol52 con3 = new ConditionCol52();
        con3.setConstraintValueType(3);
        con3.setFactField("rating");
        con3.setHeader("Driver rating");
        con3.setOperator("==");
        p1.getChildColumns().add(con3);
        ConditionCol52 con4 = new ConditionCol52();
        con4.setConstraintValueType(5);
        con4.setHeader("Driver 2 pimp");
        con4.setFactField("(not needed)");
        p1.getChildColumns().add(con4);
        dt.getConditions().add(p1);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("ins");
        ins.setFactType("Cheese");
        ins.setFactField("price");
        ins.setType("Integer");
        dt.getActionCols().add(ins);
        ActionRetractFactCol52 ret = new ActionRetractFactCol52();
        dt.getActionCols().add(ret);
        ActionSetFieldCol52 set = new ActionSetFieldCol52();
        set.setBoundName("f1");
        set.setFactField("goo1");
        set.setType("String");
        dt.getActionCols().add(set);
        ActionSetFieldCol52 set2 = new ActionSetFieldCol52();
        set2.setBoundName("f1");
        set2.setFactField("goo2");
        set2.setDefaultValue(new DTCellValue52("whee"));
        set2.setType("String");
        dt.getActionCols().add(set2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "42", "33", "michael, manik", "age * 0.2", "age > 7", "6.60", "true", "gooVal1", "f2"}, {"2", "desc", "", "39", "bob, frank", "age * 0.3", "age > 7", "6.60", "", "gooVal1", null}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("name in ( \"michael\",") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInterpolate() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableName("michael");
        AttributeCol52 attr = new AttributeCol52();
        attr.setAttribute("salience");
        attr.setDefaultValue(new DTCellValue52("66"));
        dt.getAttributeCols().add(attr);
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("f1");
        p1.setFactType("Driver");
        ConditionCol52 con = new ConditionCol52();
        con.setConstraintValueType(1);
        con.setFactField("age");
        con.setHeader("Driver f1 age");
        con.setOperator("==");
        p1.getChildColumns().add(con);
        ConditionCol52 con2 = new ConditionCol52();
        con2.setConstraintValueType(1);
        con2.setFactField("name");
        con2.setHeader("Driver f1 name");
        con2.setOperator("==");
        p1.getChildColumns().add(con2);
        ConditionCol52 con3 = new ConditionCol52();
        con3.setConstraintValueType(3);
        con3.setFactField("rating");
        con3.setHeader("Driver rating");
        con3.setOperator("==");
        p1.getChildColumns().add(con3);
        dt.getConditions().add(p1);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("f2");
        p2.setFactType("Driver");
        ConditionCol52 con4 = new ConditionCol52();
        con4.setConstraintValueType(5);
        con4.setHeader("Driver 2 pimp");
        con4.setFactField("this.hasSomething($param)");
        p2.getChildColumns().add(con4);
        dt.getConditions().add(p2);
        ActionInsertFactCol52 ins = new ActionInsertFactCol52();
        ins.setBoundName("ins");
        ins.setFactType("Cheese");
        ins.setFactField("price");
        ins.setType("Integer");
        dt.getActionCols().add(ins);
        ActionRetractFactCol52 ret = new ActionRetractFactCol52();
        dt.getActionCols().add(ret);
        ActionSetFieldCol52 set = new ActionSetFieldCol52();
        set.setBoundName("f1");
        set.setFactField("goo1");
        set.setType("String");
        dt.getActionCols().add(set);
        ActionSetFieldCol52 set2 = new ActionSetFieldCol52();
        set2.setBoundName("f1");
        set2.setFactField("goo2");
        set2.setDefaultValue(new DTCellValue52("whee"));
        set2.setType("String");
        dt.getActionCols().add(set2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "42", "33", "michael", "age * 0.2", "BAM", "6.60", "true", "gooVal1", "f2"}, {"2", "desc", "66", "39", "bob", "age * 0.3", "BAM", "6.60", "", "gooVal1", "whee"}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("from row number") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rating == ( age * 0.2 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("f2 : Driver( eval( this.hasSomething(BAM) ))") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("rating == ( age * 0.3 )") > drl.indexOf("rating == ( age * 0.2 )") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("f1.setGoo2( \"whee\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("salience 66") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHS() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "a", "mike", "33 + 1", "age > 6", "stilton"};
        Object[][] data = new String[][]{row};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        allColumns.add(new MetadataCol52());
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 col = new ConditionCol52();
        col.setFactField("name");
        col.setConstraintValueType(1);
        col.setOperator("==");
        p1.getChildColumns().add(col);
        allColumns.add(col);
        ConditionCol52 col2 = new ConditionCol52();
        col2.setFactField("age");
        col2.setConstraintValueType(3);
        col2.setOperator("<");
        p1.getChildColumns().add(col2);
        allColumns.add(col2);
        ConditionCol52 col3 = new ConditionCol52();
        col3.setConstraintValueType(5);
        p1.getChildColumns().add(col3);
        allColumns.add(col3);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("c");
        p2.setFactType("Cheese");
        allPatterns.add(p2);
        ConditionCol52 col4 = new ConditionCol52();
        col4.setFactField("type");
        col4.setOperator("==");
        col4.setConstraintValueType(1);
        p2.getChildColumns().add(col4);
        allColumns.add(col4);
        RuleModel rm = new RuleModel();
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider, rowData, DataUtilities.makeDataLists((Object[][])data), rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Cheese", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"c", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        FactPattern person = (FactPattern)rm.lhs[0];
        Assert.assertEquals((long)3L, (long)person.getConstraintList().getConstraints().length);
        SingleFieldConstraint cons = (SingleFieldConstraint)person.getConstraint(0);
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"mike", (Object)cons.getValue());
        cons = (SingleFieldConstraint)person.getConstraint(1);
        Assert.assertEquals((long)3L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"<", (Object)cons.getOperator());
        Assert.assertEquals((Object)"33 + 1", (Object)cons.getValue());
        cons = (SingleFieldConstraint)person.getConstraint(2);
        Assert.assertEquals((long)5L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age > 6", (Object)cons.getValue());
        FactPattern cheese = (FactPattern)rm.lhs[1];
        Assert.assertEquals((long)1L, (long)cheese.getConstraintList().getConstraints().length);
        cons = (SingleFieldConstraint)cheese.getConstraint(0);
        Assert.assertEquals((Object)"type", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"stilton", (Object)cons.getValue());
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
    }

    @Test
    public void testLHSBindings() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "mike", "33 + 1", "age > 6"};
        Object[][] data = new String[][]{row};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 col = new ConditionCol52();
        col.setFactField("name");
        col.setConstraintValueType(1);
        col.setOperator("==");
        col.setBinding("$name");
        p1.getChildColumns().add(col);
        allColumns.add(col);
        ConditionCol52 col2 = new ConditionCol52();
        col2.setFactField("age");
        col2.setConstraintValueType(3);
        col2.setOperator("<");
        col2.setBinding("$name");
        p1.getChildColumns().add(col2);
        allColumns.add(col2);
        ConditionCol52 col3 = new ConditionCol52();
        col3.setConstraintValueType(5);
        col3.setBinding("$name");
        p1.getChildColumns().add(col3);
        allColumns.add(col3);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        RuleModel rm = new RuleModel();
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider, rowData, DataUtilities.makeDataLists((Object[][])data), rm);
        Assert.assertEquals((long)1L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        FactPattern person = (FactPattern)rm.lhs[0];
        Assert.assertEquals((long)3L, (long)person.getConstraintList().getConstraints().length);
        SingleFieldConstraint cons = (SingleFieldConstraint)person.getConstraint(0);
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"mike", (Object)cons.getValue());
        Assert.assertEquals((Object)"$name", (Object)cons.getFieldBinding());
        cons = (SingleFieldConstraint)person.getConstraint(1);
        Assert.assertEquals((long)3L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"<", (Object)cons.getOperator());
        Assert.assertEquals((Object)"33 + 1", (Object)cons.getValue());
        Assert.assertNull((Object)cons.getFieldBinding());
        cons = (SingleFieldConstraint)person.getConstraint(2);
        Assert.assertEquals((long)5L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age > 6", (Object)cons.getValue());
        Assert.assertNull((Object)cons.getFieldBinding());
    }

    @Test
    public void testLHSNotPattern() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "a", "mike", "33 + 1", "age > 6", "stilton"};
        Object[][] data = new String[][]{row};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        allColumns.add(new MetadataCol52());
        Pattern52 p1 = new Pattern52();
        p1.setNegated(true);
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 col = new ConditionCol52();
        col.setFactField("name");
        col.setConstraintValueType(1);
        col.setOperator("==");
        p1.getChildColumns().add(col);
        allColumns.add(col);
        ConditionCol52 col2 = new ConditionCol52();
        col2.setFactField("age");
        col2.setConstraintValueType(3);
        col2.setOperator("<");
        p1.getChildColumns().add(col2);
        allColumns.add(col2);
        ConditionCol52 col3 = new ConditionCol52();
        col3.setConstraintValueType(5);
        p1.getChildColumns().add(col3);
        allColumns.add(col3);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("c");
        p2.setFactType("Cheese");
        allPatterns.add(p2);
        ConditionCol52 col4 = new ConditionCol52();
        col4.setFactField("type");
        col4.setOperator("==");
        col4.setConstraintValueType(1);
        p2.getChildColumns().add(col4);
        allColumns.add(col4);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        RuleModel rm = new RuleModel();
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider, rowData, DataUtilities.makeDataLists((Object[][])data), rm);
        String drl = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Cheese", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"c", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        FactPattern person = (FactPattern)rm.lhs[0];
        Assert.assertEquals((long)3L, (long)person.getConstraintList().getConstraints().length);
        SingleFieldConstraint cons = (SingleFieldConstraint)person.getConstraint(0);
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"mike", (Object)cons.getValue());
        cons = (SingleFieldConstraint)person.getConstraint(1);
        Assert.assertEquals((long)3L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"<", (Object)cons.getOperator());
        Assert.assertEquals((Object)"33 + 1", (Object)cons.getValue());
        cons = (SingleFieldConstraint)person.getConstraint(2);
        Assert.assertEquals((long)5L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)"age > 6", (Object)cons.getValue());
        Assert.assertEquals((Object)person.isNegated(), (Object)true);
        Assert.assertTrue((drl.indexOf("not Person(") > 0 ? 1 : 0) != 0);
        FactPattern cheese = (FactPattern)rm.lhs[1];
        Assert.assertEquals((long)1L, (long)cheese.getConstraintList().getConstraints().length);
        cons = (SingleFieldConstraint)cheese.getConstraint(0);
        Assert.assertEquals((Object)"type", (Object)cons.getFieldName());
        Assert.assertEquals((Object)"==", (Object)cons.getOperator());
        Assert.assertEquals((Object)"stilton", (Object)cons.getValue());
        Assert.assertEquals((long)1L, (long)cons.getConstraintValueType());
        Assert.assertEquals((Object)cheese.isNegated(), (Object)false);
        Assert.assertTrue((drl.indexOf("c : Cheese(") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void multipleLHSNotPatternInclusion() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new Object[]{"1", "desc", "mike", true, true};
        Object[][] data = new Object[][]{row};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 p1col = new ConditionCol52();
        p1col.setFactField("name");
        p1col.setConstraintValueType(1);
        p1col.setOperator("==");
        p1.getChildColumns().add(p1col);
        allColumns.add(p1col);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("");
        p2.setNegated(true);
        p2.setFactType("Cheese");
        allPatterns.add(p2);
        ConditionCol52 p2col = new ConditionCol52();
        p2col.setFactField("this");
        p2col.setOperator("");
        p2col.setConstraintValueType(1);
        p2.getChildColumns().add(p2col);
        allColumns.add(p2col);
        Pattern52 p3 = new Pattern52();
        p3.setBoundName("");
        p3.setNegated(true);
        p3.setFactType("Smurf");
        allPatterns.add(p3);
        ConditionCol52 p3col = new ConditionCol52();
        p3col.setFactField("this");
        p3col.setOperator("!= null");
        p3col.setConstraintValueType(1);
        p3.getChildColumns().add(p3col);
        allColumns.add(p3col);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        RuleModel rm = new RuleModel();
        rm.name = "r0";
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider, rowData, DataUtilities.makeDataLists((Object[][])data), rm);
        String actualRuleModelDrl = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        String expectedRuleModelDrl = "rule \"r0\"\n  dialect \"mvel\"\n  when\n    p1 : Person( name == \"mike\" )\n    not Cheese()\n    not Smurf( this != null )\n  then\nend\n";
        this.assertEqualsIgnoreWhitespace("rule \"r0\"\n  dialect \"mvel\"\n  when\n    p1 : Person( name == \"mike\" )\n    not Cheese()\n    not Smurf( this != null )\n  then\nend\n", actualRuleModelDrl);
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableName("dt");
        dt.getConditions().add(p1);
        dt.getConditions().add(p2);
        dt.getConditions().add(p3);
        dt.getData().addAll(DataUtilities.makeDataLists((Object[][])data));
        String actualDecisionTableDrl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expectedDecisionTableDrl = "//from row number: 1\n//desc\nrule \"Row1dt\"\n  dialect \"mvel\"\n  when\n    p1 : Person( name == \"mike\" )\n    not Cheese()\n    not Smurf( this != null )\n  then\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row1dt\"\n  dialect \"mvel\"\n  when\n    p1 : Person( name == \"mike\" )\n    not Cheese()\n    not Smurf( this != null )\n  then\nend\n", actualDecisionTableDrl);
    }

    @Test
    public void testLHSOtherwisePatternBoolean() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] row = new String[2][];
        String[][] data = new String[2][];
        row[0] = new String[]{"1", "desc1", "true", "false"};
        final List rowDTModel0 = DataUtilities.makeDataRowList((Object[])row[0]);
        data[0] = row[0];
        row[1] = new String[]{"3", "desc3", null, null};
        final List rowDTModel1 = DataUtilities.makeDataRowList((Object[])row[1]);
        ((DTCellValue52)rowDTModel1.get(2)).setOtherwise(true);
        ((DTCellValue52)rowDTModel1.get(3)).setOtherwise(true);
        data[1] = row[1];
        ArrayList<List<DTCellValue52>> allDTData = new ArrayList<List<DTCellValue52>>(){
            {
                this.add(rowDTModel0);
                this.add(rowDTModel1);
            }
        };
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 col = new ConditionCol52();
        col.setFactField("alive");
        col.setConstraintValueType(1);
        col.setFieldType("Boolean");
        col.setOperator("==");
        p1.getChildColumns().add(col);
        allColumns.add(col);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("p2");
        p2.setFactType("Person");
        allPatterns.add(p2);
        ConditionCol52 col2 = new ConditionCol52();
        col2.setFactField("alive");
        col2.setConstraintValueType(1);
        col2.setFieldType("Boolean");
        col2.setOperator("!=");
        p2.getChildColumns().add(col2);
        allColumns.add(col2);
        RuleModel rm = new RuleModel();
        GuidedDTTemplateDataProvider rowDataProvider0 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel0);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider0, rowDTModel0, (List)allDTData, rm);
        String drl0 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl0.indexOf("p1 : Person( alive == true )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl0.indexOf("p2 : Person( alive != false )") > 0 ? 1 : 0) != 0);
        GuidedDTTemplateDataProvider rowDataProvider1 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel1);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider1, rowDTModel1, (List)allDTData, rm);
        String drl1 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl1.indexOf("p1 : Person( alive not in ( true )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("p2 : Person( alive in ( false )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSOtherwisePatternDate() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] row = new String[3][];
        String[][] data = new String[3][];
        row[0] = new String[]{"1", "desc1", "01-Jan-1980", "20-Jun-1985"};
        final List rowDTModel0 = DataUtilities.makeDataRowList((Object[])row[0]);
        data[0] = row[0];
        row[1] = new String[]{"2", "desc2", "01-Feb-1981", "21-Jun-1986"};
        final List rowDTModel1 = DataUtilities.makeDataRowList((Object[])row[1]);
        data[1] = row[1];
        row[2] = new String[]{"3", "desc3", null, null};
        final List rowDTModel2 = DataUtilities.makeDataRowList((Object[])row[2]);
        ((DTCellValue52)rowDTModel2.get(2)).setOtherwise(true);
        ((DTCellValue52)rowDTModel2.get(3)).setOtherwise(true);
        data[2] = row[2];
        ArrayList<List<DTCellValue52>> allDTData = new ArrayList<List<DTCellValue52>>(){
            {
                this.add(rowDTModel0);
                this.add(rowDTModel1);
                this.add(rowDTModel2);
            }
        };
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 col = new ConditionCol52();
        col.setFactField("dateOfBirth");
        col.setConstraintValueType(1);
        col.setFieldType("Date");
        col.setOperator("==");
        p1.getChildColumns().add(col);
        allColumns.add(col);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("p2");
        p2.setFactType("Person");
        allPatterns.add(p2);
        ConditionCol52 col2 = new ConditionCol52();
        col2.setFactField("dateOfBirth");
        col2.setConstraintValueType(1);
        col2.setFieldType("Date");
        col2.setOperator("!=");
        p2.getChildColumns().add(col2);
        allColumns.add(col2);
        RuleModel rm = new RuleModel();
        GuidedDTTemplateDataProvider rowDataProvider0 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel0);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider0, rowDTModel0, (List)allDTData, rm);
        String drl0 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl0.indexOf("p1 : Person( dateOfBirth == \"01-Jan-1980\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl0.indexOf("p2 : Person( dateOfBirth != \"20-Jun-1985\" )") > 0 ? 1 : 0) != 0);
        GuidedDTTemplateDataProvider rowDataProvider1 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel1);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider1, rowDTModel1, (List)allDTData, rm);
        String drl1 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl1.indexOf("p1 : Person( dateOfBirth == \"01-Feb-1981\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("p2 : Person( dateOfBirth != \"21-Jun-1986\" )") > 0 ? 1 : 0) != 0);
        GuidedDTTemplateDataProvider rowDataProvider2 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel2);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider2, rowDTModel2, (List)allDTData, rm);
        String drl2 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl2.indexOf("p1 : Person( dateOfBirth not in ( \"01-Jan-1980\", \"01-Feb-1981\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("p2 : Person( dateOfBirth in ( \"20-Jun-1985\", \"21-Jun-1986\" )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSOtherwisePatternNumeric() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] row = new String[3][];
        String[][] data = new String[3][];
        row[0] = new String[]{"1", "desc1", "1", "1"};
        final List rowDTModel0 = DataUtilities.makeDataRowList((Object[])row[0]);
        data[0] = row[0];
        row[1] = new String[]{"2", "desc2", "2", "2"};
        final List rowDTModel1 = DataUtilities.makeDataRowList((Object[])row[1]);
        data[1] = row[1];
        row[2] = new String[]{"3", "desc3", null, null};
        final List rowDTModel2 = DataUtilities.makeDataRowList((Object[])row[2]);
        ((DTCellValue52)rowDTModel2.get(2)).setOtherwise(true);
        ((DTCellValue52)rowDTModel2.get(3)).setOtherwise(true);
        data[2] = row[2];
        ArrayList<List<DTCellValue52>> allDTData = new ArrayList<List<DTCellValue52>>(){
            {
                this.add(rowDTModel0);
                this.add(rowDTModel1);
                this.add(rowDTModel2);
            }
        };
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 col = new ConditionCol52();
        col.setFactField("age");
        col.setConstraintValueType(1);
        col.setFieldType("Integer");
        col.setOperator("==");
        p1.getChildColumns().add(col);
        allColumns.add(col);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("p2");
        p2.setFactType("Person");
        allPatterns.add(p2);
        ConditionCol52 col2 = new ConditionCol52();
        col2.setFactField("age");
        col2.setConstraintValueType(1);
        col2.setFieldType("Integer");
        col2.setOperator("!=");
        p2.getChildColumns().add(col2);
        allColumns.add(col2);
        RuleModel rm = new RuleModel();
        GuidedDTTemplateDataProvider rowDataProvider0 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel0);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider0, rowDTModel0, (List)allDTData, rm);
        String drl0 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl0.indexOf("p1 : Person( age == 1 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl0.indexOf("p2 : Person( age != 1 )") > 0 ? 1 : 0) != 0);
        GuidedDTTemplateDataProvider rowDataProvider1 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel1);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider1, rowDTModel1, (List)allDTData, rm);
        String drl1 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl1.indexOf("p1 : Person( age == 2 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("p2 : Person( age != 2 )") > 0 ? 1 : 0) != 0);
        GuidedDTTemplateDataProvider rowDataProvider2 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel2);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider2, rowDTModel2, (List)allDTData, rm);
        String drl2 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl2.indexOf("p1 : Person( age not in ( 1, 2 )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("p2 : Person( age in ( 1, 2 )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSOtherwisePatternString() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] row = new String[3][];
        String[][] data = new String[3][];
        row[0] = new String[]{"1", "desc1", "Michael1", "Michael1"};
        final List rowDTModel0 = DataUtilities.makeDataRowList((Object[])row[0]);
        data[0] = row[0];
        row[1] = new String[]{"2", "desc2", "Michael2", "Michael2"};
        final List rowDTModel1 = DataUtilities.makeDataRowList((Object[])row[1]);
        data[1] = row[1];
        row[2] = new String[]{"3", "desc3", "", ""};
        final List rowDTModel2 = DataUtilities.makeDataRowList((Object[])row[2]);
        ((DTCellValue52)rowDTModel2.get(2)).setOtherwise(true);
        ((DTCellValue52)rowDTModel2.get(3)).setOtherwise(true);
        data[2] = row[2];
        ArrayList<List<DTCellValue52>> allDTData = new ArrayList<List<DTCellValue52>>(){
            {
                this.add(rowDTModel0);
                this.add(rowDTModel1);
                this.add(rowDTModel2);
            }
        };
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 col = new ConditionCol52();
        col.setFactField("name");
        col.setConstraintValueType(1);
        col.setFieldType("String");
        col.setOperator("==");
        p1.getChildColumns().add(col);
        allColumns.add(col);
        Pattern52 p2 = new Pattern52();
        p2.setBoundName("p2");
        p2.setFactType("Person");
        allPatterns.add(p2);
        ConditionCol52 col2 = new ConditionCol52();
        col2.setFactField("name");
        col2.setConstraintValueType(1);
        col2.setFieldType("String");
        col2.setOperator("!=");
        p2.getChildColumns().add(col2);
        allColumns.add(col2);
        RuleModel rm = new RuleModel();
        GuidedDTTemplateDataProvider rowDataProvider0 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel0);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider0, rowDTModel0, (List)allDTData, rm);
        String drl0 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl0.indexOf("p1 : Person( name == \"Michael1\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl0.indexOf("p2 : Person( name != \"Michael1\" )") > 0 ? 1 : 0) != 0);
        GuidedDTTemplateDataProvider rowDataProvider1 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel1);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider1, rowDTModel1, (List)allDTData, rm);
        String drl1 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl1.indexOf("p1 : Person( name == \"Michael2\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl1.indexOf("p2 : Person( name != \"Michael2\" )") > 0 ? 1 : 0) != 0);
        GuidedDTTemplateDataProvider rowDataProvider2 = new GuidedDTTemplateDataProvider(allColumns, rowDTModel2);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider2, rowDTModel2, (List)allDTData, rm);
        String drl2 = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"p1", (Object)((FactPattern)rm.lhs[0]).getBoundName());
        Assert.assertEquals((Object)"Person", (Object)((FactPattern)rm.lhs[1]).getFactType());
        Assert.assertEquals((Object)"p2", (Object)((FactPattern)rm.lhs[1]).getBoundName());
        Assert.assertTrue((drl2.indexOf("p1 : Person( name not in ( \"Michael1\", \"Michael2\" )") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl2.indexOf("p2 : Person( name in ( \"Michael1\", \"Michael2\" )") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaData() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "bar", ""};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        ArrayList<MetadataCol52> metadataCols = new ArrayList<MetadataCol52>();
        RuleModel rm = new RuleModel();
        RuleMetadata[] orig = rm.metadataList;
        p.doMetadata(allColumns, metadataCols, DataUtilities.makeDataRowList((Object[])row), rm);
        Assert.assertSame((Object)orig, (Object)rm.metadataList);
        MetadataCol52 col1 = new MetadataCol52();
        col1.setMetadata("foo");
        MetadataCol52 col2 = new MetadataCol52();
        col2.setMetadata("foo2");
        metadataCols.add(col1);
        metadataCols.add(col2);
        allColumns.addAll(metadataCols);
        p.doMetadata(allColumns, metadataCols, DataUtilities.makeDataRowList((Object[])row), rm);
        Assert.assertEquals((long)1L, (long)rm.metadataList.length);
        Assert.assertEquals((Object)"foo", (Object)rm.metadataList[0].getAttributeName());
        Assert.assertEquals((Object)"bar", (Object)rm.metadataList[0].getValue());
        row = new String[]{"1", "desc", "bar1", "bar2"};
        p.doMetadata(allColumns, metadataCols, DataUtilities.makeDataRowList((Object[])row), rm);
        Assert.assertEquals((long)2L, (long)rm.metadataList.length);
        Assert.assertEquals((Object)"foo", (Object)rm.metadataList[0].getAttributeName());
        Assert.assertEquals((Object)"bar1", (Object)rm.metadataList[0].getValue());
        Assert.assertEquals((Object)"foo2", (Object)rm.metadataList[1].getAttributeName());
        Assert.assertEquals((Object)"bar2", (Object)rm.metadataList[1].getValue());
    }

    @Test
    public void testName() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Assert.assertEquals((Object)"Row 42 XXX", (Object)p.getName("XXX", (Number)42));
        Assert.assertEquals((Object)"Row 42 YYY", (Object)p.getName("YYY", (Number)42));
    }

    @Test
    public void testNoConstraints() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("no-constraints");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        c.setFieldType("String");
        c.setFactField("name");
        c.setOperator("==");
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        ActionSetFieldCol52 asf = new ActionSetFieldCol52();
        asf.setBoundName("x");
        asf.setFactField("age");
        asf.setType("Integer");
        dt.getActionCols().add(asf);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", "Fred", 75L}}));
        String drl1 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected1 = "//from row number: 1\n//desc\nrule \"Row 1 no-constraints\"\n  dialect \"mvel\"\n  when\n    x : Context( name == \"Fred\" )\n  then\n    x.setAge( 75 );\nend";
        this.assertEqualsIgnoreWhitespace(expected1, drl1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", null, 75L}}));
        String drl2 = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected2 = "//from row number: 1\n//desc\nrule \"Row 1 no-constraints\"\n  dialect \"mvel\"\n  when\n  then\n    x.setAge( 75 );\nend";
        this.assertEqualsIgnoreWhitespace(expected2, drl2);
    }

    @Test
    public void testNoOperator() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "a", "> 42"};
        Object[][] data = new String[][]{row};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        ArrayList<Pattern52> allPatterns = new ArrayList<Pattern52>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        allColumns.add(new MetadataCol52());
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Person");
        allPatterns.add(p1);
        ConditionCol52 col1 = new ConditionCol52();
        col1.setFactField("age");
        col1.setConstraintValueType(1);
        col1.setOperator("");
        p1.getChildColumns().add(col1);
        allColumns.add(col1);
        RuleModel rm = new RuleModel();
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider, rowData, DataUtilities.makeDataLists((Object[][])data), rm);
        String drl = RuleModelDRLPersistenceImpl.getInstance().marshal(rm);
        Assert.assertTrue((drl.indexOf("age > \"42\"") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRHS() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "a", "a condition", "actionsetfield1", "actionupdatefield2", "retract", "actioninsertfact1", "actioninsertfact2"};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        allColumns.add(new MetadataCol52());
        allColumns.add(new ConditionCol52());
        ArrayList<Object> cols = new ArrayList<Object>();
        ActionSetFieldCol52 asf1 = new ActionSetFieldCol52();
        asf1.setBoundName("a");
        asf1.setFactField("field1");
        asf1.setType("String");
        cols.add(asf1);
        ActionSetFieldCol52 asf2 = new ActionSetFieldCol52();
        asf2.setBoundName("a");
        asf2.setFactField("field2");
        asf2.setUpdate(true);
        asf2.setType("Integer");
        cols.add(asf2);
        ActionRetractFactCol52 ret = new ActionRetractFactCol52();
        cols.add(ret);
        ActionInsertFactCol52 ins1 = new ActionInsertFactCol52();
        ins1.setBoundName("ins");
        ins1.setFactType("Cheese");
        ins1.setFactField("price");
        ins1.setType("Integer");
        cols.add(ins1);
        ActionInsertFactCol52 ins2 = new ActionInsertFactCol52();
        ins2.setBoundName("ins");
        ins2.setFactType("Cheese");
        ins2.setFactField("type");
        ins2.setType("Integer");
        cols.add(ins2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doActions(allColumns, cols, (TemplateDataProvider)rowDataProvider, rowData, rm);
        Assert.assertEquals((long)4L, (long)rm.rhs.length);
        ActionSetField a1 = (ActionSetField)rm.rhs[0];
        Assert.assertEquals((Object)"a", (Object)a1.getVariable());
        Assert.assertEquals((long)1L, (long)a1.getFieldValues().length);
        Assert.assertEquals((Object)"field1", (Object)a1.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"actionsetfield1", (Object)a1.getFieldValues()[0].getValue());
        Assert.assertEquals((Object)"String", (Object)a1.getFieldValues()[0].getType());
        ActionSetField a2 = (ActionSetField)rm.rhs[1];
        Assert.assertEquals((Object)"a", (Object)a2.getVariable());
        Assert.assertEquals((long)1L, (long)a2.getFieldValues().length);
        Assert.assertEquals((Object)"field2", (Object)a2.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"actionupdatefield2", (Object)a2.getFieldValues()[0].getValue());
        Assert.assertEquals((Object)"Integer", (Object)a2.getFieldValues()[0].getType());
        ActionRetractFact a3 = (ActionRetractFact)rm.rhs[2];
        Assert.assertEquals((Object)"retract", (Object)a3.getVariableName());
        ActionInsertFact a4 = (ActionInsertFact)rm.rhs[3];
        Assert.assertEquals((Object)"Cheese", (Object)a4.getFactType());
        Assert.assertEquals((long)2L, (long)a4.getFieldValues().length);
        Assert.assertEquals((Object)"price", (Object)a4.getFieldValues()[0].getField());
        Assert.assertEquals((Object)"actioninsertfact1", (Object)a4.getFieldValues()[0].getValue());
        Assert.assertEquals((Object)"Integer", (Object)a4.getFieldValues()[0].getType());
        Assert.assertEquals((Object)"type", (Object)a4.getFieldValues()[1].getField());
        Assert.assertEquals((Object)"actioninsertfact2", (Object)a4.getFieldValues()[1].getValue());
        Assert.assertEquals((Object)"Integer", (Object)a4.getFieldValues()[1].getType());
    }

    @Test
    public void testUpdateModifySingleField() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        ActionSetFieldCol52 asf = new ActionSetFieldCol52();
        asf.setBoundName("x");
        asf.setFactField("age");
        asf.setType("Integer");
        asf.setUpdate(true);
        dt.getActionCols().add(asf);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", "y", "old"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertTrue((drl.indexOf("Context( )") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("modify( x ) {") > drl.indexOf("Context( )") ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("setAge(") > drl.indexOf("modify( x ) {") ? 1 : 0) != 0);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", null, "old"}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertEquals((long)-1L, (long)drl.indexOf("Context( )"));
        Assert.assertTrue((drl.indexOf("modify( x ) {") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("setAge(") > drl.indexOf("modify( x ) {") ? 1 : 0) != 0);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", null, null}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertEquals((long)-1L, (long)drl.indexOf("Context( )"));
        Assert.assertEquals((long)-1L, (long)drl.indexOf("modify( x ) {"));
        Assert.assertEquals((long)-1L, (long)drl.indexOf("setAge("));
    }

    @Test
    public void testUpdateModifyMultipleFields() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        ActionSetFieldCol52 asf1 = new ActionSetFieldCol52();
        asf1.setBoundName("x");
        asf1.setFactField("age");
        asf1.setType("Integer");
        asf1.setUpdate(true);
        dt.getActionCols().add(asf1);
        ActionSetFieldCol52 asf2 = new ActionSetFieldCol52();
        asf2.setBoundName("x");
        asf2.setFactField("name");
        asf2.setType("String");
        asf2.setUpdate(true);
        dt.getActionCols().add(asf2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", "x", 55L, "Fred"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected1 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ), \n    setName( \"Fred\" )\n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ), \n    setName( \"Fred\" )\n}\nend\n", drl);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", "x", null, "Fred"}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected2 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setName( \"Fred\" )\n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setName( \"Fred\" )\n}\nend\n", drl);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", "x", 55L, null}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected3 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ) \n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ) \n}\nend\n", drl);
    }

    @Test
    public void testUpdateModifyMultipleFieldsUpdateOneModifyTheOther() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("x");
        p1.setFactType("Context");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        ActionSetFieldCol52 asf1 = new ActionSetFieldCol52();
        asf1.setBoundName("x");
        asf1.setFactField("age");
        asf1.setType("Integer");
        asf1.setUpdate(true);
        dt.getActionCols().add(asf1);
        ActionSetFieldCol52 asf2 = new ActionSetFieldCol52();
        asf2.setBoundName("x");
        asf2.setFactField("name");
        asf2.setType("String");
        asf2.setUpdate(false);
        dt.getActionCols().add(asf2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", "x", 55L, "Fred"}}));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected1 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ) \n}\nx.setName( \"Fred\" );\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ) \n}\nx.setName( \"Fred\" );\nend\n", drl);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", "x", null, "Fred"}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected2 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\nx.setName( \"Fred\" );\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\nx.setName( \"Fred\" );\nend\n", drl);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{"1", "desc", "x", 55L, ""}}));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        String expected3 = "//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ) \n}\nend\n";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc\nrule \"Row 1 null\"\ndialect \"mvel\"\nwhen\n  x : Context( )\nthen\n  modify( x ) {\n    setAge( 55 ) \n}\nend\n", drl);
    }

    @Test
    public void testDefaultValue() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("$c");
        p1.setFactType("CheeseLover");
        ConditionCol52 c = new ConditionCol52();
        c.setConstraintValueType(1);
        c.setFactField("favouriteCheese");
        c.setDefaultValue(new DTCellValue52("cheddar"));
        c.setOperator("==");
        p1.getChildColumns().add(c);
        dt.getConditions().add(p1);
        Object[][] data = new String[][]{{"1", "desc", "edam"}};
        dt.setData(DataUtilities.makeDataLists((Object[][])data));
        String drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertFalse((drl.indexOf("$c : CheeseLover( favouriteCheese == \"edam\" )") == -1 ? 1 : 0) != 0);
        data = new String[][]{{"1", "desc", null}};
        dt.setData(DataUtilities.makeDataLists((Object[][])data));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertTrue((drl.indexOf("$c : CheeseLover( favouriteCheese == \"cheddar\" )") == -1 ? 1 : 0) != 0);
        data = new String[][]{{"1", "desc", ""}};
        dt.setData(DataUtilities.makeDataLists((Object[][])data));
        drl = GuidedDTDRLPersistence.getInstance().marshal(dt);
        Assert.assertTrue((drl.indexOf("$c : CheeseLover( favouriteCheese == \"cheddar\" )") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryAttributes() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        AttributeCol52 attr = new AttributeCol52();
        attr.setAttribute("salience");
        dt.getAttributeCols().add(attr);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "100"}, {"2", "desc", "200"}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("salience 100") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("salience 200") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryMetadata() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        MetadataCol52 md = new MetadataCol52();
        md.setMetadata("metadata");
        dt.getMetadataCols().add(md);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "md1"}, {"2", "desc", "md2"}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("@metadata(md1)") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("@metadata(md2)") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryConditionsNoConstraints() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setValue(new DTCellValue52("y"));
        p1.getChildColumns().add(cc1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true}, {2L, "desc", false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryConditionsConstraints1() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("==");
        cc1.setValue(new DTCellValue52("Pupa"));
        p1.getChildColumns().add(cc1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true}, {2L, "desc", false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name == \"Pupa\" )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( name == \"Pupa\" )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryConditionsConstraints2() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("==");
        cc1.setValue(new DTCellValue52("Pupa"));
        p1.getChildColumns().add(cc1);
        LimitedEntryConditionCol52 cc2 = new LimitedEntryConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("String");
        cc2.setFactField("name");
        cc2.setOperator("==");
        cc2.setValue(new DTCellValue52("Smurfette"));
        p1.getChildColumns().add(cc2);
        LimitedEntryConditionCol52 cc3 = new LimitedEntryConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("String");
        cc3.setFactField("colour");
        cc3.setOperator("==");
        cc3.setValue(new DTCellValue52("Blue"));
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, false, true}, {2L, "desc", false, true, true}, {3L, "desc", false, false, true}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name == \"Pupa\" , colour == \"Blue\" )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( name == \"Smurfette\" , colour == \"Blue\" )", index + 1);
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( colour == \"Blue\" )", index + 1);
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryActionSet() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("Boolean");
        cc1.setFactField("isSmurf");
        cc1.setOperator("==");
        cc1.setValue(new DTCellValue52("true"));
        p1.getChildColumns().add(cc1);
        LimitedEntryActionSetFieldCol52 asf1 = new LimitedEntryActionSetFieldCol52();
        asf1.setBoundName("p1");
        asf1.setFactField("colour");
        asf1.setValue(new DTCellValue52("Blue"));
        dt.getActionCols().add(asf1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true}, {2L, "desc", true, false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( isSmurf == true )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("p1.setColour( \"Blue\" )", index + 1);
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( isSmurf == true )", index + 1);
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("p1.setColour( \"Blue\" )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryActionInsert() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryActionInsertFactCol52 asf1 = new LimitedEntryActionInsertFactCol52();
        asf1.setFactType("Smurf");
        asf1.setBoundName("s1");
        asf1.setFactField("colour");
        asf1.setValue(new DTCellValue52("Blue"));
        dt.getActionCols().add(asf1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true}, {2L, "desc", false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf s1 = new Smurf();");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("s1.setColour( \"Blue\" );", index + 1);
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("insert( s1 );", index + 1);
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        int indexRule2 = index;
        indexRule2 = drl.indexOf("Smurf s1 = new Smurf();", index + 1);
        Assert.assertFalse((indexRule2 > -1 ? 1 : 0) != 0);
        indexRule2 = drl.indexOf("s1.setColour( \"Blue\" );", index + 1);
        Assert.assertFalse((indexRule2 > -1 ? 1 : 0) != 0);
        indexRule2 = drl.indexOf("insert(s1 );", index + 1);
        Assert.assertFalse((indexRule2 > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSIsNullOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        ConditionCol52 cc1 = new ConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("== null");
        p1.getChildColumns().add(cc1);
        ConditionCol52 cc2 = new ConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("== null");
        p1.getChildColumns().add(cc2);
        ConditionCol52 cc3 = new ConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("Date");
        cc3.setFactField("dateOfBirth");
        cc3.setOperator("== null");
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true, true}, {2L, "desc", false, false, false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name == null , age == null , dateOfBirth == null )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSIsNullOperatorWithNullValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        ConditionCol52 cc1 = new ConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("== null");
        p1.getChildColumns().add(cc1);
        ConditionCol52 cc2 = new ConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("== null");
        p1.getChildColumns().add(cc2);
        ConditionCol52 cc3 = new ConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("Date");
        cc3.setFactField("dateOfBirth");
        cc3.setOperator("== null");
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true, true}, {2L, "desc", null, null, null}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name == null , age == null , dateOfBirth == null )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSIsNotNullOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        ConditionCol52 cc1 = new ConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("!= null");
        p1.getChildColumns().add(cc1);
        ConditionCol52 cc2 = new ConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("!= null");
        p1.getChildColumns().add(cc2);
        ConditionCol52 cc3 = new ConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("Date");
        cc3.setFactField("dateOfBirth");
        cc3.setOperator("!= null");
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true, true}, {2L, "desc", false, false, false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name != null , age != null , dateOfBirth != null )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSIsNotNullOperatorWithNullValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        ConditionCol52 cc1 = new ConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("!= null");
        p1.getChildColumns().add(cc1);
        ConditionCol52 cc2 = new ConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("!= null");
        p1.getChildColumns().add(cc2);
        ConditionCol52 cc3 = new ConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("Date");
        cc3.setFactField("dateOfBirth");
        cc3.setOperator("!= null");
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true, true}, {2L, "desc", null, null, null}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name != null , age != null , dateOfBirth != null )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryLHSIsNullOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("== null");
        p1.getChildColumns().add(cc1);
        LimitedEntryConditionCol52 cc2 = new LimitedEntryConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("== null");
        p1.getChildColumns().add(cc2);
        LimitedEntryConditionCol52 cc3 = new LimitedEntryConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("Date");
        cc3.setFactField("dateOfBirth");
        cc3.setOperator("== null");
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true, true}, {2L, "desc", false, false, false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name == null , age == null , dateOfBirth == null )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryLHSIsNullOperatorWithNullValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("== null");
        p1.getChildColumns().add(cc1);
        LimitedEntryConditionCol52 cc2 = new LimitedEntryConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("== null");
        p1.getChildColumns().add(cc2);
        LimitedEntryConditionCol52 cc3 = new LimitedEntryConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("Date");
        cc3.setFactField("dateOfBirth");
        cc3.setOperator("== null");
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true, true}, {2L, "desc", null, null, null}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name == null , age == null , dateOfBirth == null )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryLHSIsNotNullOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("!= null");
        p1.getChildColumns().add(cc1);
        LimitedEntryConditionCol52 cc2 = new LimitedEntryConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("!= null");
        p1.getChildColumns().add(cc2);
        LimitedEntryConditionCol52 cc3 = new LimitedEntryConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("Date");
        cc3.setFactField("dateOfBirth");
        cc3.setOperator("!= null");
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true, true}, {2L, "desc", false, false, false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name != null , age != null , dateOfBirth != null )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryLHSIsNotNullOperatorWithNullValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("!= null");
        p1.getChildColumns().add(cc1);
        LimitedEntryConditionCol52 cc2 = new LimitedEntryConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("!= null");
        p1.getChildColumns().add(cc2);
        LimitedEntryConditionCol52 cc3 = new LimitedEntryConditionCol52();
        cc3.setConstraintValueType(1);
        cc3.setFieldType("Date");
        cc3.setFactField("dateOfBirth");
        cc3.setOperator("!= null");
        p1.getChildColumns().add(cc3);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true, true}, {2L, "desc", null, null, null}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name != null , age != null , dateOfBirth != null )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSInOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        ConditionCol52 cc1 = new ConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("in");
        p1.getChildColumns().add(cc1);
        ConditionCol52 cc2 = new ConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("in");
        p1.getChildColumns().add(cc2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", "Pupa, Brains", "55, 66"}, {2L, "desc", "", ""}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name in ( \"Pupa\", \"Brains\" ) , age in ( 55, 66 ) )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSNotInOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        ConditionCol52 cc1 = new ConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("not in");
        p1.getChildColumns().add(cc1);
        ConditionCol52 cc2 = new ConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("not in");
        p1.getChildColumns().add(cc2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", "Pupa, Brains", "55, 66"}, {2L, "desc", "", ""}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name not in ( \"Pupa\", \"Brains\" ) , age not in ( 55, 66 ) )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryLHSInOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("in");
        cc1.setValue(new DTCellValue52("Pupa, Brains"));
        p1.getChildColumns().add(cc1);
        LimitedEntryConditionCol52 cc2 = new LimitedEntryConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("in");
        cc2.setValue(new DTCellValue52("55, 66"));
        p1.getChildColumns().add(cc2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true}, {2L, "desc", false, false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name in ( \"Pupa\", \"Brains\" ) , age in ( 55, 66 ) )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLimitedEntryLHSNotInOperator() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.LIMITED_ENTRY);
        dt.setTableName("limited-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        LimitedEntryConditionCol52 cc1 = new LimitedEntryConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("not in");
        cc1.setValue(new DTCellValue52("Pupa, Brains"));
        p1.getChildColumns().add(cc1);
        LimitedEntryConditionCol52 cc2 = new LimitedEntryConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("not in");
        cc2.setValue(new DTCellValue52("55, 66"));
        p1.getChildColumns().add(cc2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc", true, true}, {2L, "desc", false, false}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        int index = -1;
        index = drl.indexOf("Smurf( name not in ( \"Pupa\", \"Brains\" ) , age not in ( 55, 66 ) )");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = drl.indexOf("Smurf( )", index + 1);
        Assert.assertFalse((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSExecuteWorkItem() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "true"};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        ArrayList<ActionWorkItemCol52> cols = new ArrayList<ActionWorkItemCol52>();
        ActionWorkItemCol52 awi = new ActionWorkItemCol52();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("work-item");
        awi.setWorkItemDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setValue(Boolean.TRUE);
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setValue(Float.valueOf(123.456f));
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setValue(Integer.valueOf(123));
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setValue("hello");
        pwd.addParameter((PortableParameterDefinition)p4);
        cols.add(awi);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doActions(allColumns, cols, (TemplateDataProvider)rowDataProvider, rowData, rm);
        Assert.assertEquals((long)1L, (long)rm.rhs.length);
        ActionExecuteWorkItem aw = (ActionExecuteWorkItem)rm.rhs[0];
        Assert.assertNotNull((Object)aw);
        PortableWorkDefinition mpwd = aw.getWorkDefinition();
        Assert.assertNotNull((Object)mpwd);
        Assert.assertEquals((long)4L, (long)mpwd.getParameters().size());
        PortableBooleanParameterDefinition mp1 = (PortableBooleanParameterDefinition)mpwd.getParameter("BooleanParameter");
        Assert.assertNotNull((Object)mp1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)mp1.getValue());
        PortableFloatParameterDefinition mp2 = (PortableFloatParameterDefinition)mpwd.getParameter("FloatParameter");
        Assert.assertNotNull((Object)mp2);
        Assert.assertEquals((Object)new Float(123.456f), (Object)mp2.getValue());
        PortableIntegerParameterDefinition mp3 = (PortableIntegerParameterDefinition)mpwd.getParameter("IntegerParameter");
        Assert.assertNotNull((Object)mp3);
        Assert.assertEquals((Object)new Integer(123), (Object)mp3.getValue());
        PortableStringParameterDefinition mp4 = (PortableStringParameterDefinition)mpwd.getParameter("StringParameter");
        Assert.assertNotNull((Object)mp4);
        Assert.assertEquals((Object)"hello", (Object)mp4.getValue());
    }

    @Test
    public void testRHSExecuteWorkItemWithBindings() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "true"};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        ArrayList<ActionWorkItemCol52> cols = new ArrayList<ActionWorkItemCol52>();
        ActionWorkItemCol52 awi = new ActionWorkItemCol52();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("work-item");
        awi.setWorkItemDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanParameter");
        p1.setValue(Boolean.TRUE);
        p1.setBinding("$b");
        pwd.addParameter((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatParameter");
        p2.setValue(Float.valueOf(123.456f));
        p2.setBinding("$f");
        pwd.addParameter((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerParameter");
        p3.setValue(Integer.valueOf(123));
        p3.setBinding("$i");
        pwd.addParameter((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringParameter");
        p4.setValue("hello");
        p4.setBinding("$s");
        pwd.addParameter((PortableParameterDefinition)p4);
        cols.add(awi);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doActions(allColumns, cols, (TemplateDataProvider)rowDataProvider, rowData, rm);
        Assert.assertEquals((long)1L, (long)rm.rhs.length);
        ActionExecuteWorkItem aw = (ActionExecuteWorkItem)rm.rhs[0];
        Assert.assertNotNull((Object)aw);
        PortableWorkDefinition mpwd = aw.getWorkDefinition();
        Assert.assertNotNull((Object)mpwd);
        Assert.assertEquals((long)4L, (long)mpwd.getParameters().size());
        PortableBooleanParameterDefinition mp1 = (PortableBooleanParameterDefinition)mpwd.getParameter("BooleanParameter");
        Assert.assertNotNull((Object)mp1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)mp1.getValue());
        Assert.assertEquals((Object)"$b", (Object)mp1.getBinding());
        PortableFloatParameterDefinition mp2 = (PortableFloatParameterDefinition)mpwd.getParameter("FloatParameter");
        Assert.assertNotNull((Object)mp2);
        Assert.assertEquals((Object)new Float(123.456f), (Object)mp2.getValue());
        Assert.assertEquals((Object)"$f", (Object)mp2.getBinding());
        PortableIntegerParameterDefinition mp3 = (PortableIntegerParameterDefinition)mpwd.getParameter("IntegerParameter");
        Assert.assertNotNull((Object)mp3);
        Assert.assertEquals((Object)new Integer(123), (Object)mp3.getValue());
        Assert.assertEquals((Object)"$i", (Object)mp3.getBinding());
        PortableStringParameterDefinition mp4 = (PortableStringParameterDefinition)mpwd.getParameter("StringParameter");
        Assert.assertNotNull((Object)mp4);
        Assert.assertEquals((Object)"hello", (Object)mp4.getValue());
        Assert.assertEquals((Object)"$s", (Object)mp4.getBinding());
    }

    @Test
    public void testRHSActionWorkItemSetFields1() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "true", "true", "true", "true", "true"};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        ArrayList<Object> cols = new ArrayList<Object>();
        ActionWorkItemCol52 awi = new ActionWorkItemCol52();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkItemDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanResult");
        pwd.addResult((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatResult");
        pwd.addResult((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerResult");
        pwd.addResult((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringResult");
        pwd.addResult((PortableParameterDefinition)p4);
        cols.add(awi);
        ActionWorkItemSetFieldCol52 asf1 = new ActionWorkItemSetFieldCol52();
        asf1.setBoundName("$r");
        asf1.setFactField("ResultBooleanField");
        asf1.setType("Boolean");
        asf1.setWorkItemName("WorkItem");
        asf1.setWorkItemResultParameterName("BooleanResult");
        asf1.setParameterClassName(Boolean.class.getName());
        cols.add(asf1);
        ActionWorkItemSetFieldCol52 asf2 = new ActionWorkItemSetFieldCol52();
        asf2.setBoundName("$r");
        asf2.setFactField("ResultFloatField");
        asf2.setType("Float");
        asf2.setWorkItemName("WorkItem");
        asf2.setWorkItemResultParameterName("FloatResult");
        asf2.setParameterClassName(Float.class.getName());
        cols.add(asf2);
        ActionWorkItemSetFieldCol52 asf3 = new ActionWorkItemSetFieldCol52();
        asf3.setBoundName("$r");
        asf3.setFactField("ResultIntegerField");
        asf3.setType("Integer");
        asf3.setWorkItemName("WorkItem");
        asf3.setWorkItemResultParameterName("IntegerResult");
        asf3.setParameterClassName(Integer.class.getName());
        cols.add(asf3);
        ActionWorkItemSetFieldCol52 asf4 = new ActionWorkItemSetFieldCol52();
        asf4.setBoundName("$r");
        asf4.setFactField("ResultStringField");
        asf4.setType("String");
        asf4.setWorkItemName("WorkItem");
        asf4.setWorkItemResultParameterName("StringResult");
        asf4.setParameterClassName(String.class.getName());
        cols.add(asf4);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doActions(allColumns, cols, (TemplateDataProvider)rowDataProvider, rowData, rm);
        Assert.assertEquals((long)2L, (long)rm.rhs.length);
        ActionExecuteWorkItem aw = (ActionExecuteWorkItem)rm.rhs[0];
        Assert.assertNotNull((Object)aw);
        ActionSetField asf = (ActionSetField)rm.rhs[1];
        Assert.assertNotNull((Object)asf);
        PortableWorkDefinition mpwd = aw.getWorkDefinition();
        Assert.assertNotNull((Object)mpwd);
        Assert.assertEquals((long)4L, (long)mpwd.getResults().size());
        PortableBooleanParameterDefinition mp1 = (PortableBooleanParameterDefinition)mpwd.getResult("BooleanResult");
        Assert.assertNotNull((Object)mp1);
        PortableFloatParameterDefinition mp2 = (PortableFloatParameterDefinition)mpwd.getResult("FloatResult");
        Assert.assertNotNull((Object)mp2);
        PortableIntegerParameterDefinition mp3 = (PortableIntegerParameterDefinition)mpwd.getResult("IntegerResult");
        Assert.assertNotNull((Object)mp3);
        PortableStringParameterDefinition mp4 = (PortableStringParameterDefinition)mpwd.getResult("StringResult");
        Assert.assertNotNull((Object)mp4);
        Assert.assertEquals((Object)asf.getVariable(), (Object)"$r");
        Assert.assertEquals((long)4L, (long)asf.getFieldValues().length);
        ActionFieldValue fv1 = asf.getFieldValues()[0];
        Assert.assertNotNull((Object)fv1);
        Assert.assertTrue((boolean)(fv1 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv1 = (ActionWorkItemFieldValue)fv1;
        Assert.assertEquals((Object)"ResultBooleanField", (Object)wifv1.getField());
        Assert.assertEquals((Object)"Boolean", (Object)wifv1.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv1.getWorkItemName());
        Assert.assertEquals((Object)"BooleanResult", (Object)wifv1.getWorkItemParameterName());
        Assert.assertEquals((Object)Boolean.class.getName(), (Object)wifv1.getWorkItemParameterClassName());
        ActionFieldValue fv2 = asf.getFieldValues()[1];
        Assert.assertNotNull((Object)fv2);
        Assert.assertTrue((boolean)(fv2 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv2 = (ActionWorkItemFieldValue)fv2;
        Assert.assertEquals((Object)"ResultFloatField", (Object)wifv2.getField());
        Assert.assertEquals((Object)"Float", (Object)wifv2.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv2.getWorkItemName());
        Assert.assertEquals((Object)"FloatResult", (Object)wifv2.getWorkItemParameterName());
        Assert.assertEquals((Object)Float.class.getName(), (Object)wifv2.getWorkItemParameterClassName());
        ActionFieldValue fv3 = asf.getFieldValues()[2];
        Assert.assertNotNull((Object)fv3);
        Assert.assertTrue((boolean)(fv3 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv3 = (ActionWorkItemFieldValue)fv3;
        Assert.assertEquals((Object)"ResultIntegerField", (Object)wifv3.getField());
        Assert.assertEquals((Object)"Integer", (Object)wifv3.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv3.getWorkItemName());
        Assert.assertEquals((Object)"IntegerResult", (Object)wifv3.getWorkItemParameterName());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)wifv3.getWorkItemParameterClassName());
        ActionFieldValue fv4 = asf.getFieldValues()[3];
        Assert.assertNotNull((Object)fv4);
        Assert.assertTrue((boolean)(fv4 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv4 = (ActionWorkItemFieldValue)fv4;
        Assert.assertEquals((Object)"ResultStringField", (Object)wifv4.getField());
        Assert.assertEquals((Object)"String", (Object)wifv4.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv4.getWorkItemName());
        Assert.assertEquals((Object)"StringResult", (Object)wifv4.getWorkItemParameterName());
        Assert.assertEquals((Object)String.class.getName(), (Object)wifv4.getWorkItemParameterClassName());
    }

    @Test
    public void testRHSActionWorkItemSetFields2() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "true", "true", "false"};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        ArrayList<Object> cols = new ArrayList<Object>();
        ActionWorkItemCol52 awi = new ActionWorkItemCol52();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkItemDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanResult");
        pwd.addResult((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatResult");
        pwd.addResult((PortableParameterDefinition)p2);
        cols.add(awi);
        ActionWorkItemSetFieldCol52 asf1 = new ActionWorkItemSetFieldCol52();
        asf1.setBoundName("$r");
        asf1.setFactField("ResultBooleanField");
        asf1.setType("Boolean");
        asf1.setWorkItemName("WorkItem");
        asf1.setWorkItemResultParameterName("BooleanResult");
        asf1.setParameterClassName(Boolean.class.getName());
        cols.add(asf1);
        ActionWorkItemSetFieldCol52 asf2 = new ActionWorkItemSetFieldCol52();
        asf2.setBoundName("$r");
        asf2.setFactField("ResultFloatField");
        asf2.setType("Float");
        asf2.setWorkItemName("WorkItem");
        asf2.setWorkItemResultParameterName("FloatResult");
        asf2.setParameterClassName(Float.class.getName());
        cols.add(asf2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doActions(allColumns, cols, (TemplateDataProvider)rowDataProvider, rowData, rm);
        Assert.assertEquals((long)2L, (long)rm.rhs.length);
        ActionExecuteWorkItem aw = (ActionExecuteWorkItem)rm.rhs[0];
        Assert.assertNotNull((Object)aw);
        ActionSetField asf = (ActionSetField)rm.rhs[1];
        Assert.assertNotNull((Object)asf);
        PortableWorkDefinition mpwd = aw.getWorkDefinition();
        Assert.assertNotNull((Object)mpwd);
        Assert.assertEquals((long)2L, (long)mpwd.getResults().size());
        PortableBooleanParameterDefinition mp1 = (PortableBooleanParameterDefinition)mpwd.getResult("BooleanResult");
        Assert.assertNotNull((Object)mp1);
        PortableFloatParameterDefinition mp2 = (PortableFloatParameterDefinition)mpwd.getResult("FloatResult");
        Assert.assertNotNull((Object)mp2);
        Assert.assertEquals((Object)asf.getVariable(), (Object)"$r");
        Assert.assertEquals((long)1L, (long)asf.getFieldValues().length);
        ActionFieldValue fv1 = asf.getFieldValues()[0];
        Assert.assertNotNull((Object)fv1);
        Assert.assertTrue((boolean)(fv1 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv1 = (ActionWorkItemFieldValue)fv1;
        Assert.assertEquals((Object)"ResultBooleanField", (Object)wifv1.getField());
        Assert.assertEquals((Object)"Boolean", (Object)wifv1.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv1.getWorkItemName());
        Assert.assertEquals((Object)"BooleanResult", (Object)wifv1.getWorkItemParameterName());
        Assert.assertEquals((Object)Boolean.class.getName(), (Object)wifv1.getWorkItemParameterClassName());
    }

    @Test
    public void testRHSActionWorkItemInsertFacts1() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "true", "true", "true", "true", "true"};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        ArrayList<Object> cols = new ArrayList<Object>();
        ActionWorkItemCol52 awi = new ActionWorkItemCol52();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkItemDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanResult");
        pwd.addResult((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatResult");
        pwd.addResult((PortableParameterDefinition)p2);
        PortableIntegerParameterDefinition p3 = new PortableIntegerParameterDefinition();
        p3.setName("IntegerResult");
        pwd.addResult((PortableParameterDefinition)p3);
        PortableStringParameterDefinition p4 = new PortableStringParameterDefinition();
        p4.setName("StringResult");
        pwd.addResult((PortableParameterDefinition)p4);
        cols.add(awi);
        ActionWorkItemInsertFactCol52 asf1 = new ActionWorkItemInsertFactCol52();
        asf1.setBoundName("$r");
        asf1.setFactField("ResultBooleanField");
        asf1.setType("Boolean");
        asf1.setWorkItemName("WorkItem");
        asf1.setWorkItemResultParameterName("BooleanResult");
        asf1.setParameterClassName(Boolean.class.getName());
        cols.add(asf1);
        ActionWorkItemInsertFactCol52 asf2 = new ActionWorkItemInsertFactCol52();
        asf2.setBoundName("$r");
        asf2.setFactField("ResultFloatField");
        asf2.setType("Float");
        asf2.setWorkItemName("WorkItem");
        asf2.setWorkItemResultParameterName("FloatResult");
        asf2.setParameterClassName(Float.class.getName());
        cols.add(asf2);
        ActionWorkItemInsertFactCol52 asf3 = new ActionWorkItemInsertFactCol52();
        asf3.setBoundName("$r");
        asf3.setFactField("ResultIntegerField");
        asf3.setType("Integer");
        asf3.setWorkItemName("WorkItem");
        asf3.setWorkItemResultParameterName("IntegerResult");
        asf3.setParameterClassName(Integer.class.getName());
        cols.add(asf3);
        ActionWorkItemInsertFactCol52 asf4 = new ActionWorkItemInsertFactCol52();
        asf4.setBoundName("$r");
        asf4.setFactField("ResultStringField");
        asf4.setType("String");
        asf4.setWorkItemName("WorkItem");
        asf4.setWorkItemResultParameterName("StringResult");
        asf4.setParameterClassName(String.class.getName());
        cols.add(asf4);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doActions(allColumns, cols, (TemplateDataProvider)rowDataProvider, rowData, rm);
        Assert.assertEquals((long)2L, (long)rm.rhs.length);
        ActionExecuteWorkItem aw = (ActionExecuteWorkItem)rm.rhs[0];
        Assert.assertNotNull((Object)aw);
        ActionInsertFact aif = (ActionInsertFact)rm.rhs[1];
        Assert.assertNotNull((Object)aif);
        PortableWorkDefinition mpwd = aw.getWorkDefinition();
        Assert.assertNotNull((Object)mpwd);
        Assert.assertEquals((long)4L, (long)mpwd.getResults().size());
        PortableBooleanParameterDefinition mp1 = (PortableBooleanParameterDefinition)mpwd.getResult("BooleanResult");
        Assert.assertNotNull((Object)mp1);
        PortableFloatParameterDefinition mp2 = (PortableFloatParameterDefinition)mpwd.getResult("FloatResult");
        Assert.assertNotNull((Object)mp2);
        PortableIntegerParameterDefinition mp3 = (PortableIntegerParameterDefinition)mpwd.getResult("IntegerResult");
        Assert.assertNotNull((Object)mp3);
        PortableStringParameterDefinition mp4 = (PortableStringParameterDefinition)mpwd.getResult("StringResult");
        Assert.assertNotNull((Object)mp4);
        Assert.assertEquals((Object)aif.getBoundName(), (Object)"$r");
        Assert.assertEquals((long)4L, (long)aif.getFieldValues().length);
        ActionFieldValue fv1 = aif.getFieldValues()[0];
        Assert.assertNotNull((Object)fv1);
        Assert.assertTrue((boolean)(fv1 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv1 = (ActionWorkItemFieldValue)fv1;
        Assert.assertEquals((Object)"ResultBooleanField", (Object)wifv1.getField());
        Assert.assertEquals((Object)"Boolean", (Object)wifv1.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv1.getWorkItemName());
        Assert.assertEquals((Object)"BooleanResult", (Object)wifv1.getWorkItemParameterName());
        Assert.assertEquals((Object)Boolean.class.getName(), (Object)wifv1.getWorkItemParameterClassName());
        ActionFieldValue fv2 = aif.getFieldValues()[1];
        Assert.assertNotNull((Object)fv2);
        Assert.assertTrue((boolean)(fv2 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv2 = (ActionWorkItemFieldValue)fv2;
        Assert.assertEquals((Object)"ResultFloatField", (Object)wifv2.getField());
        Assert.assertEquals((Object)"Float", (Object)wifv2.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv2.getWorkItemName());
        Assert.assertEquals((Object)"FloatResult", (Object)wifv2.getWorkItemParameterName());
        Assert.assertEquals((Object)Float.class.getName(), (Object)wifv2.getWorkItemParameterClassName());
        ActionFieldValue fv3 = aif.getFieldValues()[2];
        Assert.assertNotNull((Object)fv3);
        Assert.assertTrue((boolean)(fv3 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv3 = (ActionWorkItemFieldValue)fv3;
        Assert.assertEquals((Object)"ResultIntegerField", (Object)wifv3.getField());
        Assert.assertEquals((Object)"Integer", (Object)wifv3.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv3.getWorkItemName());
        Assert.assertEquals((Object)"IntegerResult", (Object)wifv3.getWorkItemParameterName());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)wifv3.getWorkItemParameterClassName());
        ActionFieldValue fv4 = aif.getFieldValues()[3];
        Assert.assertNotNull((Object)fv4);
        Assert.assertTrue((boolean)(fv4 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv4 = (ActionWorkItemFieldValue)fv4;
        Assert.assertEquals((Object)"ResultStringField", (Object)wifv4.getField());
        Assert.assertEquals((Object)"String", (Object)wifv4.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv4.getWorkItemName());
        Assert.assertEquals((Object)"StringResult", (Object)wifv4.getWorkItemParameterName());
        Assert.assertEquals((Object)String.class.getName(), (Object)wifv4.getWorkItemParameterClassName());
    }

    @Test
    public void testRHSActionWorkItemInsertFacts2() {
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[] row = new String[]{"1", "desc", "true", "true", "false"};
        ArrayList<Object> allColumns = new ArrayList<Object>();
        allColumns.add(new RowNumberCol52());
        allColumns.add(new DescriptionCol52());
        ArrayList<Object> cols = new ArrayList<Object>();
        ActionWorkItemCol52 awi = new ActionWorkItemCol52();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName("WorkItem");
        awi.setWorkItemDefinition(pwd);
        PortableBooleanParameterDefinition p1 = new PortableBooleanParameterDefinition();
        p1.setName("BooleanResult");
        pwd.addResult((PortableParameterDefinition)p1);
        PortableFloatParameterDefinition p2 = new PortableFloatParameterDefinition();
        p2.setName("FloatResult");
        pwd.addResult((PortableParameterDefinition)p2);
        cols.add(awi);
        ActionWorkItemInsertFactCol52 asf1 = new ActionWorkItemInsertFactCol52();
        asf1.setBoundName("$r");
        asf1.setFactField("ResultBooleanField");
        asf1.setType("Boolean");
        asf1.setWorkItemName("WorkItem");
        asf1.setWorkItemResultParameterName("BooleanResult");
        asf1.setParameterClassName(Boolean.class.getName());
        cols.add(asf1);
        ActionWorkItemInsertFactCol52 asf2 = new ActionWorkItemInsertFactCol52();
        asf2.setBoundName("$r");
        asf2.setFactField("ResultFloatField");
        asf2.setType("Float");
        asf2.setWorkItemName("WorkItem");
        asf2.setWorkItemResultParameterName("FloatResult");
        asf2.setParameterClassName(Float.class.getName());
        cols.add(asf2);
        RuleModel rm = new RuleModel();
        allColumns.addAll(cols);
        List rowData = DataUtilities.makeDataRowList((Object[])row);
        GuidedDTTemplateDataProvider rowDataProvider = new GuidedDTTemplateDataProvider(allColumns, rowData);
        p.doActions(allColumns, cols, (TemplateDataProvider)rowDataProvider, rowData, rm);
        Assert.assertEquals((long)2L, (long)rm.rhs.length);
        ActionExecuteWorkItem aw = (ActionExecuteWorkItem)rm.rhs[0];
        Assert.assertNotNull((Object)aw);
        ActionInsertFact aif = (ActionInsertFact)rm.rhs[1];
        Assert.assertNotNull((Object)aif);
        PortableWorkDefinition mpwd = aw.getWorkDefinition();
        Assert.assertNotNull((Object)mpwd);
        Assert.assertEquals((long)2L, (long)mpwd.getResults().size());
        PortableBooleanParameterDefinition mp1 = (PortableBooleanParameterDefinition)mpwd.getResult("BooleanResult");
        Assert.assertNotNull((Object)mp1);
        PortableFloatParameterDefinition mp2 = (PortableFloatParameterDefinition)mpwd.getResult("FloatResult");
        Assert.assertNotNull((Object)mp2);
        Assert.assertEquals((Object)aif.getBoundName(), (Object)"$r");
        Assert.assertEquals((long)1L, (long)aif.getFieldValues().length);
        ActionFieldValue fv1 = aif.getFieldValues()[0];
        Assert.assertNotNull((Object)fv1);
        Assert.assertTrue((boolean)(fv1 instanceof ActionWorkItemFieldValue));
        ActionWorkItemFieldValue wifv1 = (ActionWorkItemFieldValue)fv1;
        Assert.assertEquals((Object)"ResultBooleanField", (Object)wifv1.getField());
        Assert.assertEquals((Object)"Boolean", (Object)wifv1.getType());
        Assert.assertEquals((Object)"WorkItem", (Object)wifv1.getWorkItemName());
        Assert.assertEquals((Object)"BooleanResult", (Object)wifv1.getWorkItemParameterName());
        Assert.assertEquals((Object)Boolean.class.getName(), (Object)wifv1.getWorkItemParameterClassName());
    }

    @Test
    public void testLHSWithBRLColumn_ParseToRuleModel() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        Object[][] data = new String[][]{{"1", "desc", "Gargamel", "Pupa", "50"}, {"2", "desc", "Gargamel", "", "50"}, {"3", "desc", "Gargamel", "Pupa", ""}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Baddie");
        ConditionCol52 con = new ConditionCol52();
        con.setConstraintValueType(1);
        con.setFactField("name");
        con.setOperator("==");
        p1.getChildColumns().add(con);
        dtable.getConditions().add(p1);
        BRLConditionColumn brl1 = new BRLConditionColumn();
        ArrayList<FactPattern> brl1Definition = new ArrayList<FactPattern>();
        FactPattern brl1DefinitionFactPattern1 = new FactPattern("Smurf");
        SingleFieldConstraint brl1DefinitionFactPattern1Constraint1 = new SingleFieldConstraint();
        brl1DefinitionFactPattern1Constraint1.setFieldType("String");
        brl1DefinitionFactPattern1Constraint1.setConstraintValueType(7);
        brl1DefinitionFactPattern1Constraint1.setFieldName("name");
        brl1DefinitionFactPattern1Constraint1.setOperator("==");
        brl1DefinitionFactPattern1Constraint1.setValue("$name");
        brl1DefinitionFactPattern1.addConstraint((FieldConstraint)brl1DefinitionFactPattern1Constraint1);
        SingleFieldConstraint brl1DefinitionFactPattern1Constraint2 = new SingleFieldConstraint();
        brl1DefinitionFactPattern1Constraint2.setFieldType("Integer");
        brl1DefinitionFactPattern1Constraint2.setConstraintValueType(7);
        brl1DefinitionFactPattern1Constraint2.setFieldName("age");
        brl1DefinitionFactPattern1Constraint2.setOperator("==");
        brl1DefinitionFactPattern1Constraint2.setValue("$age");
        brl1DefinitionFactPattern1.addConstraint((FieldConstraint)brl1DefinitionFactPattern1Constraint2);
        brl1Definition.add(brl1DefinitionFactPattern1);
        brl1.setDefinition(brl1Definition);
        BRLConditionVariableColumn brl1Variable1 = new BRLConditionVariableColumn("$name", "String", "Person", "name");
        brl1.getChildColumns().add(brl1Variable1);
        BRLConditionVariableColumn brl1Variable2 = new BRLConditionVariableColumn("$age", "Integer", "Person", "age");
        brl1.getChildColumns().add(brl1Variable2);
        dtable.getConditions().add(brl1);
        RuleModel rm = new RuleModel();
        List allColumns = dtable.getExpandedColumns();
        List allPatterns = dtable.getConditions();
        List dtData = DataUtilities.makeDataLists((Object[][])data);
        List dtRowData0 = DataUtilities.makeDataRowList((Object[])data[0]);
        GuidedDTTemplateDataProvider rowDataProvider0 = new GuidedDTTemplateDataProvider(allColumns, dtRowData0);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider0, dtRowData0, dtData, rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Baddie", (Object)((FactPattern)rm.lhs[0]).getFactType());
        Assert.assertEquals((Object)"Smurf", (Object)((FactPattern)rm.lhs[1]).getFactType());
        FactPattern result0Fp1 = (FactPattern)rm.lhs[0];
        Assert.assertEquals((long)1L, (long)result0Fp1.getConstraintList().getConstraints().length);
        SingleFieldConstraint result0Fp1Con1 = (SingleFieldConstraint)result0Fp1.getConstraint(0);
        Assert.assertEquals((long)1L, (long)result0Fp1Con1.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)result0Fp1Con1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result0Fp1Con1.getOperator());
        Assert.assertEquals((Object)"Gargamel", (Object)result0Fp1Con1.getValue());
        FactPattern result0Fp2 = (FactPattern)rm.lhs[1];
        Assert.assertEquals((long)2L, (long)result0Fp2.getConstraintList().getConstraints().length);
        SingleFieldConstraint result0Fp2Con1 = (SingleFieldConstraint)result0Fp2.getConstraint(0);
        Assert.assertEquals((long)7L, (long)result0Fp2Con1.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)result0Fp2Con1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result0Fp2Con1.getOperator());
        Assert.assertEquals((Object)"$name", (Object)result0Fp2Con1.getValue());
        SingleFieldConstraint result0Fp2Con2 = (SingleFieldConstraint)result0Fp2.getConstraint(1);
        Assert.assertEquals((long)7L, (long)result0Fp2Con2.getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)result0Fp2Con2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result0Fp2Con2.getOperator());
        Assert.assertEquals((Object)"$age", (Object)result0Fp2Con2.getValue());
        List dtRowData1 = DataUtilities.makeDataRowList((Object[])data[1]);
        GuidedDTTemplateDataProvider rowDataProvider1 = new GuidedDTTemplateDataProvider(allColumns, dtRowData1);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider1, dtRowData1, dtData, rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Baddie", (Object)((FactPattern)rm.lhs[0]).getFactType());
        FactPattern result1Fp1 = (FactPattern)rm.lhs[0];
        Assert.assertEquals((long)1L, (long)result1Fp1.getConstraintList().getConstraints().length);
        SingleFieldConstraint result1Fp1Con1 = (SingleFieldConstraint)result1Fp1.getConstraint(0);
        Assert.assertEquals((long)1L, (long)result1Fp1Con1.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)result1Fp1Con1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result1Fp1Con1.getOperator());
        Assert.assertEquals((Object)"Gargamel", (Object)result1Fp1Con1.getValue());
        FactPattern result1Fp2 = (FactPattern)rm.lhs[1];
        Assert.assertEquals((long)2L, (long)result1Fp2.getConstraintList().getConstraints().length);
        SingleFieldConstraint result1Fp2Con1 = (SingleFieldConstraint)result1Fp2.getConstraint(0);
        Assert.assertEquals((long)7L, (long)result1Fp2Con1.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)result1Fp2Con1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result1Fp2Con1.getOperator());
        Assert.assertEquals((Object)"$name", (Object)result1Fp2Con1.getValue());
        SingleFieldConstraint result1Fp2Con2 = (SingleFieldConstraint)result1Fp2.getConstraint(1);
        Assert.assertEquals((long)7L, (long)result1Fp2Con2.getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)result1Fp2Con2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result1Fp2Con2.getOperator());
        Assert.assertEquals((Object)"$age", (Object)result1Fp2Con2.getValue());
        List dtRowData2 = DataUtilities.makeDataRowList((Object[])data[2]);
        GuidedDTTemplateDataProvider rowDataProvider2 = new GuidedDTTemplateDataProvider(allColumns, dtRowData2);
        p.doConditions(allColumns, allPatterns, (TemplateDataProvider)rowDataProvider2, dtRowData2, dtData, rm);
        Assert.assertEquals((long)2L, (long)rm.lhs.length);
        Assert.assertEquals((Object)"Baddie", (Object)((FactPattern)rm.lhs[0]).getFactType());
        FactPattern result2Fp1 = (FactPattern)rm.lhs[0];
        Assert.assertEquals((long)1L, (long)result2Fp1.getConstraintList().getConstraints().length);
        SingleFieldConstraint result2Fp1Con1 = (SingleFieldConstraint)result2Fp1.getConstraint(0);
        Assert.assertEquals((long)1L, (long)result2Fp1Con1.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)result2Fp1Con1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result2Fp1Con1.getOperator());
        Assert.assertEquals((Object)"Gargamel", (Object)result2Fp1Con1.getValue());
        FactPattern result2Fp2 = (FactPattern)rm.lhs[1];
        Assert.assertEquals((long)2L, (long)result2Fp2.getConstraintList().getConstraints().length);
        SingleFieldConstraint result2Fp2Con1 = (SingleFieldConstraint)result2Fp2.getConstraint(0);
        Assert.assertEquals((long)7L, (long)result2Fp2Con1.getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)result2Fp2Con1.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result2Fp2Con1.getOperator());
        Assert.assertEquals((Object)"$name", (Object)result2Fp2Con1.getValue());
        SingleFieldConstraint result2Fp2Con2 = (SingleFieldConstraint)result2Fp2.getConstraint(1);
        Assert.assertEquals((long)7L, (long)result2Fp2Con2.getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)result2Fp2Con2.getFieldName());
        Assert.assertEquals((Object)"==", (Object)result2Fp2Con2.getOperator());
        Assert.assertEquals((Object)"$age", (Object)result2Fp2Con2.getValue());
    }

    @Test
    public void testLHSWithBRLColumn_ParseToDRL() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        Object[][] data = new String[][]{{"1", "desc", "Gargamel", "Pupa", "50"}, {"2", "desc", "Gargamel", "", "50"}, {"3", "desc", "Gargamel", "Pupa", ""}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        Pattern52 p1 = new Pattern52();
        p1.setFactType("Baddie");
        ConditionCol52 con = new ConditionCol52();
        con.setConstraintValueType(1);
        con.setFactField("name");
        con.setOperator("==");
        p1.getChildColumns().add(con);
        dtable.getConditions().add(p1);
        BRLConditionColumn brl1 = new BRLConditionColumn();
        ArrayList<FactPattern> brl1Definition = new ArrayList<FactPattern>();
        FactPattern brl1DefinitionFactPattern1 = new FactPattern("Smurf");
        SingleFieldConstraint brl1DefinitionFactPattern1Constraint1 = new SingleFieldConstraint();
        brl1DefinitionFactPattern1Constraint1.setFieldType("String");
        brl1DefinitionFactPattern1Constraint1.setConstraintValueType(7);
        brl1DefinitionFactPattern1Constraint1.setFieldName("name");
        brl1DefinitionFactPattern1Constraint1.setOperator("==");
        brl1DefinitionFactPattern1Constraint1.setValue("$name");
        brl1DefinitionFactPattern1.addConstraint((FieldConstraint)brl1DefinitionFactPattern1Constraint1);
        SingleFieldConstraint brl1DefinitionFactPattern1Constraint2 = new SingleFieldConstraint();
        brl1DefinitionFactPattern1Constraint2.setFieldType("Integer");
        brl1DefinitionFactPattern1Constraint2.setConstraintValueType(7);
        brl1DefinitionFactPattern1Constraint2.setFieldName("age");
        brl1DefinitionFactPattern1Constraint2.setOperator("==");
        brl1DefinitionFactPattern1Constraint2.setValue("$age");
        brl1DefinitionFactPattern1.addConstraint((FieldConstraint)brl1DefinitionFactPattern1Constraint2);
        brl1Definition.add(brl1DefinitionFactPattern1);
        brl1.setDefinition(brl1Definition);
        BRLConditionVariableColumn brl1Variable1 = new BRLConditionVariableColumn("$name", "String", "Person", "name");
        brl1.getChildColumns().add(brl1Variable1);
        BRLConditionVariableColumn brl1Variable2 = new BRLConditionVariableColumn("$age", "Integer", "Person", "age");
        brl1.getChildColumns().add(brl1Variable2);
        dtable.getConditions().add(brl1);
        dtable.setData(DataUtilities.makeDataLists((Object[][])data));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dtable);
        System.out.println(drl);
        int ruleStartIndex = drl.indexOf("//from row number: 1");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        int pattern1StartIndex = drl.indexOf("Baddie( name == \"Gargamel\" )", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        int pattern2StartIndex = drl.indexOf("Smurf( name == \"Pupa\" , age == 50 )", ruleStartIndex);
        Assert.assertFalse((pattern2StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 2");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("Baddie( name == \"Gargamel\" )", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        pattern2StartIndex = drl.indexOf("Smurf( age == 50 )", ruleStartIndex);
        Assert.assertFalse((pattern2StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 3");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("Baddie( name == \"Gargamel\" )", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        pattern2StartIndex = drl.indexOf("Smurf( name == \"Pupa\" )", ruleStartIndex);
        Assert.assertFalse((pattern2StartIndex == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSWithBRLColumn_ParseToDRL_MultiplePatterns() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        Object[][] data = new String[][]{{"1", "desc", "Pupa", "50"}, {"2", "desc", "", "50"}, {"3", "desc", "Pupa", ""}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        BRLConditionColumn brl1 = new BRLConditionColumn();
        ArrayList<FactPattern> brl1Definition = new ArrayList<FactPattern>();
        FactPattern brl1DefinitionFactPattern1 = new FactPattern("Baddie");
        SingleFieldConstraint brl1DefinitionFactPattern1Constraint1 = new SingleFieldConstraint();
        brl1DefinitionFactPattern1Constraint1.setFieldType("String");
        brl1DefinitionFactPattern1Constraint1.setConstraintValueType(1);
        brl1DefinitionFactPattern1Constraint1.setFieldName("name");
        brl1DefinitionFactPattern1Constraint1.setOperator("==");
        brl1DefinitionFactPattern1Constraint1.setValue("Gargamel");
        brl1DefinitionFactPattern1.addConstraint((FieldConstraint)brl1DefinitionFactPattern1Constraint1);
        brl1Definition.add(brl1DefinitionFactPattern1);
        FactPattern brl1DefinitionFactPattern2 = new FactPattern("Smurf");
        SingleFieldConstraint brl1DefinitionFactPattern2Constraint1 = new SingleFieldConstraint();
        brl1DefinitionFactPattern2Constraint1.setFieldType("String");
        brl1DefinitionFactPattern2Constraint1.setConstraintValueType(7);
        brl1DefinitionFactPattern2Constraint1.setFieldName("name");
        brl1DefinitionFactPattern2Constraint1.setOperator("==");
        brl1DefinitionFactPattern2Constraint1.setValue("$name");
        brl1DefinitionFactPattern2.addConstraint((FieldConstraint)brl1DefinitionFactPattern2Constraint1);
        SingleFieldConstraint brl1DefinitionFactPattern2Constraint2 = new SingleFieldConstraint();
        brl1DefinitionFactPattern2Constraint2.setFieldType("Integer");
        brl1DefinitionFactPattern2Constraint2.setConstraintValueType(7);
        brl1DefinitionFactPattern2Constraint2.setFieldName("age");
        brl1DefinitionFactPattern2Constraint2.setOperator("==");
        brl1DefinitionFactPattern2Constraint2.setValue("$age");
        brl1DefinitionFactPattern2.addConstraint((FieldConstraint)brl1DefinitionFactPattern2Constraint2);
        brl1Definition.add(brl1DefinitionFactPattern2);
        brl1.setDefinition(brl1Definition);
        BRLConditionVariableColumn brl1Variable1 = new BRLConditionVariableColumn("$name", "String", "Person", "name");
        brl1.getChildColumns().add(brl1Variable1);
        BRLConditionVariableColumn brl1Variable2 = new BRLConditionVariableColumn("$age", "Integer", "Person", "age");
        brl1.getChildColumns().add(brl1Variable2);
        dtable.getConditions().add(brl1);
        dtable.setData(DataUtilities.makeDataLists((Object[][])data));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dtable);
        System.out.println(drl);
        int ruleStartIndex = drl.indexOf("//from row number: 1");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        int pattern1StartIndex = drl.indexOf("Baddie( name == \"Gargamel\" )", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        int pattern2StartIndex = drl.indexOf("Smurf( name == \"Pupa\" , age == 50 )", ruleStartIndex);
        Assert.assertFalse((pattern2StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 2");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("Baddie( name == \"Gargamel\" )", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        pattern2StartIndex = drl.indexOf("Smurf( age == 50 )", ruleStartIndex);
        Assert.assertFalse((pattern2StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 3");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("Baddie( name == \"Gargamel\" )", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        pattern2StartIndex = drl.indexOf("Smurf( name == \"Pupa\" )", ruleStartIndex);
        Assert.assertFalse((pattern2StartIndex == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSWithBRLColumn_ParseToDRL_NoVariables() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        Object[][] data = new Object[][]{{"1", "desc", Boolean.TRUE}, {"2", "desc", Boolean.FALSE}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        BRLConditionColumn brl1 = new BRLConditionColumn();
        ArrayList<FactPattern> brl1Definition = new ArrayList<FactPattern>();
        FactPattern brl1DefinitionFactPattern1 = new FactPattern("Baddie");
        SingleFieldConstraint brl1DefinitionFactPattern1Constraint1 = new SingleFieldConstraint();
        brl1DefinitionFactPattern1Constraint1.setFieldType("String");
        brl1DefinitionFactPattern1Constraint1.setConstraintValueType(1);
        brl1DefinitionFactPattern1Constraint1.setFieldName("name");
        brl1DefinitionFactPattern1Constraint1.setOperator("==");
        brl1DefinitionFactPattern1Constraint1.setValue("Gargamel");
        brl1DefinitionFactPattern1.addConstraint((FieldConstraint)brl1DefinitionFactPattern1Constraint1);
        brl1Definition.add(brl1DefinitionFactPattern1);
        brl1.setDefinition(brl1Definition);
        BRLConditionVariableColumn brl1Variable1 = new BRLConditionVariableColumn("", "Boolean");
        brl1.getChildColumns().add(brl1Variable1);
        dtable.getConditions().add(brl1);
        dtable.setData(DataUtilities.makeDataLists((Object[][])data));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dtable);
        int ruleStartIndex = drl.indexOf("//from row number: 1");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        int pattern1StartIndex = drl.indexOf("Baddie( name == \"Gargamel\" )", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 2");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("Baddie( name == \"Gargamel\" )", ruleStartIndex);
        Assert.assertTrue((pattern1StartIndex == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSWithBRLColumn_ParseToDRL_FreeFormLine() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        Object[][] data = new String[][]{{"1", "desc", "Pupa", "50"}, {"2", "desc", "", "50"}, {"3", "desc", "Pupa", ""}, {"4", "desc", "", ""}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        BRLConditionColumn brl1 = new BRLConditionColumn();
        ArrayList<FreeFormLine> brl1Definition = new ArrayList<FreeFormLine>();
        FreeFormLine brl1DefinitionFreeFormLine = new FreeFormLine();
        brl1DefinitionFreeFormLine.setText("Smurf( name == \"@{name}\", age == @{age} )");
        brl1Definition.add(brl1DefinitionFreeFormLine);
        brl1.setDefinition(brl1Definition);
        BRLConditionVariableColumn brl1Variable1 = new BRLConditionVariableColumn("name", "String");
        BRLConditionVariableColumn brl1Variable2 = new BRLConditionVariableColumn("age", "Integer");
        brl1.getChildColumns().add(brl1Variable1);
        brl1.getChildColumns().add(brl1Variable2);
        dtable.getConditions().add(brl1);
        dtable.setData(DataUtilities.makeDataLists((Object[][])data));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dtable);
        int ruleStartIndex = drl.indexOf("//from row number: 1");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        int pattern1StartIndex = drl.indexOf("Smurf( name == \"Pupa\", age == 50 )", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 2");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("Smurf(", ruleStartIndex);
        Assert.assertTrue((pattern1StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 3");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("Smurf(", ruleStartIndex);
        Assert.assertTrue((pattern1StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 4");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("Smurf(", ruleStartIndex);
        Assert.assertTrue((pattern1StartIndex == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSWithBRLColumn_ParseToRuleModel() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        GuidedDTDRLPersistence p = new GuidedDTDRLPersistence();
        String[][] data = new String[][]{{"1", "desc", "Gargamel", "Pupa", "50"}, {"2", "desc", "Gargamel", "", "50"}, {"3", "desc", "Gargamel", "Pupa", ""}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        ActionInsertFactCol52 a1 = new ActionInsertFactCol52();
        a1.setBoundName("$b");
        a1.setFactType("Baddie");
        a1.setFactField("name");
        a1.setType("String");
        dtable.getActionCols().add(a1);
        BRLActionColumn brl1 = new BRLActionColumn();
        ArrayList<ActionInsertFact> brl1Definition = new ArrayList<ActionInsertFact>();
        ActionInsertFact brl1DefinitionAction1 = new ActionInsertFact("Smurf");
        ActionFieldValue brl1DefinitionAction1FieldValue1 = new ActionFieldValue("name", "$name", "String");
        brl1DefinitionAction1FieldValue1.setNature(7);
        brl1DefinitionAction1.addFieldValue(brl1DefinitionAction1FieldValue1);
        ActionFieldValue brl1DefinitionAction1FieldValue2 = new ActionFieldValue("age", "$age", "Integer");
        brl1DefinitionAction1FieldValue2.setNature(7);
        brl1DefinitionAction1.addFieldValue(brl1DefinitionAction1FieldValue2);
        brl1Definition.add(brl1DefinitionAction1);
        brl1.setDefinition(brl1Definition);
        BRLActionVariableColumn brl1Variable1 = new BRLActionVariableColumn("$name", "String", "Person", "name");
        brl1.getChildColumns().add(brl1Variable1);
        BRLActionVariableColumn brl1Variable2 = new BRLActionVariableColumn("$age", "Integer", "Person", "age");
        brl1.getChildColumns().add(brl1Variable2);
        dtable.getActionCols().add(brl1);
        RuleModel rm = new RuleModel();
        List allColumns = dtable.getExpandedColumns();
        List allActions = dtable.getActionCols();
        List dtRowData0 = DataUtilities.makeDataRowList((Object[])data[0]);
        GuidedDTTemplateDataProvider rowDataProvider0 = new GuidedDTTemplateDataProvider(allColumns, dtRowData0);
        p.doActions(allColumns, allActions, (TemplateDataProvider)rowDataProvider0, dtRowData0, rm);
        Assert.assertEquals((long)2L, (long)rm.rhs.length);
        Assert.assertEquals((Object)"Baddie", (Object)((ActionInsertFact)rm.rhs[0]).getFactType());
        Assert.assertEquals((Object)"Smurf", (Object)((ActionInsertFact)rm.rhs[1]).getFactType());
        ActionInsertFact result0Action1 = (ActionInsertFact)rm.rhs[0];
        Assert.assertEquals((long)1L, (long)result0Action1.getFieldValues().length);
        ActionFieldValue result0Action1FieldValue1 = result0Action1.getFieldValues()[0];
        Assert.assertEquals((Object)"String", (Object)result0Action1FieldValue1.getType());
        Assert.assertEquals((Object)"name", (Object)result0Action1FieldValue1.getField());
        Assert.assertEquals((Object)"Gargamel", (Object)result0Action1FieldValue1.getValue());
        ActionInsertFact result0Action2 = (ActionInsertFact)rm.rhs[1];
        Assert.assertEquals((long)2L, (long)result0Action2.getFieldValues().length);
        ActionFieldValue result0Action2FieldValue1 = result0Action2.getFieldValues()[0];
        Assert.assertEquals((Object)"String", (Object)result0Action2FieldValue1.getType());
        Assert.assertEquals((Object)"name", (Object)result0Action2FieldValue1.getField());
        Assert.assertEquals((Object)"$name", (Object)result0Action2FieldValue1.getValue());
        ActionFieldValue result0Action2FieldValue2 = result0Action2.getFieldValues()[1];
        Assert.assertEquals((Object)"Integer", (Object)result0Action2FieldValue2.getType());
        Assert.assertEquals((Object)"age", (Object)result0Action2FieldValue2.getField());
        Assert.assertEquals((Object)"$age", (Object)result0Action2FieldValue2.getValue());
        List dtRowData1 = DataUtilities.makeDataRowList((Object[])data[1]);
        GuidedDTTemplateDataProvider rowDataProvider1 = new GuidedDTTemplateDataProvider(allColumns, dtRowData1);
        p.doActions(allColumns, allActions, (TemplateDataProvider)rowDataProvider1, dtRowData1, rm);
        Assert.assertEquals((long)2L, (long)rm.rhs.length);
        Assert.assertEquals((Object)"Baddie", (Object)((ActionInsertFact)rm.rhs[0]).getFactType());
        Assert.assertEquals((Object)"Smurf", (Object)((ActionInsertFact)rm.rhs[1]).getFactType());
        ActionInsertFact result1Action1 = (ActionInsertFact)rm.rhs[0];
        Assert.assertEquals((long)1L, (long)result1Action1.getFieldValues().length);
        ActionFieldValue result1Action1FieldValue1 = result1Action1.getFieldValues()[0];
        Assert.assertEquals((Object)"String", (Object)result1Action1FieldValue1.getType());
        Assert.assertEquals((Object)"name", (Object)result1Action1FieldValue1.getField());
        Assert.assertEquals((Object)"Gargamel", (Object)result1Action1FieldValue1.getValue());
        ActionInsertFact result1Action2 = (ActionInsertFact)rm.rhs[1];
        Assert.assertEquals((long)2L, (long)result1Action2.getFieldValues().length);
        ActionFieldValue result1Action2FieldValue1 = result1Action2.getFieldValues()[0];
        Assert.assertEquals((Object)"String", (Object)result1Action2FieldValue1.getType());
        Assert.assertEquals((Object)"name", (Object)result1Action2FieldValue1.getField());
        Assert.assertEquals((Object)"$name", (Object)result1Action2FieldValue1.getValue());
        ActionFieldValue result1Action2FieldValue2 = result1Action2.getFieldValues()[1];
        Assert.assertEquals((Object)"Integer", (Object)result1Action2FieldValue2.getType());
        Assert.assertEquals((Object)"age", (Object)result1Action2FieldValue2.getField());
        Assert.assertEquals((Object)"$age", (Object)result1Action2FieldValue2.getValue());
        List dtRowData2 = DataUtilities.makeDataRowList((Object[])data[2]);
        GuidedDTTemplateDataProvider rowDataProvider2 = new GuidedDTTemplateDataProvider(allColumns, dtRowData2);
        p.doActions(allColumns, allActions, (TemplateDataProvider)rowDataProvider2, dtRowData2, rm);
        Assert.assertEquals((long)2L, (long)rm.rhs.length);
        Assert.assertEquals((Object)"Baddie", (Object)((ActionInsertFact)rm.rhs[0]).getFactType());
        Assert.assertEquals((Object)"Smurf", (Object)((ActionInsertFact)rm.rhs[1]).getFactType());
        ActionInsertFact result2Action1 = (ActionInsertFact)rm.rhs[0];
        Assert.assertEquals((long)1L, (long)result2Action1.getFieldValues().length);
        ActionFieldValue result2Action1FieldValue1 = result2Action1.getFieldValues()[0];
        Assert.assertEquals((Object)"String", (Object)result2Action1FieldValue1.getType());
        Assert.assertEquals((Object)"name", (Object)result2Action1FieldValue1.getField());
        Assert.assertEquals((Object)"Gargamel", (Object)result2Action1FieldValue1.getValue());
        ActionInsertFact result2Action2 = (ActionInsertFact)rm.rhs[1];
        Assert.assertEquals((long)2L, (long)result2Action2.getFieldValues().length);
        ActionFieldValue result2Action2FieldValue1 = result2Action2.getFieldValues()[0];
        Assert.assertEquals((Object)"String", (Object)result2Action2FieldValue1.getType());
        Assert.assertEquals((Object)"name", (Object)result2Action2FieldValue1.getField());
        Assert.assertEquals((Object)"$name", (Object)result2Action2FieldValue1.getValue());
        ActionFieldValue result3Action2FieldValue2 = result2Action2.getFieldValues()[1];
        Assert.assertEquals((Object)"Integer", (Object)result3Action2FieldValue2.getType());
        Assert.assertEquals((Object)"age", (Object)result3Action2FieldValue2.getField());
        Assert.assertEquals((Object)"$age", (Object)result3Action2FieldValue2.getValue());
    }

    @Test
    public void testRHSWithBRLColumn_ParseToDRL() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        Object[][] data = new String[][]{{"1", "desc", "Gargamel", "Pupa", "50"}, {"2", "desc", "Gargamel", "", "50"}, {"3", "desc", "Gargamel", "Pupa", ""}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        ActionInsertFactCol52 a1 = new ActionInsertFactCol52();
        a1.setBoundName("$b");
        a1.setFactType("Baddie");
        a1.setFactField("name");
        a1.setType("String");
        dtable.getActionCols().add(a1);
        BRLActionColumn brl1 = new BRLActionColumn();
        ArrayList<ActionInsertFact> brl1Definition = new ArrayList<ActionInsertFact>();
        ActionInsertFact brl1DefinitionAction1 = new ActionInsertFact("Smurf");
        ActionFieldValue brl1DefinitionAction1FieldValue1 = new ActionFieldValue("name", "$name", "String");
        brl1DefinitionAction1FieldValue1.setNature(7);
        brl1DefinitionAction1.addFieldValue(brl1DefinitionAction1FieldValue1);
        ActionFieldValue brl1DefinitionAction1FieldValue2 = new ActionFieldValue("age", "$age", "Integer");
        brl1DefinitionAction1FieldValue2.setNature(7);
        brl1DefinitionAction1.addFieldValue(brl1DefinitionAction1FieldValue2);
        brl1Definition.add(brl1DefinitionAction1);
        brl1.setDefinition(brl1Definition);
        BRLActionVariableColumn brl1Variable1 = new BRLActionVariableColumn("$name", "String", "Person", "name");
        brl1.getChildColumns().add(brl1Variable1);
        BRLActionVariableColumn brl1Variable2 = new BRLActionVariableColumn("$age", "Integer", "Person", "age");
        brl1.getChildColumns().add(brl1Variable2);
        dtable.getActionCols().add(brl1);
        dtable.setData(DataUtilities.makeDataLists((Object[][])data));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dtable);
        int ruleStartIndex = drl.indexOf("//from row number: 1");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        int action1StartIndex = drl.indexOf("Baddie $b = new Baddie();", ruleStartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("$b.setName( \"Gargamel\" );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("insert( $b );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        int action2StartIndex = drl.indexOf("Smurf fact0 = new Smurf();", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact0.setName( \"Pupa\" );", action2StartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact0.setAge( 50 );", action2StartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("insert( fact0 );", action2StartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 2");
        int ruleEndIndex = drl.indexOf("//from row number: 3");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("Baddie $b = new Baddie();", ruleStartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("$b.setName( \"Gargamel\" );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("insert( $b );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("Smurf fact0 = new Smurf();", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact0.setName(", ruleStartIndex);
        Assert.assertFalse((action2StartIndex < ruleEndIndex ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact0.setAge( 50 );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("insert( fact0 );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 3");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("Baddie $b = new Baddie();", ruleStartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("$b.setName( \"Gargamel\" );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("insert( $b );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("Smurf fact0 = new Smurf();", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact0.setName( \"Pupa\" );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact0.setAge( 50 );", ruleStartIndex);
        Assert.assertTrue((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("insert( fact0 );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSWithBRLColumn_ParseToDRL_MultipleActions() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        Object[][] data = new String[][]{{"1", "desc", "Pupa", "50"}, {"2", "desc", "", "50"}, {"3", "desc", "Pupa", ""}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        BRLActionColumn brl1 = new BRLActionColumn();
        ArrayList<ActionInsertFact> brl1Definition = new ArrayList<ActionInsertFact>();
        ActionInsertFact brl1DefinitionAction1 = new ActionInsertFact("Baddie");
        ActionFieldValue brl1DefinitionAction1FieldValue1 = new ActionFieldValue("name", "Gargamel", "String");
        brl1DefinitionAction1FieldValue1.setNature(1);
        brl1DefinitionAction1.addFieldValue(brl1DefinitionAction1FieldValue1);
        brl1Definition.add(brl1DefinitionAction1);
        ActionInsertFact brl1DefinitionAction2 = new ActionInsertFact("Smurf");
        ActionFieldValue brl1DefinitionAction2FieldValue1 = new ActionFieldValue("name", "$name", "String");
        brl1DefinitionAction2FieldValue1.setNature(7);
        brl1DefinitionAction2.addFieldValue(brl1DefinitionAction2FieldValue1);
        ActionFieldValue brl1DefinitionAction2FieldValue2 = new ActionFieldValue("age", "$age", "Integer");
        brl1DefinitionAction2FieldValue2.setNature(7);
        brl1DefinitionAction2.addFieldValue(brl1DefinitionAction2FieldValue2);
        brl1Definition.add(brl1DefinitionAction2);
        brl1.setDefinition(brl1Definition);
        BRLActionVariableColumn brl1Variable1 = new BRLActionVariableColumn("$name", "String", "Person", "name");
        brl1.getChildColumns().add(brl1Variable1);
        BRLActionVariableColumn brl1Variable2 = new BRLActionVariableColumn("$age", "Integer", "Person", "age");
        brl1.getChildColumns().add(brl1Variable2);
        dtable.getActionCols().add(brl1);
        dtable.setData(DataUtilities.makeDataLists((Object[][])data));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dtable);
        int ruleStartIndex = drl.indexOf("//from row number: 1");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        int action1StartIndex = drl.indexOf("Baddie fact0 = new Baddie();", ruleStartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("fact0.setName( \"Gargamel\" );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("insert( fact0 );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        int action2StartIndex = drl.indexOf("Smurf fact1 = new Smurf();", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact1.setName( \"Pupa\" );", action2StartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact1.setAge( 50 );", action2StartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("insert( fact1 );", action2StartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 2");
        int ruleEndIndex = drl.indexOf("//from row number: 3");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("Baddie fact0 = new Baddie();", ruleStartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("fact0.setName( \"Gargamel\" );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("insert( fact0 );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("Smurf fact1 = new Smurf();", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact1.setName( \"Pupa\" );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex < ruleEndIndex ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact1.setAge( 50 );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("insert( fact1 );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 3");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("Baddie fact0 = new Baddie();", ruleStartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("fact0.setName( \"Gargamel\" );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("insert( fact0 );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("Smurf fact1 = new Smurf();", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact1.setName( \"Pupa\" );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("fact1.setAge( 50 );", ruleStartIndex);
        Assert.assertTrue((action2StartIndex == -1 ? 1 : 0) != 0);
        action2StartIndex = drl.indexOf("insert( fact1 );", ruleStartIndex);
        Assert.assertFalse((action2StartIndex == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSWithBRLColumn_ParseToDRL_NoVariables() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        Object[][] data = new Object[][]{{"1", "desc", Boolean.TRUE}, {"2", "desc", Boolean.FALSE}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        BRLActionColumn brl1 = new BRLActionColumn();
        ArrayList<ActionInsertFact> brl1Definition = new ArrayList<ActionInsertFact>();
        ActionInsertFact brl1DefinitionAction1 = new ActionInsertFact("Baddie");
        ActionFieldValue brl1DefinitionAction1FieldValue1 = new ActionFieldValue("name", "Gargamel", "String");
        brl1DefinitionAction1FieldValue1.setNature(1);
        brl1DefinitionAction1.addFieldValue(brl1DefinitionAction1FieldValue1);
        brl1Definition.add(brl1DefinitionAction1);
        brl1.setDefinition(brl1Definition);
        BRLActionVariableColumn brl1Variable1 = new BRLActionVariableColumn("", "Boolean");
        brl1.getChildColumns().add(brl1Variable1);
        dtable.getActionCols().add(brl1);
        dtable.setData(DataUtilities.makeDataLists((Object[][])data));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dtable);
        int ruleStartIndex = drl.indexOf("//from row number: 1");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        int action1StartIndex = drl.indexOf("Baddie fact0 = new Baddie();", ruleStartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("fact0.setName( \"Gargamel\" );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("insert( fact0 );", action1StartIndex);
        Assert.assertFalse((action1StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 2");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("Baddie fact0 = new Baddie();", ruleStartIndex);
        Assert.assertTrue((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("fact0.setName( \"Gargamel\" );", ruleStartIndex);
        Assert.assertTrue((action1StartIndex == -1 ? 1 : 0) != 0);
        action1StartIndex = drl.indexOf("insert( fact0 );", ruleStartIndex);
        Assert.assertTrue((action1StartIndex == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRHSWithBRLColumn_ParseToDRL_FreeFormLine() {
        GuidedDecisionTable52 dtable = new GuidedDecisionTable52();
        Object[][] data = new String[][]{{"1", "desc", "Pupa", "50"}, {"2", "desc", "", "50"}, {"3", "desc", "Pupa", ""}, {"4", "desc", "", ""}};
        dtable.setRowNumberCol(new RowNumberCol52());
        dtable.setDescriptionCol(new DescriptionCol52());
        BRLActionColumn brl1 = new BRLActionColumn();
        ArrayList<FreeFormLine> brl1Definition = new ArrayList<FreeFormLine>();
        FreeFormLine brl1DefinitionFreeFormLine = new FreeFormLine();
        brl1DefinitionFreeFormLine.setText("System.out.println( \"name == @{name}, age == @{age}\" );");
        brl1Definition.add(brl1DefinitionFreeFormLine);
        brl1.setDefinition(brl1Definition);
        BRLActionVariableColumn brl1Variable1 = new BRLActionVariableColumn("name", "String");
        BRLActionVariableColumn brl1Variable2 = new BRLActionVariableColumn("age", "Integer");
        brl1.getChildColumns().add(brl1Variable1);
        brl1.getChildColumns().add(brl1Variable2);
        dtable.getActionCols().add(brl1);
        dtable.setData(DataUtilities.makeDataLists((Object[][])data));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dtable);
        int ruleStartIndex = drl.indexOf("//from row number: 1");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        int pattern1StartIndex = drl.indexOf("System.out.println( \"name == Pupa, age == 50\" );", ruleStartIndex);
        Assert.assertFalse((pattern1StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 2");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("System.out.println(", ruleStartIndex);
        Assert.assertTrue((pattern1StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 3");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("System.out.println(", ruleStartIndex);
        Assert.assertTrue((pattern1StartIndex == -1 ? 1 : 0) != 0);
        ruleStartIndex = drl.indexOf("//from row number: 4");
        Assert.assertFalse((ruleStartIndex == -1 ? 1 : 0) != 0);
        pattern1StartIndex = drl.indexOf("System.out.println(", ruleStartIndex);
        Assert.assertTrue((pattern1StartIndex == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testPackageNameAndImports() throws Exception {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setPackageName("org.drools.guvnor.models.guided.dtable.backend");
        dt.getImports().addImport(new Import("java.lang.String"));
        dt.setTableName("michael");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("f1");
        p1.setFactType("Driver");
        ConditionCol52 con = new ConditionCol52();
        con.setConstraintValueType(1);
        con.setFactField("age");
        con.setHeader("Driver f1 age");
        con.setOperator("==");
        p1.getChildColumns().add(con);
        dt.getConditions().add(p1);
        dt.setData(DataUtilities.makeDataLists((Object[][])new String[][]{{"1", "desc", "42"}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        Assert.assertTrue((drl.indexOf("package org.drools.guvnor.models.guided.dtable.backend;") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((drl.indexOf("import java.lang.String;") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLHSNonEmptyStringValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        ConditionCol52 cc1 = new ConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("==");
        p1.getChildColumns().add(cc1);
        ConditionCol52 cc2 = new ConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("==");
        p1.getChildColumns().add(cc2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", null, null}, {2L, "desc-row2", "   ", 35L}, {3L, "desc-row3", "", null}, {4L, "desc-row4", "", 35L}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        String expected = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 2\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend\n//from row number: 3\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 4\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 2\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend\n//from row number: 3\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 4\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( age == 35 )\n  then\nend", drl);
    }

    @Test
    public void testLHSDelimitedNonEmptyStringValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        Pattern52 p1 = new Pattern52();
        p1.setBoundName("p1");
        p1.setFactType("Smurf");
        dt.getConditions().add(p1);
        ConditionCol52 cc1 = new ConditionCol52();
        cc1.setConstraintValueType(1);
        cc1.setFieldType("String");
        cc1.setFactField("name");
        cc1.setOperator("==");
        p1.getChildColumns().add(cc1);
        ConditionCol52 cc2 = new ConditionCol52();
        cc2.setConstraintValueType(1);
        cc2.setFieldType("Integer");
        cc2.setFactField("age");
        cc2.setOperator("==");
        p1.getChildColumns().add(cc2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", null, null}, {2L, "desc-row2", "\"   \"", 35L}, {3L, "desc-row3", "\"\"", null}, {4L, "desc-row4", "\"\"", 35L}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        String expected = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 2\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"   \", age == 35 )\n  then\nend\n//from row number: 3\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\" )\n  then\nend\n//from row number: 4\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\", age == 35 )\n  then\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 2\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"   \", age == 35 )\n  then\nend\n//from row number: 3\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\" )\n  then\nend\n//from row number: 4\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n    p1 : Smurf( name == \"\", age == 35 )\n  then\nend", drl);
    }

    @Test
    public void testRHSNonEmptyStringValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        ActionInsertFactCol52 ins1 = new ActionInsertFactCol52();
        ins1.setBoundName("$f");
        ins1.setFactType("Smurf");
        ins1.setFactField("name");
        ins1.setType("String");
        dt.getActionCols().add(ins1);
        ActionInsertFactCol52 ins2 = new ActionInsertFactCol52();
        ins2.setBoundName("$f");
        ins2.setFactType("Smurf");
        ins2.setFactField("age");
        ins2.setType("Integer");
        dt.getActionCols().add(ins2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", null, null}, {2L, "desc-row2", "   ", 35L}, {3L, "desc-row3", "", null}, {4L, "desc-row4", "", 35L}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        String expected = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 2\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setAge( 35 );\n    insert( $f );\nend\n//from row number: 3\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 4\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setAge( 35 );\n    insert( $f );\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 2\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setAge( 35 );\n    insert( $f );\nend\n//from row number: 3\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 4\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setAge( 35 );\n    insert( $f );\nend", drl);
    }

    @Test
    public void testRHSDelimitedNonEmptyStringValues() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setTableFormat(GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        dt.setTableName("extended-entry");
        ActionInsertFactCol52 ins1 = new ActionInsertFactCol52();
        ins1.setBoundName("$f");
        ins1.setFactType("Smurf");
        ins1.setFactField("name");
        ins1.setType("String");
        dt.getActionCols().add(ins1);
        ActionInsertFactCol52 ins2 = new ActionInsertFactCol52();
        ins2.setBoundName("$f");
        ins2.setFactType("Smurf");
        ins2.setFactField("age");
        ins2.setType("Integer");
        dt.getActionCols().add(ins2);
        dt.setData(DataUtilities.makeDataLists((Object[][])new Object[][]{{1L, "desc-row1", null, null}, {2L, "desc-row2", "\"   \"", 35L}, {3L, "desc-row3", "\"\"", null}, {4L, "desc-row4", "\"\"", 35L}}));
        GuidedDTDRLPersistence p = GuidedDTDRLPersistence.getInstance();
        String drl = p.marshal(dt);
        String expected = "//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 2\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setName( \"   \" );\n    $f.setAge( 35 );\n    insert( $f );\nend\n//from row number: 3\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setName( \"\" );\n    insert( $f );\nend\n//from row number: 4\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setName( \"\" );\n    $f.setAge( 35 );\n    insert( $f );\nend";
        this.assertEqualsIgnoreWhitespace("//from row number: 1\n//desc-row1\nrule \"Row 1 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\nend\n//from row number: 2\n//desc-row2\nrule \"Row 2 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setName( \"   \" );\n    $f.setAge( 35 );\n    insert( $f );\nend\n//from row number: 3\n//desc-row3\nrule \"Row 3 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setName( \"\" );\n    insert( $f );\nend\n//from row number: 4\n//desc-row4\nrule \"Row 4 extended-entry\"\n  dialect \"mvel\"\n  when\n  then\n    Smurf $f = new Smurf();\n    $f.setName( \"\" );\n    $f.setAge( 35 );\n    insert( $f );\nend", drl);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }
}

