/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ColumnTestBase;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BRLConditionColumnTest
extends ColumnTestBase {
    private BRLConditionColumn column1;
    private BRLConditionColumn column2;

    @Before
    public void setup() {
        this.column1 = new BRLConditionColumn();
        List<IPattern> definition1 = Arrays.asList(new FactPattern("Mock"));
        this.column1.setDefinition(definition1);
        List<BRLConditionVariableColumn> childColumns1 = Arrays.asList(new BRLConditionVariableColumn("var", "FieldType"));
        this.column1.setChildColumns(childColumns1);
        this.column1.setHeader("header");
        this.column1.setHideColumn(false);
        this.column2 = new BRLConditionColumn();
        List<IPattern> definition2 = Arrays.asList(new FactPattern("Mock"));
        this.column2.setDefinition(definition2);
        List<BRLConditionVariableColumn> childColumns2 = Arrays.asList(new BRLConditionVariableColumn("var", "FieldType"));
        this.column2.setChildColumns(childColumns2);
        this.column2.setHeader("header");
        this.column2.setHideColumn(false);
    }

    @Test
    public void testDiffEmpty() {
        this.checkDiffEmpty((DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffDefinitions() {
        List<IPattern> definition1 = Arrays.asList(new FactPattern("Mock1"));
        this.column1.setDefinition(definition1);
        List<IPattern> definition2 = Arrays.asList(new FactPattern("Mock2"));
        this.column2.setDefinition(definition2);
        this.checkSingleDiff("definition", definition1, definition2, (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffChildColumns() {
        List<BRLConditionVariableColumn> childColumns1 = Arrays.asList(new BRLConditionVariableColumn("var1", "FieldType1"));
        this.column1.setChildColumns(childColumns1);
        List<BRLConditionVariableColumn> childColumns2 = Arrays.asList(new BRLConditionVariableColumn("var2", "FieldType2"));
        this.column2.setChildColumns(childColumns2);
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)2L, (long)diff.size());
        Assert.assertEquals((Object)"fieldType", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)"FieldType1", (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)"FieldType2", (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"varName", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"var1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"var2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
    }

    @Test
    public void testDiffAll() {
        List<IPattern> definition1 = Arrays.asList(new FactPattern("Mock1"));
        this.column1.setDefinition(definition1);
        List<BRLConditionVariableColumn> childColumns1 = Arrays.asList(new BRLConditionVariableColumn("var1", "FieldType1"));
        this.column1.setChildColumns(childColumns1);
        this.column1.setHeader("header1");
        this.column1.setHideColumn(false);
        List<IPattern> definition2 = Arrays.asList(new FactPattern("Mock2"));
        this.column2.setDefinition(definition2);
        List<BRLConditionVariableColumn> childColumns2 = Arrays.asList(new BRLConditionVariableColumn("var2", "FieldType2"));
        this.column2.setChildColumns(childColumns2);
        this.column2.setHeader("header2");
        this.column2.setHideColumn(true);
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((Object)"hideColumn", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"header1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"header2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"definition", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals(definition1, (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals(definition2, (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
        Assert.assertEquals((Object)"fieldType", (Object)((BaseColumnFieldDiff)diff.get(3)).getFieldName());
        Assert.assertEquals((Object)"FieldType1", (Object)((BaseColumnFieldDiff)diff.get(3)).getOldValue());
        Assert.assertEquals((Object)"FieldType2", (Object)((BaseColumnFieldDiff)diff.get(3)).getValue());
        Assert.assertEquals((Object)"varName", (Object)((BaseColumnFieldDiff)diff.get(4)).getFieldName());
        Assert.assertEquals((Object)"var1", (Object)((BaseColumnFieldDiff)diff.get(4)).getOldValue());
        Assert.assertEquals((Object)"var2", (Object)((BaseColumnFieldDiff)diff.get(4)).getValue());
    }
}

