/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.validation.DecisionTableValidator;
import org.drools.workbench.models.guided.dtable.shared.validation.DuplicateAttributeException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DecisionTableValidatorAttributesTest {
    private final String attributeName;
    private GuidedDecisionTable52 table;

    public DecisionTableValidatorAttributesTest(String attributeName) {
        this.attributeName = attributeName;
    }

    @Parameterized.Parameters
    public static Collection<String> attributes() {
        return Arrays.asList("salience", "enabled", "date-effective", "date-expires", "no-loop", "agenda-group", "activation-group", "duration", "timer", "calendars", "auto-focus", "lock-on-active", "ruleflow-group", "dialect", "negate");
    }

    @Test(expected=DuplicateAttributeException.class)
    public void addAttributeColumn() throws Exception {
        DecisionTableValidator validator = this.getDecisionTableValidator();
        AttributeCol52 attributeCol52 = new AttributeCol52();
        attributeCol52.setAttribute(this.attributeName);
        try {
            validator.isValidToAdd(attributeCol52);
        }
        catch (Exception e) {
            Assert.fail((String)"First addition should be valid.");
        }
        this.addAttributeCol(attributeCol52);
        validator.isValidToAdd(attributeCol52);
    }

    private DecisionTableValidator getDecisionTableValidator() {
        this.table = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)this.table.getHitPolicy()).thenReturn((Object)GuidedDecisionTable52.HitPolicy.NONE);
        return new DecisionTableValidator(this.table);
    }

    private void addAttributeCol(AttributeCol52 attributeCol52) {
        ArrayList<AttributeCol52> attributeCol52s = new ArrayList<AttributeCol52>();
        Mockito.when((Object)this.table.getAttributeCols()).thenReturn(attributeCol52s);
        attributeCol52s.add(attributeCol52);
    }
}

