/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.backend;

import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.backend.TestUtil;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.junit.Assert;
import org.junit.Test;

public class HitPolicyPersistenceTest {
    @Test
    public void testDefault() throws Exception {
        Assert.assertEquals((Object)GuidedDecisionTable52.HitPolicy.NONE, (Object)new GuidedDecisionTable52().getHitPolicy());
    }

    @Test
    public void testRoundTrip() {
        GuidedDecisionTable52 dt = new GuidedDecisionTable52();
        dt.setHitPolicy(GuidedDecisionTable52.HitPolicy.FIRST_HIT);
        String xml = GuidedDTXMLPersistence.getInstance().marshal(dt);
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((boolean)xml.contains("<hitPolicy>FIRST_HIT</hitPolicy>"));
        GuidedDecisionTable52 dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertEquals((Object)GuidedDecisionTable52.HitPolicy.FIRST_HIT, (Object)dt_.getHitPolicy());
    }

    @Test
    public void testBackwardsCompatibility() throws Exception {
        String xml = TestUtil.loadResource("ExistingDecisionTable.xml");
        GuidedDecisionTable52 dt_ = GuidedDTXMLPersistence.getInstance().unmarshal(xml);
        Assert.assertNotNull((Object)dt_);
        Assert.assertEquals((Object)GuidedDecisionTable52.HitPolicy.NONE, (Object)dt_.getHitPolicy());
    }
}

