/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.List;
import java.util.Objects;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ColumnTestBase;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConditionCol52Test
extends ColumnTestBase {
    private ConditionCol52 column1;
    private ConditionCol52 column2;

    @Before
    public void setup() {
        this.column1 = new ConditionCol52();
        this.column1.setFactField("field");
        this.column1.setFieldType("Type");
        this.column1.setOperator("==");
        this.column1.setValueList("a,b,c");
        this.column1.setBinding("$var");
        this.column1.setConstraintValueType(1);
        this.column1.setHeader("header");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default"));
        this.column2 = new ConditionCol52();
        this.column2.setFactField("field");
        this.column2.setFieldType("Type");
        this.column2.setOperator("==");
        this.column2.setValueList("a,b,c");
        this.column2.setBinding("$var");
        this.column2.setConstraintValueType(1);
        this.column2.setHeader("header");
        this.column2.setHideColumn(false);
        this.column2.setDefaultValue(new DTCellValue52("default"));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)Objects.equals(this.column1, this.column2));
    }

    @Test
    public void testEqualsWithParametersCall() {
        this.column1.getParameters();
        Assert.assertTrue((boolean)Objects.equals(this.column1, this.column2));
    }

    @Test
    public void testDiffEmpty() {
        this.checkDiffEmpty((DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffFactField() {
        this.column1.setFactField("field1");
        this.column2.setFactField("field2");
        this.checkSingleDiff("factField", (Object)"field1", (Object)"field2", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffFieldType() {
        this.column1.setFieldType("Type1");
        this.column2.setFieldType("Type2");
        this.checkSingleDiff("fieldType", (Object)"Type1", (Object)"Type2", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffOperator() {
        this.column1.setOperator("<");
        this.column2.setOperator(">");
        this.checkSingleDiff("operator", (Object)"<", (Object)">", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffValueList() {
        this.column1.setValueList("v,a,l,u,e");
        this.column2.setValueList("l,i,s,t");
        this.checkSingleDiff("valueList", (Object)"v,a,l,u,e", (Object)"l,i,s,t", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffBinding() {
        this.column1.setBinding("$var1");
        this.column2.setBinding("$var2");
        this.checkSingleDiff("binding", (Object)"$var1", (Object)"$var2", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffConstraintType() {
        this.column1.setConstraintValueType(5);
        this.column2.setConstraintValueType(3);
        this.checkSingleDiff("constraintValueType", (Object)5, (Object)3, (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffDefaultValueOriginalValueIsNull() {
        this.column1.setDefaultValue(null);
        this.column2.setDefaultValue(new DTCellValue52("default"));
        this.checkSingleDiff("defaultValue", null, (Object)"default", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffDefaultValueNewValueIsNull() {
        this.column1.setDefaultValue(new DTCellValue52("default"));
        this.column2.setDefaultValue(null);
        this.checkSingleDiff("defaultValue", (Object)"default", null, (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffAll() {
        this.column1.setFactField("field1");
        this.column1.setFieldType("Type1");
        this.column1.setOperator("<");
        this.column1.setValueList("v,a,l,u,e");
        this.column1.setBinding("$var1");
        this.column1.setConstraintValueType(5);
        this.column1.setHeader("header1");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default1"));
        this.column2.setFactField("field2");
        this.column2.setFieldType("Type2");
        this.column2.setOperator(">");
        this.column2.setValueList("l,i,s,t");
        this.column2.setBinding("$var2");
        this.column2.setConstraintValueType(3);
        this.column2.setHeader("header2");
        this.column2.setHideColumn(true);
        this.column2.setDefaultValue(new DTCellValue52("default2"));
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)9L, (long)diff.size());
        Assert.assertEquals((Object)"hideColumn", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"defaultValue", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"default1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"default2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals((Object)"header1", (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)"header2", (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
        Assert.assertEquals((Object)"factField", (Object)((BaseColumnFieldDiff)diff.get(3)).getFieldName());
        Assert.assertEquals((Object)"field1", (Object)((BaseColumnFieldDiff)diff.get(3)).getOldValue());
        Assert.assertEquals((Object)"field2", (Object)((BaseColumnFieldDiff)diff.get(3)).getValue());
        Assert.assertEquals((Object)"fieldType", (Object)((BaseColumnFieldDiff)diff.get(4)).getFieldName());
        Assert.assertEquals((Object)"Type1", (Object)((BaseColumnFieldDiff)diff.get(4)).getOldValue());
        Assert.assertEquals((Object)"Type2", (Object)((BaseColumnFieldDiff)diff.get(4)).getValue());
        Assert.assertEquals((Object)"operator", (Object)((BaseColumnFieldDiff)diff.get(5)).getFieldName());
        Assert.assertEquals((Object)"<", (Object)((BaseColumnFieldDiff)diff.get(5)).getOldValue());
        Assert.assertEquals((Object)">", (Object)((BaseColumnFieldDiff)diff.get(5)).getValue());
        Assert.assertEquals((Object)"valueList", (Object)((BaseColumnFieldDiff)diff.get(6)).getFieldName());
        Assert.assertEquals((Object)"v,a,l,u,e", (Object)((BaseColumnFieldDiff)diff.get(6)).getOldValue());
        Assert.assertEquals((Object)"l,i,s,t", (Object)((BaseColumnFieldDiff)diff.get(6)).getValue());
        Assert.assertEquals((Object)"binding", (Object)((BaseColumnFieldDiff)diff.get(7)).getFieldName());
        Assert.assertEquals((Object)"$var1", (Object)((BaseColumnFieldDiff)diff.get(7)).getOldValue());
        Assert.assertEquals((Object)"$var2", (Object)((BaseColumnFieldDiff)diff.get(7)).getValue());
        Assert.assertEquals((Object)"constraintValueType", (Object)((BaseColumnFieldDiff)diff.get(8)).getFieldName());
        Assert.assertEquals((Object)5, (Object)((BaseColumnFieldDiff)diff.get(8)).getOldValue());
        Assert.assertEquals((Object)3, (Object)((BaseColumnFieldDiff)diff.get(8)).getValue());
    }
}

