/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.ColumnTestBase;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataCol52Test
extends ColumnTestBase {
    private MetadataCol52 column1;
    private MetadataCol52 column2;

    @Before
    public void setup() {
        this.column1 = new MetadataCol52();
        this.column1.setMetadata("meta");
        this.column1.setHeader("header");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default"));
        this.column2 = new MetadataCol52();
        this.column2.setMetadata("meta");
        this.column2.setHeader("header");
        this.column2.setHideColumn(false);
        this.column2.setDefaultValue(new DTCellValue52("default"));
    }

    @Test
    public void testDiffEmpty() {
        this.checkDiffEmpty((DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffMetadata() {
        this.column1.setMetadata("meta1");
        this.column2.setMetadata("meta2");
        this.checkSingleDiff("metadata", (Object)"meta1", (Object)"meta2", (DTColumnConfig52)this.column1, (DTColumnConfig52)this.column2);
    }

    @Test
    public void testDiffAll() {
        this.column1.setMetadata("meta1");
        this.column1.setHeader("header1");
        this.column1.setHideColumn(false);
        this.column1.setDefaultValue(new DTCellValue52("default1"));
        this.column2.setMetadata("meta2");
        this.column2.setHeader("header2");
        this.column2.setHideColumn(true);
        this.column2.setDefaultValue(new DTCellValue52("default2"));
        List diff = this.column1.diff((BaseColumn)this.column2);
        Assert.assertNotNull((Object)diff);
        Assert.assertEquals((long)4L, (long)diff.size());
        Assert.assertEquals((Object)"hideColumn", (Object)((BaseColumnFieldDiff)diff.get(0)).getFieldName());
        Assert.assertEquals((Object)false, (Object)((BaseColumnFieldDiff)diff.get(0)).getOldValue());
        Assert.assertEquals((Object)true, (Object)((BaseColumnFieldDiff)diff.get(0)).getValue());
        Assert.assertEquals((Object)"defaultValue", (Object)((BaseColumnFieldDiff)diff.get(1)).getFieldName());
        Assert.assertEquals((Object)"default1", (Object)((BaseColumnFieldDiff)diff.get(1)).getOldValue());
        Assert.assertEquals((Object)"default2", (Object)((BaseColumnFieldDiff)diff.get(1)).getValue());
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diff.get(2)).getFieldName());
        Assert.assertEquals((Object)"header1", (Object)((BaseColumnFieldDiff)diff.get(2)).getOldValue());
        Assert.assertEquals((Object)"header2", (Object)((BaseColumnFieldDiff)diff.get(2)).getValue());
        Assert.assertEquals((Object)"metadata", (Object)((BaseColumnFieldDiff)diff.get(3)).getFieldName());
        Assert.assertEquals((Object)"meta1", (Object)((BaseColumnFieldDiff)diff.get(3)).getOldValue());
        Assert.assertEquals((Object)"meta2", (Object)((BaseColumnFieldDiff)diff.get(3)).getValue());
    }

    @Test
    public void testCloneColumn() {
        this.column1.setWidth(10);
        MetadataCol52 clone = this.column1.cloneColumn();
        Assert.assertEquals((Object)this.column1.getMetadata(), (Object)clone.getMetadata());
        Assert.assertEquals((Object)this.column1.getHeader(), (Object)clone.getHeader());
        Assert.assertEquals((long)this.column1.getWidth(), (long)clone.getWidth());
        Assert.assertEquals((Object)this.column1.isHideColumn(), (Object)clone.isHideColumn());
        Assert.assertEquals((Object)this.column1.getDefaultValue(), (Object)clone.getDefaultValue());
    }
}

