/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.models.guided.dtable.shared.model;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DTCellValue52Test {
    private DTCellValue52 dcv;
    private Field fieldBoolean;
    private Field fieldDate;
    private Field fieldNumeric;
    private Field fieldString;
    private Field fieldDataType;
    private static final Date now = Calendar.getInstance().getTime();

    @Before
    public void setup() throws Exception {
        this.dcv = new DTCellValue52();
        Class<?> c = this.dcv.getClass();
        this.fieldBoolean = c.getDeclaredField("valueBoolean");
        this.fieldDate = c.getDeclaredField("valueDate");
        this.fieldNumeric = c.getDeclaredField("valueNumeric");
        this.fieldString = c.getDeclaredField("valueString");
        this.fieldDataType = c.getDeclaredField("dataType");
        this.fieldBoolean.setAccessible(true);
        this.fieldDate.setAccessible(true);
        this.fieldNumeric.setAccessible(true);
        this.fieldString.setAccessible(true);
        this.fieldDataType.setAccessible(true);
    }

    @Test
    public void testGetBooleanValue() throws Exception {
        this.dcv.setBooleanValue(Boolean.valueOf(true));
        this.fieldDate.set(this.dcv, now);
        this.fieldNumeric.set(this.dcv, 1L);
        this.fieldString.set(this.dcv, "woot");
        Assert.assertEquals((Object)DataType.DataTypes.BOOLEAN, (Object)this.dcv.getDataType());
        Assert.assertTrue((boolean)this.dcv.getBooleanValue());
        Assert.assertNull((Object)this.dcv.getDateValue());
        Assert.assertNull((Object)this.dcv.getNumericValue());
        Assert.assertNull((Object)this.dcv.getStringValue());
    }

    @Test
    public void testGetDateValue() throws Exception {
        this.fieldBoolean.set(this.dcv, true);
        this.dcv.setDateValue(now);
        this.fieldNumeric.set(this.dcv, 1L);
        this.fieldString.set(this.dcv, "woot");
        Assert.assertEquals((Object)DataType.DataTypes.DATE, (Object)this.dcv.getDataType());
        Assert.assertNull((Object)this.dcv.getBooleanValue());
        Assert.assertEquals((Object)now, (Object)this.dcv.getDateValue());
        Assert.assertNull((Object)this.dcv.getNumericValue());
        Assert.assertNull((Object)this.dcv.getStringValue());
    }

    @Test
    public void testGetNumericValue() throws Exception {
        this.fieldBoolean.set(this.dcv, true);
        this.fieldDate.set(this.dcv, now);
        this.dcv.setNumericValue(Long.valueOf(1L));
        this.fieldString.set(this.dcv, "woot");
        Assert.assertEquals((Object)DataType.DataTypes.NUMERIC_LONG, (Object)this.dcv.getDataType());
        Assert.assertNull((Object)this.dcv.getBooleanValue());
        Assert.assertNull((Object)this.dcv.getDateValue());
        Assert.assertEquals((Object)1L, (Object)this.dcv.getNumericValue());
        Assert.assertNull((Object)this.dcv.getStringValue());
    }

    @Test
    public void testGetStringValue() throws Exception {
        this.fieldBoolean.set(this.dcv, true);
        this.fieldDate.set(this.dcv, now);
        this.fieldNumeric.set(this.dcv, 1L);
        this.dcv.setStringValue("woot");
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)this.dcv.getDataType());
        Assert.assertNull((Object)this.dcv.getBooleanValue());
        Assert.assertNull((Object)this.dcv.getDateValue());
        Assert.assertNull((Object)this.dcv.getNumericValue());
        Assert.assertEquals((Object)"woot", (Object)this.dcv.getStringValue());
    }

    @Test
    public void testDefaultValue() throws Exception {
        DTCellValue52 defaultValue = new DTCellValue52(Integer.valueOf(1));
        DTCellValue52 clone = new DTCellValue52(defaultValue);
        Assert.assertEquals((Object)DataType.DataTypes.NUMERIC_INTEGER, (Object)clone.getDataType());
        Assert.assertNull((Object)clone.getBooleanValue());
        Assert.assertNull((Object)clone.getDateValue());
        Assert.assertEquals((Object)1, (Object)clone.getNumericValue());
        Assert.assertNull((Object)clone.getStringValue());
    }

    @Test
    public void testDefaultValueNull() throws Exception {
        DTCellValue52 defaultValue = null;
        DTCellValue52 clone = new DTCellValue52(defaultValue);
        Assert.assertEquals((Object)DataType.DataTypes.STRING, (Object)clone.getDataType());
        Assert.assertNull((Object)clone.getBooleanValue());
        Assert.assertNull((Object)clone.getDateValue());
        Assert.assertNull((Object)clone.getNumericValue());
        Assert.assertNull((Object)clone.getStringValue());
    }
}

